/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.utils;

import java.nio.charset.Charset;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.knowm.xchange.utils.Assert;
import org.knowm.xchange.utils.DigestUtils;

public class HmacDigest {
    private final Charset utf8 = Charset.forName("UTF-8");
    private final Mac mac;

    public HmacDigest(String algorithm, String secretKey) {
        Assert.notNull(algorithm, "Null algorithm");
        Assert.notNull(secretKey, "Null secretKey");
        try {
            this.mac = Mac.getInstance(algorithm);
            this.mac.init(new SecretKeySpec(secretKey.getBytes(this.utf8), this.mac.getAlgorithm()));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public String hexDigest(String message) {
        byte[] bytes = this.mac.doFinal(message.getBytes(this.utf8));
        return DigestUtils.bytesToHex(bytes);
    }
}

