/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.dto.trade;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.marketdata.Trade;

@JsonDeserialize(builder=Builder.class)
public class UserTrade
extends Trade {
    private static final long serialVersionUID = -3021617981214969292L;
    private final String orderId;
    private final BigDecimal feeAmount;
    private final Currency feeCurrency;
    private final String orderUserReference;

    public UserTrade(Order.OrderType type, BigDecimal originalAmount, CurrencyPair currencyPair, BigDecimal price, Date timestamp, String id, String orderId, BigDecimal feeAmount, Currency feeCurrency, String orderUserReference) {
        super(type, originalAmount, currencyPair, price, timestamp, id, null, null);
        this.orderId = orderId;
        this.feeAmount = feeAmount;
        this.feeCurrency = feeCurrency;
        this.orderUserReference = orderUserReference;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public BigDecimal getFeeAmount() {
        return this.feeAmount;
    }

    public Currency getFeeCurrency() {
        return this.feeCurrency;
    }

    public String getOrderUserReference() {
        return this.orderUserReference;
    }

    @Override
    public String toString() {
        return "UserTrade[type=" + (Object)((Object)this.type) + ", originalAmount=" + this.originalAmount + ", currencyPair=" + this.currencyPair + ", price=" + this.price + ", timestamp=" + this.timestamp + ", id=" + this.id + ", orderId='" + this.orderId + '\'' + ", feeAmount=" + this.feeAmount + ", feeCurrency='" + this.feeCurrency + '\'' + ", orderUserReference='" + this.orderUserReference + '\'' + "]";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UserTrade userTrade = (UserTrade)o;
        return Objects.equals(this.orderId, userTrade.orderId) && Objects.equals(this.feeAmount, userTrade.feeAmount) && Objects.equals(this.feeCurrency, userTrade.feeCurrency);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.orderId, this.feeAmount, this.feeCurrency);
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder
    extends Trade.Builder {
        protected String orderId;
        protected BigDecimal feeAmount;
        protected Currency feeCurrency;
        protected String orderUserReference;

        public static Builder from(UserTrade trade) {
            return new Builder().type(trade.getType()).originalAmount(trade.getOriginalAmount()).currencyPair(trade.getCurrencyPair()).price(trade.getPrice()).timestamp(trade.getTimestamp()).id(trade.getId()).orderId(trade.getOrderId()).feeAmount(trade.getFeeAmount()).feeCurrency(trade.getFeeCurrency());
        }

        @Override
        public Builder type(Order.OrderType type) {
            return (Builder)super.type(type);
        }

        @Override
        public Builder originalAmount(BigDecimal originalAmount) {
            return (Builder)super.originalAmount(originalAmount);
        }

        @Override
        public Builder currencyPair(CurrencyPair currencyPair) {
            return (Builder)super.currencyPair(currencyPair);
        }

        @Override
        public Builder price(BigDecimal price) {
            return (Builder)super.price(price);
        }

        @Override
        public Builder timestamp(Date timestamp) {
            return (Builder)super.timestamp(timestamp);
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        public Builder orderId(String orderId) {
            this.orderId = orderId;
            return this;
        }

        public Builder feeAmount(BigDecimal feeAmount) {
            this.feeAmount = feeAmount;
            return this;
        }

        public Builder feeCurrency(Currency feeCurrency) {
            this.feeCurrency = feeCurrency;
            return this;
        }

        public Builder orderUserReference(String orderUserReference) {
            this.orderUserReference = orderUserReference;
            return this;
        }

        @Override
        public UserTrade build() {
            return new UserTrade(this.type, this.originalAmount, this.currencyPair, this.price, this.timestamp, this.id, this.orderId, this.feeAmount, this.feeCurrency, this.orderUserReference);
        }
    }
}

