/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.dto.trade;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;

@JsonDeserialize(builder=Builder.class)
public class MarketOrder
extends Order {
    private static final long serialVersionUID = -3393286268772319210L;

    public MarketOrder(Order.OrderType type, BigDecimal originalAmount, CurrencyPair currencyPair, String id, Date timestamp, BigDecimal averagePrice, BigDecimal cumulativeAmount, BigDecimal fee, Order.OrderStatus status, String userReference) {
        super(type, originalAmount, currencyPair, id, timestamp, averagePrice, cumulativeAmount, fee, status, userReference);
    }

    public MarketOrder(Order.OrderType type, BigDecimal originalAmount, CurrencyPair currencyPair, String id, Date timestamp, BigDecimal averagePrice, BigDecimal cumulativeAmount, BigDecimal fee, Order.OrderStatus status) {
        super(type, originalAmount, currencyPair, id, timestamp, averagePrice, cumulativeAmount, fee, status);
    }

    public MarketOrder(Order.OrderType type, BigDecimal originalAmount, CurrencyPair currencyPair, String id, Date timestamp) {
        super(type, originalAmount, currencyPair, id, timestamp);
    }

    public MarketOrder(Order.OrderType type, BigDecimal originalAmount, CurrencyPair currencyPair, Date timestamp) {
        super(type, originalAmount, currencyPair, "", timestamp);
    }

    public MarketOrder(Order.OrderType type, BigDecimal originalAmount, CurrencyPair currencyPair) {
        super(type, originalAmount, currencyPair, "", null);
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder
    extends Order.Builder {
        @JsonCreator
        public Builder(@JsonProperty(value="orderType") Order.OrderType orderType, @JsonProperty(value="currencyPair") CurrencyPair currencyPair) {
            super(orderType, currencyPair);
        }

        public static Builder from(Order order) {
            return ((Builder)new Builder(order.getType(), order.getCurrencyPair()).originalAmount(order.getOriginalAmount()).cumulativeAmount(order.getCumulativeAmount()).timestamp(order.getTimestamp()).id(order.getId()).flags((Set)order.getOrderFlags())).averagePrice(order.getAveragePrice()).fee(order.getFee()).userReference(order.getUserReference()).orderStatus(order.getStatus());
        }

        @Override
        public Builder orderType(Order.OrderType orderType) {
            return (Builder)super.orderType(orderType);
        }

        @Override
        public Builder orderStatus(Order.OrderStatus status) {
            return (Builder)super.orderStatus(status);
        }

        @Override
        public Builder averagePrice(BigDecimal averagePrice) {
            return (Builder)super.averagePrice(averagePrice);
        }

        @Override
        public Builder cumulativeAmount(BigDecimal cumulativeAmount) {
            return (Builder)super.cumulativeAmount(cumulativeAmount);
        }

        @Override
        public Builder fee(BigDecimal fee) {
            return (Builder)super.fee(fee);
        }

        @Override
        public Builder originalAmount(BigDecimal originalAmount) {
            return (Builder)super.originalAmount(originalAmount);
        }

        @Override
        public Builder currencyPair(CurrencyPair currencyPair) {
            return (Builder)super.currencyPair(currencyPair);
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder userReference(String userReference) {
            return (Builder)super.userReference(userReference);
        }

        @Override
        public Builder timestamp(Date timestamp) {
            return (Builder)super.timestamp(timestamp);
        }

        @Override
        public Builder flags(Set<Order.IOrderFlags> flags) {
            return (Builder)super.flags(flags);
        }

        @Override
        public Builder flag(Order.IOrderFlags flag) {
            return (Builder)super.flag(flag);
        }

        @Override
        public MarketOrder build() {
            MarketOrder order = new MarketOrder(this.orderType, this.originalAmount, this.currencyPair, this.id, this.timestamp, this.averagePrice, this.cumulativeAmount, this.fee, this.status, this.userReference);
            order.setOrderFlags(this.flags);
            order.setLeverage(this.leverage);
            return order;
        }
    }
}

