/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.dto.account;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.io.Serializable;
import java.math.BigDecimal;
import org.knowm.xchange.currency.Currency;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
public final class Balance
implements Comparable<Balance>,
Serializable {
    private static final long serialVersionUID = -1460694403597268635L;
    private static final Logger log = LoggerFactory.getLogger(Balance.class);
    private final Currency currency;
    private final BigDecimal total;
    private final BigDecimal available;
    private final BigDecimal frozen;
    private final BigDecimal loaned;
    private final BigDecimal borrowed;
    private final BigDecimal withdrawing;
    private final BigDecimal depositing;

    public Balance(Currency currency, BigDecimal total) {
        this(currency, total, total, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
    }

    public Balance(Currency currency, BigDecimal total, BigDecimal available) {
        this(currency, total, available, total.add(available.negate()), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
    }

    public Balance(Currency currency, BigDecimal total, BigDecimal available, BigDecimal frozen) {
        this(currency, total, available, frozen, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
    }

    public Balance(Currency currency, BigDecimal total, BigDecimal available, BigDecimal frozen, BigDecimal borrowed, BigDecimal loaned, BigDecimal withdrawing, BigDecimal depositing) {
        BigDecimal sum;
        if (total != null && available != null && 0 != total.compareTo(sum = available.add(frozen).subtract(borrowed).add(loaned).add(withdrawing).add(depositing))) {
            log.warn("{} = total != available + frozen - borrowed + loaned + withdrawing + depositing = {}", (Object)total, (Object)sum);
        }
        this.currency = currency;
        this.total = total;
        this.available = available;
        this.frozen = frozen;
        this.borrowed = borrowed;
        this.loaned = loaned;
        this.withdrawing = withdrawing;
        this.depositing = depositing;
    }

    public static Balance zero(Currency currency) {
        return new Balance(currency, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO);
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public BigDecimal getTotal() {
        if (this.total == null) {
            return this.available.add(this.frozen).subtract(this.borrowed).add(this.loaned).add(this.withdrawing).add(this.depositing);
        }
        return this.total;
    }

    public BigDecimal getAvailable() {
        if (this.available == null) {
            return this.total.subtract(this.frozen).subtract(this.loaned).add(this.borrowed).subtract(this.withdrawing).subtract(this.depositing);
        }
        return this.available;
    }

    @JsonIgnore
    public BigDecimal getAvailableForWithdrawal() {
        return this.getAvailable().subtract(this.getBorrowed());
    }

    public BigDecimal getFrozen() {
        if (this.frozen == null) {
            return this.total.subtract(this.available);
        }
        return this.frozen;
    }

    public BigDecimal getBorrowed() {
        return this.borrowed;
    }

    public BigDecimal getLoaned() {
        return this.loaned;
    }

    public BigDecimal getWithdrawing() {
        return this.withdrawing;
    }

    public BigDecimal getDepositing() {
        return this.depositing;
    }

    public String toString() {
        return "Balance [currency=" + this.currency + ", total=" + this.total + ", available=" + this.available + ", frozen=" + this.frozen + ", borrowed=" + this.borrowed + ", loaned=" + this.loaned + ", withdrawing=" + this.withdrawing + ", depositing=" + this.depositing + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.total == null ? 0 : this.total.hashCode());
        result = 31 * result + (this.currency == null ? 0 : this.currency.hashCode());
        result = 31 * result + (this.available == null ? 0 : this.available.hashCode());
        result = 31 * result + (this.frozen == null ? 0 : this.frozen.hashCode());
        result = 31 * result + (this.borrowed == null ? 0 : this.borrowed.hashCode());
        result = 31 * result + (this.loaned == null ? 0 : this.loaned.hashCode());
        result = 31 * result + (this.withdrawing == null ? 0 : this.withdrawing.hashCode());
        result = 31 * result + (this.depositing == null ? 0 : this.depositing.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Balance other = (Balance)obj;
        if (this.total == null ? other.total != null : !this.total.equals(other.total)) {
            return false;
        }
        if (this.available == null ? other.available != null : !this.available.equals(other.available)) {
            return false;
        }
        if (this.frozen == null ? other.frozen != null : !this.frozen.equals(other.frozen)) {
            return false;
        }
        if (this.currency == null ? other.currency != null : !this.currency.equals(other.currency)) {
            return false;
        }
        if (this.borrowed == null ? other.borrowed != null : !this.borrowed.equals(other.borrowed)) {
            return false;
        }
        if (this.loaned == null ? other.loaned != null : !this.loaned.equals(other.loaned)) {
            return false;
        }
        if (this.withdrawing == null ? other.withdrawing != null : !this.withdrawing.equals(other.withdrawing)) {
            return false;
        }
        return !(this.depositing == null ? other.depositing != null : !this.depositing.equals(other.depositing));
    }

    @Override
    public int compareTo(Balance other) {
        int comparison = this.currency.compareTo(other.currency);
        if (comparison != 0) {
            return comparison;
        }
        comparison = this.total.compareTo(other.total);
        if (comparison != 0) {
            return comparison;
        }
        comparison = this.available.compareTo(other.available);
        if (comparison != 0) {
            return comparison;
        }
        comparison = this.frozen.compareTo(other.frozen);
        if (comparison != 0) {
            return comparison;
        }
        comparison = this.borrowed.compareTo(other.borrowed);
        if (comparison != 0) {
            return comparison;
        }
        comparison = this.loaned.compareTo(other.loaned);
        if (comparison != 0) {
            return comparison;
        }
        comparison = this.withdrawing.compareTo(other.withdrawing);
        if (comparison != 0) {
            return comparison;
        }
        comparison = this.depositing.compareTo(other.depositing);
        return comparison;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        private Currency currency;
        private BigDecimal total;
        private BigDecimal available;
        private BigDecimal frozen;
        private BigDecimal borrowed = BigDecimal.ZERO;
        private BigDecimal loaned = BigDecimal.ZERO;
        private BigDecimal withdrawing = BigDecimal.ZERO;
        private BigDecimal depositing = BigDecimal.ZERO;

        public static Builder from(Balance balance) {
            return new Builder().currency(balance.getCurrency()).total(balance.getTotal()).available(balance.getAvailable()).frozen(balance.getFrozen()).borrowed(balance.getBorrowed()).loaned(balance.getLoaned()).withdrawing(balance.getWithdrawing()).depositing(balance.getDepositing());
        }

        public Builder currency(Currency currency) {
            this.currency = currency;
            return this;
        }

        public Builder total(BigDecimal total) {
            this.total = total;
            return this;
        }

        public Builder available(BigDecimal available) {
            this.available = available;
            return this;
        }

        public Builder frozen(BigDecimal frozen) {
            this.frozen = frozen;
            return this;
        }

        public Builder borrowed(BigDecimal borrowed) {
            this.borrowed = borrowed;
            return this;
        }

        public Builder loaned(BigDecimal loaned) {
            this.loaned = loaned;
            return this;
        }

        public Builder withdrawing(BigDecimal withdrawing) {
            this.withdrawing = withdrawing;
            return this;
        }

        public Builder depositing(BigDecimal depositing) {
            this.depositing = depositing;
            return this;
        }

        public Balance build() {
            if (this.frozen == null && (this.total == null || this.available == null)) {
                this.frozen = BigDecimal.ZERO;
            }
            return new Balance(this.currency, this.total, this.available, this.frozen, this.borrowed, this.loaned, this.withdrawing, this.depositing);
        }
    }
}

