/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.binance;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.knowm.xchange.BaseExchange;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.binance.Binance;
import org.knowm.xchange.binance.BinanceAdapters;
import org.knowm.xchange.binance.dto.account.AssetDetail;
import org.knowm.xchange.binance.dto.meta.exchangeinfo.BinanceExchangeInfo;
import org.knowm.xchange.binance.dto.meta.exchangeinfo.Filter;
import org.knowm.xchange.binance.dto.meta.exchangeinfo.Symbol;
import org.knowm.xchange.binance.service.BinanceAccountService;
import org.knowm.xchange.binance.service.BinanceMarketDataService;
import org.knowm.xchange.binance.service.BinanceTradeService;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.meta.CurrencyMetaData;
import org.knowm.xchange.dto.meta.CurrencyPairMetaData;
import org.knowm.xchange.exceptions.ExchangeException;
import org.knowm.xchange.utils.AuthUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import si.mazi.rescu.RestProxyFactory;
import si.mazi.rescu.SynchronizedValueFactory;

public class BinanceExchange
extends BaseExchange {
    private static final Logger LOG = LoggerFactory.getLogger(BinanceExchange.class);
    private BinanceExchangeInfo exchangeInfo;
    private Long deltaServerTimeExpire;
    private Long deltaServerTime;

    protected void initServices() {
        this.marketDataService = new BinanceMarketDataService((Exchange)this);
        this.tradeService = new BinanceTradeService((Exchange)this);
        this.accountService = new BinanceAccountService((Exchange)this);
    }

    public SynchronizedValueFactory<Long> getNonceFactory() {
        throw new UnsupportedOperationException("Binance uses timestamp/recvwindow rather than a nonce");
    }

    public ExchangeSpecification getDefaultExchangeSpecification() {
        ExchangeSpecification spec = new ExchangeSpecification(((Object)((Object)this)).getClass().getCanonicalName());
        spec.setSslUri("https://api.binance.com");
        spec.setHost("www.binance.com");
        spec.setPort(80);
        spec.setExchangeName("Binance");
        spec.setExchangeDescription("Binance Exchange.");
        AuthUtils.setApiAndSecretKey((ExchangeSpecification)spec, (String)"binance");
        return spec;
    }

    public BinanceExchangeInfo getExchangeInfo() {
        return this.exchangeInfo;
    }

    public void remoteInit() {
        try {
            Map currencyPairs = this.exchangeMetaData.getCurrencyPairs();
            Map currencies = this.exchangeMetaData.getCurrencies();
            BinanceMarketDataService marketDataService = (BinanceMarketDataService)this.marketDataService;
            this.exchangeInfo = marketDataService.getExchangeInfo();
            Symbol[] symbols = this.exchangeInfo.getSymbols();
            BinanceAccountService accountService = (BinanceAccountService)this.getAccountService();
            Map<String, AssetDetail> assetDetailMap = accountService.getAssetDetails();
            if (assetDetailMap != null) {
                currencies.clear();
            }
            for (Symbol symbol : symbols) {
                if (!symbol.getStatus().equals("TRADING")) continue;
                int basePrecision = Integer.parseInt(symbol.getBaseAssetPrecision());
                int counterPrecision = Integer.parseInt(symbol.getQuotePrecision());
                int pairPrecision = 8;
                int amountPrecision = 8;
                BigDecimal minQty = null;
                BigDecimal maxQty = null;
                BigDecimal stepSize = null;
                BigDecimal counterMinQty = null;
                BigDecimal counterMaxQty = null;
                Filter[] filters = symbol.getFilters();
                CurrencyPair currentCurrencyPair = new CurrencyPair(symbol.getBaseAsset(), symbol.getQuoteAsset());
                for (Filter filter : filters) {
                    if (filter.getFilterType().equals("PRICE_FILTER")) {
                        pairPrecision = Math.min(pairPrecision, this.numberOfDecimals(filter.getTickSize()));
                        counterMaxQty = new BigDecimal(filter.getMaxPrice()).stripTrailingZeros();
                        continue;
                    }
                    if (filter.getFilterType().equals("LOT_SIZE")) {
                        amountPrecision = Math.min(amountPrecision, this.numberOfDecimals(filter.getStepSize()));
                        minQty = new BigDecimal(filter.getMinQty()).stripTrailingZeros();
                        maxQty = new BigDecimal(filter.getMaxQty()).stripTrailingZeros();
                        stepSize = new BigDecimal(filter.getStepSize()).stripTrailingZeros();
                        continue;
                    }
                    if (!filter.getFilterType().equals("MIN_NOTIONAL")) continue;
                    counterMinQty = new BigDecimal(filter.getMinNotional()).stripTrailingZeros();
                }
                boolean marketOrderAllowed = Arrays.asList(symbol.getOrderTypes()).contains("MARKET");
                currencyPairs.put(currentCurrencyPair, new CurrencyPairMetaData(new BigDecimal("0.1"), minQty, maxQty, counterMinQty, counterMaxQty, Integer.valueOf(amountPrecision), Integer.valueOf(pairPrecision), null, stepSize, null, marketOrderAllowed));
                Currency baseCurrency = currentCurrencyPair.base;
                CurrencyMetaData baseCurrencyMetaData = BinanceAdapters.adaptCurrencyMetaData(currencies, baseCurrency, assetDetailMap, basePrecision);
                currencies.put(baseCurrency, baseCurrencyMetaData);
                Currency counterCurrency = currentCurrencyPair.counter;
                CurrencyMetaData counterCurrencyMetaData = BinanceAdapters.adaptCurrencyMetaData(currencies, counterCurrency, assetDetailMap, counterPrecision);
                currencies.put(counterCurrency, counterCurrencyMetaData);
            }
        }
        catch (Exception e) {
            throw new ExchangeException("Failed to initialize: " + e.getMessage(), (Throwable)e);
        }
    }

    private int numberOfDecimals(String value) {
        return new BigDecimal(value).stripTrailingZeros().scale();
    }

    public void clearDeltaServerTime() {
        this.deltaServerTime = null;
    }

    public long deltaServerTime() throws IOException {
        if (this.deltaServerTime == null || this.deltaServerTimeExpire <= System.currentTimeMillis()) {
            Binance binance = (Binance)RestProxyFactory.createProxy(Binance.class, (String)this.getExchangeSpecification().getSslUri());
            Date serverTime = new Date(binance.time().getServerTime().getTime());
            Date systemTime = new Date(System.currentTimeMillis());
            this.deltaServerTimeExpire = systemTime.getTime() + TimeUnit.MINUTES.toMillis(10L);
            this.deltaServerTime = serverTime.getTime() - systemTime.getTime();
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS");
            LOG.trace("deltaServerTime: {} - {} => {}", new Object[]{df.format(serverTime), df.format(systemTime), this.deltaServerTime});
        }
        return this.deltaServerTime;
    }
}

