/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.utils;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.meta.CurrencyPairMetaData;
import org.knowm.xchange.utils.BigDecimalUtils;

public class OrderValuesHelper {
    private final CurrencyPairMetaData metaData;

    public OrderValuesHelper(CurrencyPairMetaData metaData) {
        this.metaData = metaData;
    }

    public boolean amountUnderMinimum(BigDecimal amount) {
        BigDecimal minimalAmount = this.metaData.getMinimumAmount();
        if (minimalAmount == null) {
            return false;
        }
        return amount.compareTo(minimalAmount) < 0;
    }

    public BigDecimal adjustAmount(BigDecimal amount) {
        Integer baseScale;
        BigDecimal maximumAmount = this.metaData.getMaximumAmount();
        if (maximumAmount != null && amount.compareTo(maximumAmount) > 0) {
            return maximumAmount;
        }
        BigDecimal result = amount;
        BigDecimal stepSize = this.metaData.getAmountStepSize();
        if (stepSize != null && stepSize.compareTo(BigDecimal.ZERO) != 0) {
            result = BigDecimalUtils.roundToStepSize(result, stepSize, RoundingMode.FLOOR);
        }
        if ((baseScale = this.metaData.getBaseScale()) != null) {
            result = result.setScale((int)baseScale, RoundingMode.FLOOR);
        }
        return result;
    }

    public BigDecimal adjustPrice(BigDecimal price, Order.OrderType orderType) {
        return this.adjustPrice(price, orderType == Order.OrderType.ASK || orderType == Order.OrderType.EXIT_ASK ? RoundingMode.CEILING : RoundingMode.FLOOR);
    }

    public BigDecimal adjustPrice(BigDecimal price, RoundingMode roundingMode) {
        BigDecimal result = price;
        Integer scale = this.metaData.getPriceScale();
        if (scale != null) {
            result = result.setScale((int)scale, roundingMode);
        }
        return result;
    }
}

