/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.service;

import java.math.BigDecimal;
import org.knowm.xchange.Exchange;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.meta.CurrencyPairMetaData;
import org.knowm.xchange.dto.meta.ExchangeMetaData;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;

public abstract class BaseExchangeService<E extends Exchange> {
    protected final E exchange;

    protected BaseExchangeService(E exchange) {
        this.exchange = exchange;
    }

    public void verifyOrder(LimitOrder limitOrder) {
        ExchangeMetaData exchangeMetaData = this.exchange.getExchangeMetaData();
        this.verifyOrder(limitOrder, exchangeMetaData);
        BigDecimal price = limitOrder.getLimitPrice().stripTrailingZeros();
        if (price.scale() > exchangeMetaData.getCurrencyPairs().get(limitOrder.getCurrencyPair()).getPriceScale()) {
            throw new IllegalArgumentException("Unsupported price scale " + price.scale());
        }
    }

    public void verifyOrder(MarketOrder marketOrder) {
        this.verifyOrder(marketOrder, this.exchange.getExchangeMetaData());
    }

    protected final void verifyOrder(Order order, ExchangeMetaData exchangeMetaData) {
        CurrencyPairMetaData metaData = exchangeMetaData.getCurrencyPairs().get(order.getCurrencyPair());
        if (metaData == null) {
            throw new IllegalArgumentException("Invalid CurrencyPair");
        }
        BigDecimal originalAmount = order.getOriginalAmount();
        if (originalAmount == null) {
            throw new IllegalArgumentException("Missing originalAmount");
        }
        BigDecimal amount = originalAmount.stripTrailingZeros();
        BigDecimal minimumAmount = metaData.getMinimumAmount();
        if (minimumAmount != null) {
            if (amount.scale() > minimumAmount.scale()) {
                throw new IllegalArgumentException("Unsupported amount scale " + amount.scale());
            }
            if (amount.compareTo(minimumAmount) < 0) {
                throw new IllegalArgumentException("Order amount less than minimum");
            }
        }
    }
}

