/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.dto.account;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.knowm.xchange.dto.account.OpenPosition;
import org.knowm.xchange.dto.account.Wallet;

public final class AccountInfo
implements Serializable {
    private static final long serialVersionUID = -3572240060624800060L;
    private final String username;
    private final BigDecimal tradingFee;
    private final Map<String, Wallet> wallets;
    private final Collection<OpenPosition> openPositions;
    @Nullable
    private final Date timestamp;

    public AccountInfo(Wallet ... wallets) {
        this((String)null, (BigDecimal)null, wallets);
    }

    public AccountInfo(Date timestamp, Wallet ... wallets) {
        this(null, null, Arrays.asList(wallets), timestamp);
    }

    public AccountInfo(Collection<Wallet> wallets) {
        this(null, null, wallets);
    }

    public AccountInfo(String username, Wallet ... wallets) {
        this(username, (BigDecimal)null, wallets);
    }

    public AccountInfo(String username, Collection<Wallet> wallets) {
        this(username, null, wallets);
    }

    public AccountInfo(String username, BigDecimal tradingFee, Collection<Wallet> wallets) {
        this(username, tradingFee, wallets, null);
    }

    public AccountInfo(String username, BigDecimal tradingFee, Collection<Wallet> wallets, Date timestamp) {
        this(username, tradingFee, wallets, Collections.emptySet(), timestamp);
    }

    public AccountInfo(String username, BigDecimal tradingFee, Collection<Wallet> wallets, Collection<OpenPosition> openPositions, Date timestamp) {
        this.username = username;
        this.tradingFee = tradingFee;
        this.timestamp = timestamp;
        this.openPositions = openPositions;
        if (wallets.size() == 0) {
            this.wallets = Collections.emptyMap();
        } else if (wallets.size() == 1) {
            Wallet wallet = wallets.iterator().next();
            this.wallets = Collections.singletonMap(wallet.getId(), wallet);
        } else {
            this.wallets = new HashMap<String, Wallet>();
            for (Wallet wallet : wallets) {
                if (this.wallets.containsKey(wallet.getId())) {
                    throw new IllegalArgumentException("duplicate wallets passed to AccountInfo");
                }
                this.wallets.put(wallet.getId(), wallet);
            }
        }
    }

    public AccountInfo(String username, BigDecimal tradingFee, Wallet ... wallets) {
        this(username, tradingFee, Arrays.asList(wallets));
    }

    public Map<String, Wallet> getWallets() {
        return Collections.unmodifiableMap(this.wallets);
    }

    public Wallet getWallet() {
        if (this.wallets.size() != 1) {
            throw new UnsupportedOperationException(this.wallets.size() + " wallets in account");
        }
        return this.getWallet(this.wallets.keySet().iterator().next());
    }

    public Wallet getWallet(String id) {
        return this.wallets.get(id);
    }

    public Wallet getWallet(Wallet.WalletFeature feature) {
        ArrayList walletWithFeatures = new ArrayList();
        this.wallets.forEach((s, wallet) -> {
            if (wallet.getFeatures() != null && wallet.getFeatures().contains((Object)feature)) {
                walletWithFeatures.add(wallet);
            }
        });
        if (walletWithFeatures.size() > 1) {
            throw new UnsupportedOperationException("More than one wallet offer this feature.");
        }
        if (walletWithFeatures.size() == 0) {
            return null;
        }
        return (Wallet)walletWithFeatures.get(0);
    }

    public String getUsername() {
        return this.username;
    }

    public BigDecimal getTradingFee() {
        return this.tradingFee;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return "AccountInfo [username=" + this.username + ", tradingFee=" + this.tradingFee + ", wallets=" + this.wallets + "]";
    }
}

