/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.client;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.knowm.xchange.ExchangeSpecification;
import org.knowm.xchange.client.ClientConfigCustomizer;
import org.knowm.xchange.client.ResilienceRegistries;
import org.knowm.xchange.interceptor.InterceptorProvider;
import si.mazi.rescu.ClientConfig;
import si.mazi.rescu.IRestProxyFactory;
import si.mazi.rescu.Interceptor;
import si.mazi.rescu.RestProxyFactoryImpl;

public final class ExchangeRestProxyBuilder<T> {
    private final Class<T> restInterface;
    private final ExchangeSpecification exchangeSpecification;
    private final List<Interceptor> customInterceptors = new ArrayList<Interceptor>();
    private final List<ClientConfigCustomizer> clientConfigCustomizers = new ArrayList<ClientConfigCustomizer>();
    private ClientConfig clientConfig;
    private ResilienceRegistries resilienceRegistries;
    private String baseUrl;
    private IRestProxyFactory restProxyFactory = new RestProxyFactoryImpl();

    private ExchangeRestProxyBuilder(Class<T> restInterface, ExchangeSpecification exchangeSpecification) {
        this.restInterface = restInterface;
        this.exchangeSpecification = exchangeSpecification;
        this.baseUrl = Optional.ofNullable(exchangeSpecification.getSslUri()).orElseGet(exchangeSpecification::getPlainTextUri);
    }

    public static <T> ExchangeRestProxyBuilder<T> forInterface(Class<T> restInterface, ExchangeSpecification exchangeSpecification) {
        return new ExchangeRestProxyBuilder<T>(restInterface, exchangeSpecification).customInterceptors(InterceptorProvider.provide());
    }

    public ExchangeRestProxyBuilder<T> clientConfig(ClientConfig value) {
        this.clientConfig = value;
        return this;
    }

    public ExchangeRestProxyBuilder<T> clientConfigCustomizer(ClientConfigCustomizer clientConfigCustomizer) {
        this.clientConfigCustomizers.add(clientConfigCustomizer);
        return this;
    }

    public ExchangeRestProxyBuilder<T> baseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
        return this;
    }

    public ExchangeRestProxyBuilder<T> customInterceptor(Interceptor value) {
        this.customInterceptors.add(value);
        return this;
    }

    public ExchangeRestProxyBuilder<T> customInterceptors(Collection<Interceptor> interceptors) {
        this.customInterceptors.addAll(interceptors);
        return this;
    }

    public ExchangeRestProxyBuilder<T> restProxyFactory(IRestProxyFactory restProxyFactory) {
        this.restProxyFactory = restProxyFactory;
        return this;
    }

    public T build() {
        if (this.clientConfig == null) {
            this.clientConfig = ExchangeRestProxyBuilder.createClientConfig(this.exchangeSpecification);
        }
        if (this.resilienceRegistries == null) {
            this.resilienceRegistries = new ResilienceRegistries();
        }
        this.clientConfigCustomizers.forEach(clientConfigCustomizer -> clientConfigCustomizer.customize(this.clientConfig));
        return (T)this.restProxyFactory.createProxy(this.restInterface, this.baseUrl, this.clientConfig, this.customInterceptors.toArray(new Interceptor[0]));
    }

    public static ClientConfig createClientConfig(ExchangeSpecification exchangeSpecification) {
        int customHttpReadTimeout;
        ClientConfig rescuConfig = new ClientConfig();
        int customHttpConnTimeout = exchangeSpecification.getHttpConnTimeout();
        if (customHttpConnTimeout > 0) {
            rescuConfig.setHttpConnTimeout(customHttpConnTimeout);
        }
        if ((customHttpReadTimeout = exchangeSpecification.getHttpReadTimeout()) > 0) {
            rescuConfig.setHttpReadTimeout(customHttpReadTimeout);
        }
        if (exchangeSpecification.getProxyHost() != null) {
            rescuConfig.setProxyHost(exchangeSpecification.getProxyHost());
        }
        if (exchangeSpecification.getProxyPort() != null) {
            rescuConfig.setProxyPort(exchangeSpecification.getProxyPort());
        }
        return rescuConfig;
    }
}

