/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.utils.nonce;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import si.mazi.rescu.SynchronizedValueFactory;

public class CurrentTimeIncrementalNonceFactory
implements SynchronizedValueFactory<Long> {
    private final AtomicLong nonce = new AtomicLong(0L);
    private final Supplier<Long> timeFn;

    public CurrentTimeIncrementalNonceFactory(TimeUnit timeUnit) {
        switch (timeUnit) {
            case SECONDS: {
                this.timeFn = () -> System.currentTimeMillis() / 1000L;
                break;
            }
            case MILLISECONDS: {
                this.timeFn = System::currentTimeMillis;
                break;
            }
            case MICROSECONDS: {
                this.timeFn = () -> System.nanoTime() / 1000L;
                break;
            }
            case NANOSECONDS: {
                this.timeFn = System::nanoTime;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("TimeUnit %s not supported", new Object[]{timeUnit}));
            }
        }
    }

    public Long createValue() {
        return this.nonce.updateAndGet(prevNonce -> {
            long newNonce = this.timeFn.get();
            if (newNonce <= prevNonce) {
                newNonce = prevNonce + 1L;
            }
            return newNonce;
        });
    }
}

