/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.service.trade;

import java.io.IOException;
import java.util.Collection;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.dto.account.OpenPositions;
import org.knowm.xchange.dto.trade.LimitOrder;
import org.knowm.xchange.dto.trade.MarketOrder;
import org.knowm.xchange.dto.trade.OpenOrders;
import org.knowm.xchange.dto.trade.StopOrder;
import org.knowm.xchange.dto.trade.UserTrades;
import org.knowm.xchange.exceptions.NotAvailableFromExchangeException;
import org.knowm.xchange.exceptions.NotYetImplementedForExchangeException;
import org.knowm.xchange.service.BaseService;
import org.knowm.xchange.service.trade.params.CancelOrderParams;
import org.knowm.xchange.service.trade.params.DefaultCancelOrderParamId;
import org.knowm.xchange.service.trade.params.TradeHistoryParams;
import org.knowm.xchange.service.trade.params.orders.DefaultQueryOrderParam;
import org.knowm.xchange.service.trade.params.orders.OpenOrdersParams;
import org.knowm.xchange.service.trade.params.orders.OrderQueryParams;

public interface TradeService
extends BaseService {
    default public OpenOrders getOpenOrders() throws IOException {
        throw new NotYetImplementedForExchangeException("getOpenOrders");
    }

    default public OpenOrders getOpenOrders(OpenOrdersParams params) throws IOException {
        throw new NotYetImplementedForExchangeException("getOpenOrders");
    }

    default public OpenPositions getOpenPositions() throws IOException {
        throw new NotYetImplementedForExchangeException();
    }

    default public String placeMarketOrder(MarketOrder marketOrder) throws IOException {
        throw new NotYetImplementedForExchangeException("placeMarketOrder");
    }

    default public String placeLimitOrder(LimitOrder limitOrder) throws IOException {
        throw new NotYetImplementedForExchangeException("placeLimitOrder");
    }

    default public String placeStopOrder(StopOrder stopOrder) throws IOException {
        throw new NotYetImplementedForExchangeException("placeStopOrder");
    }

    default public String changeOrder(LimitOrder limitOrder) throws IOException {
        this.cancelOrder(limitOrder.getId());
        return this.placeLimitOrder(limitOrder);
    }

    default public boolean cancelOrder(String orderId) throws IOException {
        return this.cancelOrder(new DefaultCancelOrderParamId(orderId));
    }

    default public boolean cancelOrder(CancelOrderParams orderParams) throws IOException {
        throw new NotYetImplementedForExchangeException("cancelOrder");
    }

    default public UserTrades getTradeHistory(TradeHistoryParams params) throws IOException {
        throw new NotYetImplementedForExchangeException("getTradeHistory");
    }

    default public TradeHistoryParams createTradeHistoryParams() {
        throw new NotYetImplementedForExchangeException("createTradeHistoryParams");
    }

    default public OpenOrdersParams createOpenOrdersParams() {
        throw new NotYetImplementedForExchangeException("createOpenOrdersParams");
    }

    default public void verifyOrder(LimitOrder limitOrder) {
        throw new NotYetImplementedForExchangeException("verifyOrder");
    }

    default public void verifyOrder(MarketOrder marketOrder) {
        throw new NotYetImplementedForExchangeException("verifyOrder");
    }

    default public Collection<Order> getOrder(String ... orderIds) throws IOException {
        return this.getOrder(TradeService.toOrderQueryParams(orderIds));
    }

    public static OrderQueryParams[] toOrderQueryParams(String ... orderIds) {
        OrderQueryParams[] res = new OrderQueryParams[orderIds.length];
        for (int i = 0; i < orderIds.length; ++i) {
            String orderId = orderIds[i];
            res[i] = new DefaultQueryOrderParam(orderId);
        }
        return res;
    }

    default public Collection<Order> getOrder(OrderQueryParams ... orderQueryParams) throws IOException {
        throw new NotAvailableFromExchangeException("getOrder");
    }
}

