/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.dto.trade;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Set;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.dto.Order;
import org.knowm.xchange.instrument.Instrument;

@JsonDeserialize(builder=Builder.class)
public class LimitOrder
extends Order
implements Comparable<LimitOrder> {
    private static final long serialVersionUID = -5166848178471347540L;
    protected final BigDecimal limitPrice;

    public LimitOrder(Order.OrderType type, BigDecimal originalAmount, Instrument instrument, String id, Date timestamp, BigDecimal limitPrice) {
        super(type, originalAmount, instrument, id, timestamp);
        this.limitPrice = limitPrice;
    }

    public LimitOrder(Order.OrderType type, BigDecimal originalAmount, BigDecimal cumulativeAmount, Instrument instrument, String id, Date timestamp, BigDecimal limitPrice) {
        super(type, originalAmount, instrument, id, timestamp, BigDecimal.ZERO, cumulativeAmount, BigDecimal.ZERO, Order.OrderStatus.PENDING_NEW);
        this.limitPrice = limitPrice;
    }

    public LimitOrder(Order.OrderType type, BigDecimal originalAmount, Instrument instrument, String id, Date timestamp, BigDecimal limitPrice, BigDecimal averagePrice, BigDecimal cumulativeAmount, BigDecimal fee, Order.OrderStatus status) {
        super(type, originalAmount, instrument, id, timestamp, averagePrice, cumulativeAmount, fee, status);
        this.limitPrice = limitPrice;
    }

    public LimitOrder(Order.OrderType type, BigDecimal originalAmount, Instrument instrument, String id, Date timestamp, BigDecimal limitPrice, BigDecimal averagePrice, BigDecimal cumulativeAmount, BigDecimal fee, Order.OrderStatus status, String userReference) {
        super(type, originalAmount, instrument, id, timestamp, averagePrice, cumulativeAmount, fee, status, userReference);
        this.limitPrice = limitPrice;
    }

    public BigDecimal getLimitPrice() {
        return this.limitPrice;
    }

    @Override
    public String toString() {
        return "LimitOrder [limitPrice=" + this.printLimitPrice() + ", " + super.toString() + "]";
    }

    private String printLimitPrice() {
        return this.limitPrice == null ? null : this.limitPrice.toPlainString();
    }

    @Override
    public int compareTo(LimitOrder limitOrder) {
        int ret = this.getType() == limitOrder.getType() ? this.getLimitPrice().compareTo(limitOrder.getLimitPrice()) * (this.getType() == Order.OrderType.BID ? -1 : 1) : (this.getType() == Order.OrderType.BID ? -1 : 1);
        return ret;
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 59 * hash + (this.limitPrice != null ? this.limitPrice.hashCode() : 0);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LimitOrder other = (LimitOrder)obj;
        if (this.limitPrice == null ? other.limitPrice != null : this.limitPrice.compareTo(other.limitPrice) != 0) {
            return false;
        }
        return super.equals(obj);
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder
    extends Order.Builder {
        protected BigDecimal limitPrice;

        @JsonCreator
        public Builder(@JsonProperty(value="orderType") Order.OrderType orderType, @JsonProperty(value="instrument") Instrument instrument) {
            super(orderType, instrument);
        }

        public static Builder from(Order order) {
            Builder builder = ((Builder)new Builder(order.getType(), order.getCurrencyPair()).originalAmount(order.getOriginalAmount()).cumulativeAmount(order.getCumulativeAmount()).timestamp(order.getTimestamp()).id(order.getId()).flags((Set)order.getOrderFlags())).orderStatus(order.getStatus()).fee(order.getFee()).averagePrice(order.getAveragePrice()).userReference(order.getUserReference());
            if (order instanceof LimitOrder) {
                LimitOrder limitOrder = (LimitOrder)order;
                builder.limitPrice(limitOrder.getLimitPrice());
            }
            return builder;
        }

        @Override
        public Builder orderType(Order.OrderType orderType) {
            return (Builder)super.orderType(orderType);
        }

        @Override
        public Builder originalAmount(BigDecimal originalAmount) {
            return (Builder)super.originalAmount(originalAmount);
        }

        @Override
        public Builder cumulativeAmount(BigDecimal originalAmount) {
            return (Builder)super.cumulativeAmount(originalAmount);
        }

        @Override
        public Builder remainingAmount(BigDecimal remainingAmount) {
            return (Builder)super.remainingAmount(remainingAmount);
        }

        @Override
        @Deprecated
        public Builder currencyPair(CurrencyPair currencyPair) {
            return (Builder)super.currencyPair(currencyPair);
        }

        @Override
        public Builder instrument(Instrument instrument) {
            return (Builder)super.instrument(instrument);
        }

        @Override
        public Builder id(String id) {
            return (Builder)super.id(id);
        }

        @Override
        public Builder userReference(String userReference) {
            return (Builder)super.userReference(userReference);
        }

        @Override
        public Builder timestamp(Date timestamp) {
            return (Builder)super.timestamp(timestamp);
        }

        @Override
        public Builder orderStatus(Order.OrderStatus status) {
            return (Builder)super.orderStatus(status);
        }

        @Override
        public Builder averagePrice(BigDecimal averagePrice) {
            return (Builder)super.averagePrice(averagePrice);
        }

        @Override
        public Builder flag(Order.IOrderFlags flag) {
            return (Builder)super.flag(flag);
        }

        @Override
        public Builder flags(Set<Order.IOrderFlags> flags) {
            return (Builder)super.flags(flags);
        }

        @Override
        public Builder fee(BigDecimal fee) {
            return (Builder)super.fee(fee);
        }

        public Builder limitPrice(BigDecimal limitPrice) {
            this.limitPrice = limitPrice;
            return this;
        }

        @Override
        public LimitOrder build() {
            LimitOrder order = new LimitOrder(this.orderType, this.originalAmount, this.instrument, this.id, this.timestamp, this.limitPrice, this.averagePrice, this.originalAmount == null || this.remainingAmount == null ? this.cumulativeAmount : this.originalAmount.subtract(this.remainingAmount), this.fee, this.status, this.userReference);
            order.setOrderFlags(this.flags);
            order.setLeverage(this.leverage);
            return order;
        }
    }
}

