/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.dto.meta;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import org.knowm.xchange.currency.Currency;
import org.knowm.xchange.dto.meta.FeeTier;

public class CurrencyPairMetaData
implements Serializable {
    private static final long serialVersionUID = 4749144540694704221L;
    @JsonProperty(value="trading_fee")
    private final BigDecimal tradingFee;
    @JsonProperty(value="fee_tiers")
    private final FeeTier[] feeTiers;
    @JsonProperty(value="min_amount")
    private final BigDecimal minimumAmount;
    @JsonProperty(value="max_amount")
    private final BigDecimal maximumAmount;
    @JsonProperty(value="counter_min_amount")
    private final BigDecimal counterMinimumAmount;
    @JsonProperty(value="counter_max_amount")
    private final BigDecimal counterMaximumAmount;
    @JsonProperty(value="base_scale")
    private final Integer baseScale;
    @JsonProperty(value="price_scale")
    private final Integer priceScale;
    @JsonProperty(value="volume_scale")
    private final Integer volumeScale;
    @JsonProperty(value="amount_step_size")
    private final BigDecimal amountStepSize;
    private final Currency tradingFeeCurrency;
    private final boolean marketOrderEnabled;

    public CurrencyPairMetaData(BigDecimal tradingFee, BigDecimal minimumAmount, BigDecimal maximumAmount, Integer priceScale, FeeTier[] feeTiers) {
        this(tradingFee, minimumAmount, maximumAmount, null, null, null, priceScale, null, feeTiers, null, null, true);
    }

    public CurrencyPairMetaData(BigDecimal tradingFee, BigDecimal minimumAmount, BigDecimal maximumAmount, Integer priceScale, FeeTier[] feeTiers, BigDecimal amountStepSize) {
        this(tradingFee, minimumAmount, maximumAmount, null, null, null, priceScale, null, feeTiers, amountStepSize, null, true);
    }

    public CurrencyPairMetaData(BigDecimal tradingFee, BigDecimal minimumAmount, BigDecimal maximumAmount, Integer priceScale, Integer volumeScale, FeeTier[] feeTiers, Currency tradingFeeCurrency) {
        this(tradingFee, minimumAmount, maximumAmount, null, null, null, priceScale, volumeScale, feeTiers, null, tradingFeeCurrency, true);
    }

    public CurrencyPairMetaData(@JsonProperty(value="trading_fee") BigDecimal tradingFee, @JsonProperty(value="min_amount") BigDecimal minimumAmount, @JsonProperty(value="max_amount") BigDecimal maximumAmount, @JsonProperty(value="counter_min_amount") BigDecimal counterMinimumAmount, @JsonProperty(value="counter_max_amount") BigDecimal counterMaximumAmount, @JsonProperty(value="base_scale") Integer baseScale, @JsonProperty(value="price_scale") Integer priceScale, @JsonProperty(value="volume_scale") Integer volumeScale, @JsonProperty(value="fee_tiers") FeeTier[] feeTiers, @JsonProperty(value="amount_step_size") BigDecimal amountStepSize, @JsonProperty(value="trading_fee_currency") Currency tradingFeeCurrency, @JsonProperty(value="market_order_enabled") boolean marketOrderEnabled) {
        this.tradingFee = tradingFee;
        this.minimumAmount = minimumAmount;
        this.maximumAmount = maximumAmount;
        this.counterMinimumAmount = counterMinimumAmount;
        this.counterMaximumAmount = counterMaximumAmount;
        this.baseScale = baseScale;
        this.priceScale = priceScale;
        this.volumeScale = volumeScale;
        if (feeTiers != null) {
            Arrays.sort(feeTiers);
        }
        this.feeTiers = feeTiers;
        this.amountStepSize = amountStepSize;
        this.tradingFeeCurrency = tradingFeeCurrency;
        this.marketOrderEnabled = marketOrderEnabled;
    }

    public BigDecimal getTradingFee() {
        return this.tradingFee;
    }

    public BigDecimal getMinimumAmount() {
        return this.minimumAmount;
    }

    public BigDecimal getMaximumAmount() {
        return this.maximumAmount;
    }

    public Integer getBaseScale() {
        return this.baseScale;
    }

    public Integer getPriceScale() {
        return this.priceScale;
    }

    public Integer getVolumeScale() {
        return this.volumeScale;
    }

    public FeeTier[] getFeeTiers() {
        return this.feeTiers;
    }

    public BigDecimal getAmountStepSize() {
        return this.amountStepSize;
    }

    public Currency getTradingFeeCurrency() {
        return this.tradingFeeCurrency;
    }

    public BigDecimal getCounterMinimumAmount() {
        return this.counterMinimumAmount;
    }

    public BigDecimal getCounterMaximumAmount() {
        return this.counterMaximumAmount;
    }

    public boolean isMarketOrderEnabled() {
        return this.marketOrderEnabled;
    }

    public String toString() {
        return "CurrencyPairMetaData [tradingFee=" + this.tradingFee + ", minimumAmount=" + this.minimumAmount + ", maximumAmount=" + this.maximumAmount + ", baseScale=" + this.baseScale + ", priceScale=" + this.priceScale + ", volumeScale=" + this.volumeScale + ", amountStepSize=" + this.amountStepSize + ", tradingFeeCurrency=" + this.tradingFeeCurrency + "]";
    }

    public static class Builder {
        private BigDecimal tradingFee;
        private FeeTier[] feeTiers;
        private BigDecimal minimumAmount;
        private BigDecimal maximumAmount;
        private BigDecimal counterMinimumAmount;
        private BigDecimal counterMaximumAmount;
        private Integer baseScale;
        private Integer priceScale;
        private Integer volumeScale;
        private BigDecimal amountStepSize;
        private Currency tradingFeeCurrency;
        private boolean marketOrderEnabled;

        public static Builder from(CurrencyPairMetaData metaData) {
            return new Builder().tradingFee(metaData.getTradingFee()).feeTiers(metaData.getFeeTiers()).minimumAmount(metaData.getMinimumAmount()).maximumAmount(metaData.getMaximumAmount()).counterMinimumAmount(metaData.getCounterMinimumAmount()).counterMaximumAmount(metaData.getCounterMaximumAmount()).baseScale(metaData.getBaseScale()).priceScale(metaData.getPriceScale()).volumeScale(metaData.getVolumeScale()).amountStepSize(metaData.getAmountStepSize()).tradingFee(metaData.getTradingFee()).tradingFeeCurrency(metaData.getTradingFeeCurrency());
        }

        public Builder tradingFee(BigDecimal tradingFee) {
            this.tradingFee = tradingFee;
            return this;
        }

        public Builder feeTiers(FeeTier[] feeTiers) {
            this.feeTiers = feeTiers;
            return this;
        }

        public Builder minimumAmount(BigDecimal minimumAmount) {
            this.minimumAmount = minimumAmount;
            return this;
        }

        public Builder maximumAmount(BigDecimal maximumAmount) {
            this.maximumAmount = maximumAmount;
            return this;
        }

        public Builder counterMinimumAmount(BigDecimal counterMinimumAmount) {
            this.counterMinimumAmount = counterMinimumAmount;
            return this;
        }

        public Builder counterMaximumAmount(BigDecimal counterMaximumAmount) {
            this.counterMaximumAmount = counterMaximumAmount;
            return this;
        }

        public Builder baseScale(Integer baseScale) {
            this.baseScale = baseScale;
            return this;
        }

        public Builder priceScale(Integer priceScale) {
            this.priceScale = priceScale;
            return this;
        }

        public Builder volumeScale(Integer volumeScale) {
            this.volumeScale = volumeScale;
            return this;
        }

        public Builder amountStepSize(BigDecimal amountStepSize) {
            this.amountStepSize = amountStepSize;
            return this;
        }

        public Builder tradingFeeCurrency(Currency tradingFeeCurrency) {
            this.tradingFeeCurrency = tradingFeeCurrency;
            return this;
        }

        public Builder marketOrderEnabled(boolean marketOrderEnabled) {
            this.marketOrderEnabled = marketOrderEnabled;
            return this;
        }

        public CurrencyPairMetaData build() {
            return new CurrencyPairMetaData(this.tradingFee, this.minimumAmount, this.maximumAmount, this.counterMinimumAmount, this.counterMaximumAmount, this.baseScale, this.priceScale, this.volumeScale, this.feeTiers, this.amountStepSize, this.tradingFeeCurrency, this.marketOrderEnabled);
        }
    }
}

