/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.dto.marketdata;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.knowm.xchange.dto.marketdata.Trade;

public class Trades
implements Serializable {
    private static final long serialVersionUID = 5790082783307641329L;
    private static final TradeIDComparator TRADE_ID_COMPARATOR = new TradeIDComparator();
    private static final TradeTimestampComparator TRADE_TIMESTAMP_COMPARATOR = new TradeTimestampComparator();
    private final List<Trade> trades;
    private final long lastID;
    private final String nextPageCursor;
    private final TradeSortType tradeSortType;

    public Trades(List<Trade> trades) {
        this(trades, 0L, TradeSortType.SortByID);
    }

    public Trades(List<Trade> trades, TradeSortType tradeSortType) {
        this(trades, 0L, tradeSortType);
    }

    public Trades(List<Trade> trades, long lastID, TradeSortType tradeSortType) {
        this(trades, lastID, tradeSortType, null);
    }

    public Trades(List<Trade> trades, long lastID, TradeSortType tradeSortType, String nextPageCursor) {
        this.trades = new ArrayList<Trade>(trades);
        this.lastID = lastID;
        this.tradeSortType = tradeSortType;
        this.nextPageCursor = nextPageCursor;
        switch (tradeSortType) {
            case SortByTimestamp: {
                Collections.sort(this.trades, TRADE_TIMESTAMP_COMPARATOR);
                break;
            }
            case SortByID: {
                Collections.sort(this.trades, TRADE_ID_COMPARATOR);
                break;
            }
        }
    }

    public List<Trade> getTrades() {
        return this.trades;
    }

    public long getlastID() {
        return this.lastID;
    }

    public TradeSortType getTradeSortType() {
        return this.tradeSortType;
    }

    public String getNextPageCursor() {
        return this.nextPageCursor;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Trades\n");
        sb.append("lastID= ").append(this.lastID).append("\n");
        for (Trade trade : this.getTrades()) {
            sb.append("[trade=").append(trade.toString()).append("]\n");
        }
        sb.append("nextPageCursor= ").append(this.nextPageCursor).append("\n");
        return sb.toString();
    }

    public static enum TradeSortType {
        SortByTimestamp,
        SortByID;

    }

    public static class TradeTimestampComparator
    implements Comparator<Trade> {
        @Override
        public int compare(Trade trade1, Trade trade2) {
            return trade1.getTimestamp().compareTo(trade2.getTimestamp());
        }
    }

    public static class TradeIDComparator
    implements Comparator<Trade> {
        private static final int[] ALLOWED_RADIXES = new int[]{10, 16};

        @Override
        public int compare(Trade trade1, Trade trade2) {
            for (int radix : ALLOWED_RADIXES) {
                try {
                    BigInteger id1 = new BigInteger(trade1.getId(), radix);
                    BigInteger id2 = new BigInteger(trade2.getId(), radix);
                    return id1.compareTo(id2);
                }
                catch (NumberFormatException numberFormatException) {
                }
            }
            return trade1.getId().compareTo(trade2.getId());
        }
    }
}

