/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.dto.marketdata;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Objects;
import org.knowm.xchange.currency.CurrencyPair;
import org.knowm.xchange.instrument.Instrument;
import org.knowm.xchange.utils.Assert;
import org.knowm.xchange.utils.DateUtils;

@JsonDeserialize(builder=Builder.class)
public final class Ticker
implements Serializable {
    private static final long serialVersionUID = -3247730106987193154L;
    private final Instrument instrument;
    private final BigDecimal open;
    private final BigDecimal last;
    private final BigDecimal bid;
    private final BigDecimal ask;
    private final BigDecimal high;
    private final BigDecimal low;
    private final BigDecimal vwap;
    private final BigDecimal volume;
    private final BigDecimal quoteVolume;
    private final Date timestamp;
    private final BigDecimal bidSize;
    private final BigDecimal askSize;
    private final BigDecimal percentageChange;

    private Ticker(Instrument instrument, BigDecimal open, BigDecimal last, BigDecimal bid, BigDecimal ask, BigDecimal high, BigDecimal low, BigDecimal vwap, BigDecimal volume, BigDecimal quoteVolume, Date timestamp, BigDecimal bidSize, BigDecimal askSize, BigDecimal percentageChange) {
        this.open = open;
        this.instrument = instrument;
        this.last = last;
        this.bid = bid;
        this.ask = ask;
        this.high = high;
        this.low = low;
        this.vwap = vwap;
        this.volume = volume;
        this.quoteVolume = quoteVolume;
        this.timestamp = timestamp;
        this.bidSize = bidSize;
        this.askSize = askSize;
        this.percentageChange = percentageChange;
    }

    public Instrument getInstrument() {
        return this.instrument;
    }

    @Deprecated
    @JsonIgnore
    public CurrencyPair getCurrencyPair() {
        if (this.instrument == null) {
            return null;
        }
        if (!(this.instrument instanceof CurrencyPair)) {
            throw new IllegalStateException("The instrument of this order is not a currency pair: " + this.instrument);
        }
        return (CurrencyPair)this.instrument;
    }

    public BigDecimal getOpen() {
        return this.open;
    }

    public BigDecimal getLast() {
        return this.last;
    }

    public BigDecimal getBid() {
        return this.bid;
    }

    public BigDecimal getAsk() {
        return this.ask;
    }

    public BigDecimal getHigh() {
        return this.high;
    }

    public BigDecimal getLow() {
        return this.low;
    }

    public BigDecimal getVwap() {
        return this.vwap;
    }

    public BigDecimal getVolume() {
        return this.volume;
    }

    public BigDecimal getQuoteVolume() {
        if (this.quoteVolume == null && this.volume != null && this.last != null) {
            return this.volume.multiply(this.last);
        }
        return this.quoteVolume;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public BigDecimal getBidSize() {
        return this.bidSize;
    }

    public BigDecimal getAskSize() {
        return this.askSize;
    }

    public BigDecimal getPercentageChange() {
        return this.percentageChange;
    }

    public String toString() {
        return "Ticker [instrument=" + this.instrument + ", open=" + this.open + ", last=" + this.last + ", bid=" + this.bid + ", ask=" + this.ask + ", high=" + this.high + ", low=" + this.low + ",avg=" + this.vwap + ", volume=" + this.volume + ", quoteVolume=" + this.quoteVolume + ", timestamp=" + DateUtils.toMillisNullSafe(this.timestamp) + ", bidSize=" + this.bidSize + ", askSize=" + this.askSize + ", percentageChange=" + this.percentageChange + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Ticker ticker = (Ticker)o;
        return Objects.equals(this.getInstrument(), ticker.getInstrument()) && Objects.equals(this.getOpen(), ticker.getOpen()) && Objects.equals(this.getLast(), ticker.getLast()) && Objects.equals(this.getBid(), ticker.getBid()) && Objects.equals(this.getAsk(), ticker.getAsk()) && Objects.equals(this.getHigh(), ticker.getHigh()) && Objects.equals(this.getLow(), ticker.getLow()) && Objects.equals(this.getVwap(), ticker.getVwap()) && Objects.equals(this.getVolume(), ticker.getVolume()) && Objects.equals(this.getQuoteVolume(), ticker.getQuoteVolume()) && Objects.equals(this.getTimestamp(), ticker.getTimestamp()) && Objects.equals(this.getBidSize(), ticker.getBidSize()) && Objects.equals(this.getAskSize(), ticker.getAskSize()) && Objects.equals(this.getPercentageChange(), ticker.getPercentageChange());
    }

    public int hashCode() {
        return Objects.hash(this.getInstrument(), this.getOpen(), this.getLast(), this.getBid(), this.getAsk(), this.getHigh(), this.getLow(), this.getVwap(), this.getVolume(), this.getQuoteVolume(), this.getTimestamp(), this.getBidSize(), this.getAskSize());
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        private Instrument instrument;
        private BigDecimal open;
        private BigDecimal last;
        private BigDecimal bid;
        private BigDecimal ask;
        private BigDecimal high;
        private BigDecimal low;
        private BigDecimal vwap;
        private BigDecimal volume;
        private BigDecimal quoteVolume;
        private Date timestamp;
        private BigDecimal bidSize;
        private BigDecimal askSize;
        private BigDecimal percentageChange;
        private boolean isBuilt = false;

        public Ticker build() {
            this.validateState();
            Ticker ticker = new Ticker(this.instrument, this.open, this.last, this.bid, this.ask, this.high, this.low, this.vwap, this.volume, this.quoteVolume, this.timestamp, this.bidSize, this.askSize, this.percentageChange);
            this.isBuilt = true;
            return ticker;
        }

        private void validateState() {
            if (this.isBuilt) {
                throw new IllegalStateException("The entity has been built");
            }
        }

        public Builder instrument(Instrument instrument) {
            Assert.notNull(instrument, "Null instrument");
            this.instrument = instrument;
            return this;
        }

        @Deprecated
        public Builder currencyPair(CurrencyPair currencyPair) {
            return this.instrument(currencyPair);
        }

        public Builder open(BigDecimal open) {
            this.open = open;
            return this;
        }

        public Builder last(BigDecimal last) {
            this.last = last;
            return this;
        }

        public Builder bid(BigDecimal bid) {
            this.bid = bid;
            return this;
        }

        public Builder ask(BigDecimal ask) {
            this.ask = ask;
            return this;
        }

        public Builder high(BigDecimal high) {
            this.high = high;
            return this;
        }

        public Builder low(BigDecimal low) {
            this.low = low;
            return this;
        }

        public Builder vwap(BigDecimal vwap) {
            this.vwap = vwap;
            return this;
        }

        public Builder volume(BigDecimal volume) {
            this.volume = volume;
            return this;
        }

        public Builder quoteVolume(BigDecimal quoteVolume) {
            this.quoteVolume = quoteVolume;
            return this;
        }

        public Builder timestamp(Date timestamp) {
            this.timestamp = timestamp;
            return this;
        }

        public Builder bidSize(BigDecimal bidSize) {
            this.bidSize = bidSize;
            return this;
        }

        public Builder askSize(BigDecimal askSize) {
            this.askSize = askSize;
            return this;
        }

        public Builder percentageChange(BigDecimal percentageChange) {
            this.percentageChange = percentageChange;
            return this;
        }
    }
}

