/*
 * Decompiled with CFR 0.152.
 */
package org.knowm.xchange.client;

import com.google.common.annotations.Beta;
import io.github.resilience4j.core.IntervalFunction;
import io.github.resilience4j.ratelimiter.RateLimiterConfig;
import io.github.resilience4j.ratelimiter.RateLimiterRegistry;
import io.github.resilience4j.retry.RetryConfig;
import io.github.resilience4j.retry.RetryRegistry;
import java.io.IOException;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.time.Duration;
import org.knowm.xchange.exceptions.ExchangeUnavailableException;
import org.knowm.xchange.exceptions.InternalServerException;
import org.knowm.xchange.exceptions.OperationTimeoutException;

@Beta
public class ResilienceRegistries {
    public static final RetryConfig DEFAULT_RETRY_CONFIG = RetryConfig.custom().maxAttempts(3).intervalFunction(IntervalFunction.ofExponentialBackoff((Duration)Duration.ofMillis(50L), (double)4.0)).retryExceptions(new Class[]{IOException.class, ExchangeUnavailableException.class, InternalServerException.class, OperationTimeoutException.class}).build();
    public static final String NON_IDEMPOTENT_CALLS_RETRY_CONFIG_NAME = "nonIdempotentCallsBase";
    public static final RetryConfig DEFAULT_NON_IDEMPOTENT_CALLS_RETRY_CONFIG = RetryConfig.from((RetryConfig)DEFAULT_RETRY_CONFIG).retryExceptions(new Class[]{UnknownHostException.class, SocketException.class, ExchangeUnavailableException.class}).build();
    public static final RateLimiterConfig DEFAULT_GLOBAL_RATE_LIMITER_CONFIG = RateLimiterConfig.custom().timeoutDuration(Duration.ofSeconds(30L)).limitRefreshPeriod(Duration.ofMinutes(1L)).limitForPeriod(1200).build();
    private final RetryRegistry retryRegistry;
    private final RateLimiterRegistry rateLimiterRegistry;

    public ResilienceRegistries() {
        this(DEFAULT_RETRY_CONFIG, DEFAULT_NON_IDEMPOTENT_CALLS_RETRY_CONFIG);
    }

    public ResilienceRegistries(RetryConfig globalRetryConfig, RetryConfig nonIdempotentCallsRetryConfig) {
        this(globalRetryConfig, nonIdempotentCallsRetryConfig, DEFAULT_GLOBAL_RATE_LIMITER_CONFIG);
    }

    public ResilienceRegistries(RetryConfig globalRetryConfig, RetryConfig nonIdempotentCallsRetryConfig, RateLimiterConfig globalRateLimiterConfig) {
        this(ResilienceRegistries.retryRegistryOf(globalRetryConfig, nonIdempotentCallsRetryConfig), RateLimiterRegistry.of((RateLimiterConfig)globalRateLimiterConfig));
    }

    public ResilienceRegistries(RetryRegistry retryRegistry, RateLimiterRegistry rateLimiterRegistry) {
        this.retryRegistry = retryRegistry;
        this.rateLimiterRegistry = rateLimiterRegistry;
    }

    public RetryRegistry retries() {
        return this.retryRegistry;
    }

    public RateLimiterRegistry rateLimiters() {
        return this.rateLimiterRegistry;
    }

    private static RetryRegistry retryRegistryOf(RetryConfig globalRetryConfig, RetryConfig nonIdempotentCallsRetryConfig) {
        RetryRegistry registry = RetryRegistry.of((RetryConfig)globalRetryConfig);
        registry.addConfiguration(NON_IDEMPOTENT_CALLS_RETRY_CONFIG_NAME, (Object)nonIdempotentCallsRetryConfig);
        return registry;
    }
}

