/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.websocket;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class WebsocketEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":host:port/resourceUri";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "websocket".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties, boolean encode) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "host", "0.0.0.0", false, copy);
        uri = this.buildPathParameter(syntax, uri, "port", "9292", false, copy);
        uri = this.buildPathParameter(syntax, uri, "resourceUri", null, true, copy);
        uri = this.buildQueryParameters(uri, copy, encode);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(21);
        props.add("sendTimeout");
        props.add("minVersion");
        props.add("sendToAll");
        props.add("exchangePattern");
        props.add("sslContextParameters");
        props.add("maxIdleTime");
        props.add("resourceUri");
        props.add("enableJmx");
        props.add("sessionSupport");
        props.add("staticResources");
        props.add("filterPath");
        props.add("lazyStartProducer");
        props.add("bridgeErrorHandler");
        props.add("allowedOrigins");
        props.add("crossOriginFilterOn");
        props.add("port");
        props.add("maxTextMessageSize");
        props.add("host");
        props.add("maxBinaryMessageSize");
        props.add("exceptionHandler");
        props.add("bufferSize");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        SECRET_PROPERTY_NAMES = Collections.emptySet();
    }
}

