/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.abi.datatypes;

import java.math.BigInteger;
import org.web3j.abi.datatypes.NumericType;

public abstract class FixedPointType
extends NumericType {
    static final int DEFAULT_BIT_LENGTH = 128;

    public FixedPointType(String typePrefix, int mBitSize, int nBitSize, BigInteger value) {
        super(typePrefix + mBitSize + "x" + nBitSize, value);
        if (!this.valid(mBitSize, nBitSize, value)) {
            throw new UnsupportedOperationException("Bitsize must be 8 bit aligned, and in range 0 < bitSize <= 256");
        }
    }

    boolean valid(int mBitSize, int nBitSize, BigInteger value) {
        return FixedPointType.isValidBitSize(mBitSize, nBitSize) && FixedPointType.isValidBitCount(mBitSize, nBitSize, value);
    }

    static boolean isValidBitSize(int mBitSize, int nBitSize) {
        int bitSize = mBitSize + nBitSize;
        return mBitSize % 8 == 0 && nBitSize % 8 == 0 && bitSize > 0 && bitSize <= 256;
    }

    private static boolean isValidBitCount(int mBitSize, int nBitSize, BigInteger value) {
        return value.bitCount() <= mBitSize + nBitSize;
    }

    static BigInteger convert(BigInteger m, BigInteger n) {
        return FixedPointType.convert(128, 128, m, n);
    }

    static BigInteger convert(int mBitSize, int nBitSize, BigInteger m, BigInteger n) {
        BigInteger mPadded = m.shiftLeft(nBitSize);
        int nBitLength = n.bitLength();
        int shift = nBitLength + 3 & 0xFFFFFFFC;
        return mPadded.or(n.shiftLeft(nBitSize - shift));
    }
}

