/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.reifier.rest;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.Route;
import org.apache.camel.model.rest.RestBindingDefinition;
import org.apache.camel.model.rest.RestBindingMode;
import org.apache.camel.processor.RestBindingAdvice;
import org.apache.camel.reifier.AbstractReifier;
import org.apache.camel.spi.DataFormat;
import org.apache.camel.spi.RestConfiguration;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.PropertyBindingSupport;

public class RestBindingReifier
extends AbstractReifier {
    private final RestBindingDefinition definition;

    public RestBindingReifier(Route route, RestBindingDefinition definition) {
        super(route);
        this.definition = definition;
    }

    public RestBindingAdvice createRestBindingAdvice() throws Exception {
        RestConfiguration config = CamelContextHelper.getRestConfiguration((CamelContext)this.camelContext, (String)this.definition.getComponent());
        String mode = config.getBindingMode().name();
        if (this.definition.getBindingMode() != null) {
            mode = this.parse(RestBindingMode.class, this.definition.getBindingMode()).name();
        }
        boolean cors = config.isEnableCORS();
        if (this.definition.getEnableCORS() != null) {
            cors = this.parseBoolean(this.definition.getEnableCORS(), false);
        }
        boolean skip = config.isSkipBindingOnErrorCode();
        if (this.definition.getSkipBindingOnErrorCode() != null) {
            skip = this.parseBoolean(this.definition.getSkipBindingOnErrorCode(), false);
        }
        boolean validation = config.isClientRequestValidation();
        if (this.definition.getClientRequestValidation() != null) {
            validation = this.parseBoolean(this.definition.getClientRequestValidation(), false);
        }
        Map corsHeaders = config.getCorsHeaders();
        if ("off".equals(mode)) {
            return new RestBindingAdvice(this.camelContext, null, null, null, null, this.parseString(this.definition.getConsumes()), this.parseString(this.definition.getProduces()), mode, skip, validation, cors, corsHeaders, this.definition.getDefaultValues(), this.definition.getRequiredBody() != null ? this.definition.getRequiredBody() : false, this.definition.getRequiredQueryParameters(), this.definition.getRequiredHeaders());
        }
        DataFormat json = null;
        DataFormat outJson = null;
        if (mode.contains("json") || "auto".equals(mode)) {
            String name = config.getJsonDataFormat();
            if (name != null) {
                Object instance = this.lookupByName(name);
                if (instance != null) {
                    throw new IllegalArgumentException("JsonDataFormat name: " + name + " must not be an existing bean instance from the registry");
                }
            } else {
                name = "json-jackson";
            }
            json = this.camelContext.resolveDataFormat(name);
            outJson = this.camelContext.resolveDataFormat(name);
            if (json != null) {
                this.setupJson(config, this.parseString(this.definition.getType()), this.parseString(this.definition.getOutType()), json, outJson);
            }
        }
        DataFormat jaxb = null;
        DataFormat outJaxb = null;
        if (mode.contains("xml") || "auto".equals(mode)) {
            String name = config.getXmlDataFormat();
            if (name != null) {
                Object instance = this.lookupByName(name);
                if (instance != null) {
                    throw new IllegalArgumentException("XmlDataFormat name: " + name + " must not be an existing bean instance from the registry");
                }
            } else {
                name = "jaxb";
            }
            jaxb = this.camelContext.resolveDataFormat(name);
            outJaxb = this.camelContext.resolveDataFormat(name);
            if (mode.contains("xml") && jaxb == null) {
                throw new IllegalArgumentException("XML DataFormat " + name + " not found.");
            }
            if (jaxb != null) {
                ((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).getRestBindingJaxbDataFormatFactory().setupJaxb(this.camelContext, config, this.parseString(this.definition.getType()), this.parseString(this.definition.getOutType()), jaxb, outJaxb);
            }
        }
        return new RestBindingAdvice(this.camelContext, json, jaxb, outJson, outJaxb, this.parseString(this.definition.getConsumes()), this.parseString(this.definition.getProduces()), mode, skip, validation, cors, corsHeaders, this.definition.getDefaultValues(), this.definition.getRequiredBody() != null ? this.definition.getRequiredBody() : false, this.definition.getRequiredQueryParameters(), this.definition.getRequiredHeaders());
    }

    protected void setupJson(RestConfiguration config, String type, String outType, DataFormat json, DataFormat outJson) throws Exception {
        Class clazz = null;
        if (type != null) {
            String typeName = type.endsWith("[]") ? type.substring(0, type.length() - 2) : type;
            clazz = this.camelContext.getClassResolver().resolveMandatoryClass(typeName);
        }
        if (clazz != null) {
            ((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).getBeanIntrospection().setProperty(this.camelContext, (Object)json, "unmarshalType", (Object)clazz);
            ((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).getBeanIntrospection().setProperty(this.camelContext, (Object)json, "useList", (Object)type.endsWith("[]"));
        }
        this.setAdditionalConfiguration(config, json, "json.in.");
        Class outClazz = null;
        if (outType != null) {
            String typeName = outType.endsWith("[]") ? outType.substring(0, outType.length() - 2) : outType;
            outClazz = this.camelContext.getClassResolver().resolveMandatoryClass(typeName);
        }
        if (outClazz != null) {
            ((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).getBeanIntrospection().setProperty(this.camelContext, (Object)outJson, "unmarshalType", (Object)outClazz);
            ((ExtendedCamelContext)this.camelContext.adapt(ExtendedCamelContext.class)).getBeanIntrospection().setProperty(this.camelContext, (Object)outJson, "useList", (Object)outType.endsWith("[]"));
        }
        this.setAdditionalConfiguration(config, outJson, "json.out.");
    }

    private void setAdditionalConfiguration(RestConfiguration config, DataFormat dataFormat, String prefix) throws Exception {
        if (config.getDataFormatProperties() != null && !config.getDataFormatProperties().isEmpty()) {
            HashMap copy = new HashMap();
            for (Map.Entry entry : config.getDataFormatProperties().entrySet()) {
                String key = (String)entry.getKey();
                boolean known = this.isKeyKnownPrefix(key);
                String copyKey = known ? key.substring(prefix.length()) : key;
                if (known && !key.startsWith(prefix)) continue;
                copy.put(copyKey, entry.getValue());
            }
            PropertyBindingSupport.build().bind(this.camelContext, (Object)dataFormat, copy);
        }
    }

    private boolean isKeyKnownPrefix(String key) {
        return key.startsWith("json.in.") || key.startsWith("json.out.") || key.startsWith("xml.in.") || key.startsWith("xml.out.");
    }
}

