/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.direct;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.direct.DirectConsumer;
import org.apache.camel.component.direct.DirectProducer;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriPath;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.util.StopWatch;
import org.apache.camel.util.StringHelper;

@UriEndpoint(firstVersion="1.0.0", scheme="direct", title="Direct", syntax="direct:name", label="core,endpoint")
public class DirectEndpoint
extends DefaultEndpoint {
    private final Map<String, DirectConsumer> consumers;
    @UriPath(description="Name of direct endpoint")
    @Metadata(required=true)
    private String name;
    @UriParam(label="producer", defaultValue="true")
    private boolean block = true;
    @UriParam(label="producer", defaultValue="30000")
    private long timeout = 30000L;
    @UriParam(label="producer")
    private boolean failIfNoConsumers = true;

    public DirectEndpoint() {
        this.consumers = new HashMap<String, DirectConsumer>();
    }

    public DirectEndpoint(String endpointUri, Component component) {
        this(endpointUri, component, new HashMap<String, DirectConsumer>());
    }

    public DirectEndpoint(String uri, Component component, Map<String, DirectConsumer> consumers) {
        super(uri, component);
        this.consumers = consumers;
    }

    public Producer createProducer() throws Exception {
        return new DirectProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        DirectConsumer answer = new DirectConsumer((Endpoint)this, processor);
        this.configureConsumer((Consumer)answer);
        return answer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConsumer(DirectConsumer consumer) {
        String key = this.getKey();
        Map<String, DirectConsumer> map = this.consumers;
        synchronized (map) {
            if (this.consumers.putIfAbsent(key, consumer) != null) {
                throw new IllegalArgumentException("Cannot add a 2nd consumer to the same endpoint. Endpoint " + (Object)((Object)this) + " only allows one consumer.");
            }
            this.consumers.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConsumer(DirectConsumer consumer) {
        String key = this.getKey();
        Map<String, DirectConsumer> map = this.consumers;
        synchronized (map) {
            this.consumers.remove(key, (Object)consumer);
            this.consumers.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DirectConsumer getConsumer() throws InterruptedException {
        String key = this.getKey();
        Map<String, DirectConsumer> map = this.consumers;
        synchronized (map) {
            DirectConsumer answer = this.consumers.get(key);
            if (answer == null && this.block) {
                long rem;
                StopWatch watch = new StopWatch();
                while ((answer = this.consumers.get(key)) == null && (rem = this.timeout - watch.taken()) > 0L) {
                    this.consumers.wait(rem);
                }
            }
            return answer;
        }
    }

    public boolean isBlock() {
        return this.block;
    }

    public void setBlock(boolean block) {
        this.block = block;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public boolean isFailIfNoConsumers() {
        return this.failIfNoConsumers;
    }

    public void setFailIfNoConsumers(boolean failIfNoConsumers) {
        this.failIfNoConsumers = failIfNoConsumers;
    }

    protected String getKey() {
        String uri = this.getEndpointUri();
        if (uri.indexOf(63) != -1) {
            return StringHelper.before((String)uri, (String)"?");
        }
        return uri;
    }
}

