/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.tx;

import java.io.IOException;
import java.math.BigInteger;
import org.web3j.ens.EnsResolver;
import org.web3j.protocol.Web3j;
import org.web3j.protocol.core.methods.response.EthGasPrice;
import org.web3j.protocol.core.methods.response.TransactionReceipt;
import org.web3j.protocol.exceptions.TransactionException;
import org.web3j.tx.TransactionManager;

public abstract class ManagedTransaction {
    public static final BigInteger GAS_PRICE = BigInteger.valueOf(22000000000L);
    protected Web3j web3j;
    protected TransactionManager transactionManager;
    protected EnsResolver ensResolver;

    protected ManagedTransaction(Web3j web3j, TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
        this.web3j = web3j;
        this.ensResolver = new EnsResolver(web3j);
    }

    public long getSyncThreshold() {
        return this.ensResolver.getSyncThreshold();
    }

    public void setSyncThreshold(long syncThreshold) {
        this.ensResolver.setSyncThreshold(syncThreshold);
    }

    public BigInteger requestCurrentGasPrice() throws IOException {
        EthGasPrice ethGasPrice = this.web3j.ethGasPrice().send();
        return ethGasPrice.getGasPrice();
    }

    protected TransactionReceipt send(String to, String data, BigInteger value, BigInteger gasPrice, BigInteger gasLimit) throws IOException, TransactionException {
        return this.transactionManager.executeTransaction(gasPrice, gasLimit, to, data, value);
    }
}

