/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.protocol.geth;

import java.util.Arrays;
import java.util.Collections;
import org.web3j.protocol.Web3jService;
import org.web3j.protocol.admin.JsonRpc2_0Admin;
import org.web3j.protocol.admin.methods.response.BooleanResponse;
import org.web3j.protocol.admin.methods.response.PersonalSign;
import org.web3j.protocol.core.Request;
import org.web3j.protocol.core.methods.response.EthSubscribe;
import org.web3j.protocol.core.methods.response.MinerStartResponse;
import org.web3j.protocol.geth.Geth;
import org.web3j.protocol.geth.response.PersonalEcRecover;
import org.web3j.protocol.geth.response.PersonalImportRawKey;
import org.web3j.protocol.websocket.events.PendingTransactionNotification;
import org.web3j.protocol.websocket.events.SyncingNotfication;
import rx.Observable;

public class JsonRpc2_0Geth
extends JsonRpc2_0Admin
implements Geth {
    public JsonRpc2_0Geth(Web3jService web3jService) {
        super(web3jService);
    }

    @Override
    public Request<?, PersonalImportRawKey> personalImportRawKey(String keydata, String password) {
        return new Request("personal_importRawKey", Arrays.asList(keydata, password), this.web3jService, PersonalImportRawKey.class);
    }

    @Override
    public Request<?, BooleanResponse> personalLockAccount(String accountId) {
        return new Request("personal_lockAccount", Arrays.asList(accountId), this.web3jService, BooleanResponse.class);
    }

    @Override
    public Request<?, PersonalSign> personalSign(String message, String accountId, String password) {
        return new Request("personal_sign", Arrays.asList(message, accountId, password), this.web3jService, PersonalSign.class);
    }

    @Override
    public Request<?, PersonalEcRecover> personalEcRecover(String hexMessage, String signedMessage) {
        return new Request("personal_ecRecover", Arrays.asList(hexMessage, signedMessage), this.web3jService, PersonalEcRecover.class);
    }

    @Override
    public Request<?, MinerStartResponse> minerStart(int threadCount) {
        return new Request("miner_start", Arrays.asList(threadCount), this.web3jService, MinerStartResponse.class);
    }

    @Override
    public Request<?, BooleanResponse> minerStop() {
        return new Request("miner_stop", Collections.emptyList(), this.web3jService, BooleanResponse.class);
    }

    @Override
    public Observable<PendingTransactionNotification> newPendingTransactionsNotifications() {
        return this.web3jService.subscribe(new Request("eth_subscribe", Arrays.asList("newPendingTransactions"), this.web3jService, EthSubscribe.class), "eth_unsubscribe", PendingTransactionNotification.class);
    }

    @Override
    public Observable<SyncingNotfication> syncingStatusNotifications() {
        return this.web3jService.subscribe(new Request("eth_subscribe", Arrays.asList("syncing"), this.web3jService, EthSubscribe.class), "eth_unsubscribe", SyncingNotfication.class);
    }
}

