/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model.dataformat;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.dataformat.AvroLibrary;
import org.apache.camel.spi.Metadata;

@Metadata(firstVersion="2.14.0", label="dataformat,transformation", title="Avro")
@XmlRootElement(name="avro")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class AvroDataFormat
extends DataFormatDefinition {
    @XmlAttribute
    private String instanceClassName;
    @XmlTransient
    private Object schema;
    @XmlAttribute
    @Metadata(defaultValue="ApacheAvro")
    private AvroLibrary library = AvroLibrary.ApacheAvro;
    @XmlAttribute
    private String objectMapper;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean", defaultValue="true")
    private String useDefaultObjectMapper;
    @XmlAttribute
    private String unmarshalTypeName;
    @XmlTransient
    private Class<?> unmarshalType;
    @XmlAttribute
    private String jsonViewTypeName;
    @XmlTransient
    private Class<?> jsonView;
    @XmlAttribute
    private String include;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String allowJmsType;
    @XmlAttribute
    private String collectionTypeName;
    @XmlTransient
    private Class<?> collectionType;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String useList;
    @XmlAttribute
    private String moduleClassNames;
    @XmlAttribute
    private String moduleRefs;
    @XmlAttribute
    private String enableFeatures;
    @XmlAttribute
    private String disableFeatures;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean")
    private String allowUnmarshallType;
    @XmlAttribute
    private String timezone;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean", defaultValue="false")
    private String autoDiscoverObjectMapper;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean", defaultValue="true", description="Whether the data format should set the Content-Type header with the type from the data format. For example application/xml for data formats marshalling to XML, or application/json for data formats marshalling to JSON")
    private String contentTypeHeader;
    @XmlAttribute
    private String schemaResolver;
    @XmlAttribute
    @Metadata(javaType="java.lang.Boolean", defaultValue="true")
    private String autoDiscoverSchemaResolver;

    public AvroDataFormat() {
        super("avro");
    }

    public AvroDataFormat(AvroLibrary library) {
        this();
        this.setLibrary(library);
    }

    public AvroDataFormat(String instanceClassName) {
        this();
        this.setInstanceClassName(instanceClassName);
    }

    public String getInstanceClassName() {
        return this.instanceClassName;
    }

    public void setInstanceClassName(String instanceClassName) {
        this.instanceClassName = instanceClassName;
    }

    public Object getSchema() {
        return this.schema;
    }

    public void setSchema(Object schema) {
        this.schema = schema;
    }

    public AvroLibrary getLibrary() {
        return this.library;
    }

    public void setLibrary(AvroLibrary library) {
        this.library = library;
    }

    public String getContentTypeHeader() {
        return this.contentTypeHeader;
    }

    public void setContentTypeHeader(String contentTypeHeader) {
        this.contentTypeHeader = contentTypeHeader;
    }

    public String getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(String objectMapper) {
        this.objectMapper = objectMapper;
    }

    public String getUseDefaultObjectMapper() {
        return this.useDefaultObjectMapper;
    }

    public void setUseDefaultObjectMapper(String useDefaultObjectMapper) {
        this.useDefaultObjectMapper = useDefaultObjectMapper;
    }

    public String getUnmarshalTypeName() {
        return this.unmarshalTypeName;
    }

    public void setUnmarshalTypeName(String unmarshalTypeName) {
        this.unmarshalTypeName = unmarshalTypeName;
    }

    public Class<?> getUnmarshalType() {
        return this.unmarshalType;
    }

    public void setUnmarshalType(Class<?> unmarshalType) {
        this.unmarshalType = unmarshalType;
    }

    public String getJsonViewTypeName() {
        return this.jsonViewTypeName;
    }

    public void setJsonViewTypeName(String jsonViewTypeName) {
        this.jsonViewTypeName = jsonViewTypeName;
    }

    public Class<?> getJsonView() {
        return this.jsonView;
    }

    public void setJsonView(Class<?> jsonView) {
        this.jsonView = jsonView;
    }

    public String getInclude() {
        return this.include;
    }

    public void setInclude(String include) {
        this.include = include;
    }

    public String getAllowJmsType() {
        return this.allowJmsType;
    }

    public void setAllowJmsType(String allowJmsType) {
        this.allowJmsType = allowJmsType;
    }

    public String getCollectionTypeName() {
        return this.collectionTypeName;
    }

    public void setCollectionTypeName(String collectionTypeName) {
        this.collectionTypeName = collectionTypeName;
    }

    public Class<?> getCollectionType() {
        return this.collectionType;
    }

    public void setCollectionType(Class<?> collectionType) {
        this.collectionType = collectionType;
    }

    public String getUseList() {
        return this.useList;
    }

    public void setUseList(String useList) {
        this.useList = useList;
    }

    public String getModuleClassNames() {
        return this.moduleClassNames;
    }

    public void setModuleClassNames(String moduleClassNames) {
        this.moduleClassNames = moduleClassNames;
    }

    public String getModuleRefs() {
        return this.moduleRefs;
    }

    public void setModuleRefs(String moduleRefs) {
        this.moduleRefs = moduleRefs;
    }

    public String getEnableFeatures() {
        return this.enableFeatures;
    }

    public void setEnableFeatures(String enableFeatures) {
        this.enableFeatures = enableFeatures;
    }

    public String getDisableFeatures() {
        return this.disableFeatures;
    }

    public void setDisableFeatures(String disableFeatures) {
        this.disableFeatures = disableFeatures;
    }

    public String getAllowUnmarshallType() {
        return this.allowUnmarshallType;
    }

    public void setAllowUnmarshallType(String allowUnmarshallType) {
        this.allowUnmarshallType = allowUnmarshallType;
    }

    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(String timezone) {
        this.timezone = timezone;
    }

    public String getAutoDiscoverObjectMapper() {
        return this.autoDiscoverObjectMapper;
    }

    public void setAutoDiscoverObjectMapper(String autoDiscoverObjectMapper) {
        this.autoDiscoverObjectMapper = autoDiscoverObjectMapper;
    }

    @Override
    public String getDataFormatName() {
        return this.library != null ? this.library.getDataFormatName() : "avro";
    }

    public void setSchemaResolver(String schemaResolver) {
        this.schemaResolver = schemaResolver;
    }

    public String getSchemaResolver() {
        return this.schemaResolver;
    }

    public String getAutoDiscoverSchemaResolver() {
        return this.autoDiscoverSchemaResolver;
    }

    public void setAutoDiscoverSchemaResolver(String autoDiscoverSchemaResolver) {
        this.autoDiscoverSchemaResolver = autoDiscoverSchemaResolver;
    }

    public AvroDataFormat objectMapper(String objectMapper) {
        this.objectMapper = objectMapper;
        return this;
    }

    public AvroDataFormat useDefaultObjectMapper(boolean useDefaultObjectMapper) {
        return this.useDefaultObjectMapper(Boolean.toString(useDefaultObjectMapper));
    }

    public AvroDataFormat useDefaultObjectMapper(String useDefaultObjectMapper) {
        this.useDefaultObjectMapper = useDefaultObjectMapper;
        return this;
    }

    public AvroDataFormat unmarshalType(String unmarshalType) {
        this.unmarshalTypeName = unmarshalType;
        return this;
    }

    public AvroDataFormat unmarshalType(Class<?> unmarshalType) {
        this.unmarshalType = unmarshalType;
        return this;
    }

    public AvroDataFormat jsonView(Class<?> jsonView) {
        this.jsonView = jsonView;
        return this;
    }

    public AvroDataFormat include(String include) {
        this.include = include;
        return this;
    }

    public AvroDataFormat collectionType(String collectionType) {
        this.collectionTypeName = collectionType;
        return this;
    }

    public AvroDataFormat collectionType(Class<?> collectionType) {
        this.collectionType = collectionType;
        return this;
    }

    public AvroDataFormat useList(boolean useList) {
        return this.useList(Boolean.toString(useList));
    }

    public AvroDataFormat useList(String useList) {
        this.useList = useList;
        return this;
    }

    public AvroDataFormat moduleClassNames(String moduleClassNames) {
        this.moduleClassNames = moduleClassNames;
        return this;
    }

    public AvroDataFormat moduleRefs(String moduleRefs) {
        this.moduleRefs = moduleRefs;
        return this;
    }

    public AvroDataFormat enableFeatures(String enableFeatures) {
        this.enableFeatures = enableFeatures;
        return this;
    }

    public AvroDataFormat disableFeatures(String disableFeatures) {
        this.disableFeatures = disableFeatures;
        return this;
    }

    public AvroDataFormat allowUnmarshallType(boolean allowUnmarshallType) {
        return this.allowUnmarshallType(Boolean.toString(allowUnmarshallType));
    }

    public AvroDataFormat allowUnmarshallType(String allowUnmarshallType) {
        this.allowUnmarshallType = allowUnmarshallType;
        return this;
    }

    public AvroDataFormat autoDiscoverObjectMapper(boolean autoDiscoverObjectMapper) {
        return this.autoDiscoverObjectMapper(Boolean.toString(autoDiscoverObjectMapper));
    }

    public AvroDataFormat autoDiscoverObjectMapper(String autoDiscoverObjectMapper) {
        this.autoDiscoverObjectMapper = autoDiscoverObjectMapper;
        return this;
    }
}

