/*
 * Decompiled with CFR 0.152.
 */
package org.web3j.rlp;

import java.util.Arrays;
import java.util.List;
import org.web3j.rlp.RlpDecoder;
import org.web3j.rlp.RlpList;
import org.web3j.rlp.RlpString;
import org.web3j.rlp.RlpType;

public class RlpEncoder {
    public static byte[] encode(RlpType value) {
        if (value instanceof RlpString) {
            return RlpEncoder.encodeString((RlpString)value);
        }
        return RlpEncoder.encodeList((RlpList)value);
    }

    private static byte[] encode(byte[] bytesValue, int offset) {
        if (bytesValue.length == 1 && offset == RlpDecoder.OFFSET_SHORT_STRING && bytesValue[0] >= 0 && bytesValue[0] <= 127) {
            return bytesValue;
        }
        if (bytesValue.length <= 55) {
            byte[] result = new byte[bytesValue.length + 1];
            result[0] = (byte)(offset + bytesValue.length);
            System.arraycopy(bytesValue, 0, result, 1, bytesValue.length);
            return result;
        }
        byte[] encodedStringLength = RlpEncoder.toMinimalByteArray(bytesValue.length);
        byte[] result = new byte[bytesValue.length + encodedStringLength.length + 1];
        result[0] = (byte)(offset + 55 + encodedStringLength.length);
        System.arraycopy(encodedStringLength, 0, result, 1, encodedStringLength.length);
        System.arraycopy(bytesValue, 0, result, encodedStringLength.length + 1, bytesValue.length);
        return result;
    }

    static byte[] encodeString(RlpString value) {
        return RlpEncoder.encode(value.getBytes(), RlpDecoder.OFFSET_SHORT_STRING);
    }

    private static byte[] toMinimalByteArray(int value) {
        byte[] encoded = RlpEncoder.toByteArray(value);
        for (int i = 0; i < encoded.length; ++i) {
            if (encoded[i] == 0) continue;
            return Arrays.copyOfRange(encoded, i, encoded.length);
        }
        return new byte[0];
    }

    private static byte[] toByteArray(int value) {
        return new byte[]{(byte)(value >> 24 & 0xFF), (byte)(value >> 16 & 0xFF), (byte)(value >> 8 & 0xFF), (byte)(value & 0xFF)};
    }

    static byte[] encodeList(RlpList value) {
        List<RlpType> values = value.getValues();
        if (values.isEmpty()) {
            return RlpEncoder.encode(new byte[0], RlpDecoder.OFFSET_SHORT_LIST);
        }
        byte[] result = new byte[]{};
        for (RlpType entry : values) {
            result = RlpEncoder.concat(result, RlpEncoder.encode(entry));
        }
        return RlpEncoder.encode(result, RlpDecoder.OFFSET_SHORT_LIST);
    }

    private static byte[] concat(byte[] b1, byte[] b2) {
        byte[] result = Arrays.copyOf(b1, b1.length + b2.length);
        System.arraycopy(b2, 0, result, b1.length, b2.length);
        return result;
    }
}

