/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.language.simple.ast;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Expression;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.language.simple.SimpleExpressionBuilder;
import org.apache.camel.language.simple.ast.LiteralExpression;
import org.apache.camel.language.simple.types.SimpleParserException;
import org.apache.camel.language.simple.types.SimpleToken;
import org.apache.camel.spi.Language;
import org.apache.camel.support.builder.ExpressionBuilder;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.OgnlHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.URISupport;

public class SimpleFunctionExpression
extends LiteralExpression {
    private Map<String, Expression> cacheExpression;

    public SimpleFunctionExpression(SimpleToken token, Map<String, Expression> cacheExpression) {
        super(token);
        this.cacheExpression = cacheExpression;
    }

    @Override
    public Expression createExpression(CamelContext camelContext, String expression) {
        Expression answer;
        String function = this.text.toString();
        Expression expression2 = answer = this.cacheExpression != null ? this.cacheExpression.get(function) : null;
        if (answer == null) {
            answer = this.createSimpleExpression(camelContext, function, true);
            if (answer != null) {
                answer.init(camelContext);
            }
            if (this.cacheExpression != null && answer != null) {
                this.cacheExpression.put(function, answer);
            }
        }
        return answer;
    }

    private Expression createSimpleExpression(CamelContext camelContext, String function, boolean strict) {
        String[] parts;
        Expression fileExpression;
        Expression answer = this.createSimpleExpressionDirectly(camelContext, function);
        if (answer != null) {
            return answer;
        }
        answer = this.createSimpleExpressionBodyOrHeader(function, strict);
        if (answer != null) {
            return answer;
        }
        String remainder = this.ifStartsWithReturnRemainder("camelContext", function);
        if (remainder != null) {
            boolean invalid = OgnlHelper.isInvalidValidOgnlExpression((String)remainder);
            if (invalid) {
                throw new SimpleParserException("Valid syntax: ${camelContext.OGNL} was: " + function, this.token.getIndex());
            }
            return SimpleExpressionBuilder.camelContextOgnlExpression(remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("exception", function);
        if (remainder != null) {
            boolean invalid = OgnlHelper.isInvalidValidOgnlExpression((String)remainder);
            if (invalid) {
                throw new SimpleParserException("Valid syntax: ${exception.OGNL} was: " + function, this.token.getIndex());
            }
            return SimpleExpressionBuilder.exchangeExceptionOgnlExpression(remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("exchangeProperty", function);
        if (remainder != null) {
            boolean invalid;
            if (remainder.startsWith(".") || remainder.startsWith("?")) {
                remainder = remainder.substring(1);
            }
            if (remainder.startsWith("[") && remainder.endsWith("]")) {
                remainder = remainder.substring(1, remainder.length() - 1);
            }
            if (invalid = OgnlHelper.isInvalidValidOgnlExpression((String)remainder)) {
                throw new SimpleParserException("Valid syntax: ${exchangeProperty.OGNL} was: " + function, this.token.getIndex());
            }
            if (OgnlHelper.isValidOgnlExpression((String)remainder)) {
                return SimpleExpressionBuilder.propertyOgnlExpression(remainder);
            }
            return ExpressionBuilder.exchangePropertyExpression((String)remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("sys.", function);
        if (remainder != null) {
            return ExpressionBuilder.systemPropertyExpression((String)remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("sysenv.", function);
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("sysenv:", function);
        }
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("env.", function);
        }
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("env:", function);
        }
        if (remainder != null) {
            return ExpressionBuilder.systemEnvironmentExpression((String)remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("exchange", function);
        if (remainder != null) {
            boolean invalid = OgnlHelper.isInvalidValidOgnlExpression((String)remainder);
            if (invalid) {
                throw new SimpleParserException("Valid syntax: ${exchange.OGNL} was: " + function, this.token.getIndex());
            }
            return SimpleExpressionBuilder.exchangeOgnlExpression(remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("file:", function);
        if (remainder != null && (fileExpression = this.createSimpleFileExpression(remainder, strict)) != null) {
            return fileExpression;
        }
        remainder = this.ifStartsWithReturnRemainder("date:", function);
        if (remainder != null) {
            parts = remainder.split(":", 2);
            if (parts.length == 1) {
                return SimpleExpressionBuilder.dateExpression(parts[0]);
            }
            if (parts.length == 2) {
                return SimpleExpressionBuilder.dateExpression(parts[0], parts[1]);
            }
        }
        if ((remainder = this.ifStartsWithReturnRemainder("date-with-timezone:", function)) != null) {
            parts = remainder.split(":", 3);
            if (parts.length < 3) {
                throw new SimpleParserException("Valid syntax: ${date-with-timezone:command:timezone:pattern} was: " + function, this.token.getIndex());
            }
            return SimpleExpressionBuilder.dateExpression(parts[0], parts[1], parts[2]);
        }
        remainder = this.ifStartsWithReturnRemainder("bean:", function);
        if (remainder != null) {
            Language bean = camelContext.resolveLanguage("bean");
            String ref = remainder;
            String method = null;
            Object scope = null;
            if (remainder.contains("?method=") || remainder.contains("?scope=")) {
                ref = StringHelper.before((String)remainder, (String)"?");
                String query = StringHelper.after((String)remainder, (String)"?");
                try {
                    Map map = URISupport.parseQuery((String)query);
                    method = (String)map.get("method");
                    scope = map.get("scope");
                }
                catch (URISyntaxException e) {
                    throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
                }
            } else {
                int doubleColonIndex = remainder.indexOf("::");
                int beginOfParameterDeclaration = remainder.indexOf(40);
                if (!(doubleColonIndex <= 0 || remainder.contains("(") && doubleColonIndex >= beginOfParameterDeclaration)) {
                    ref = remainder.substring(0, doubleColonIndex);
                    method = remainder.substring(doubleColonIndex + 2);
                } else {
                    int idx = remainder.indexOf(46);
                    if (idx > 0) {
                        ref = remainder.substring(0, idx);
                        method = remainder.substring(idx + 1);
                    }
                }
            }
            Class type = null;
            if (ref != null && ref.startsWith("type:")) {
                try {
                    type = camelContext.getClassResolver().resolveMandatoryClass(ref.substring(5));
                    ref = null;
                }
                catch (ClassNotFoundException e) {
                    throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
                }
            }
            Object[] properties = new Object[5];
            properties[2] = type;
            properties[3] = ref;
            properties[1] = method;
            properties[4] = scope;
            return bean.createExpression(null, properties);
        }
        remainder = this.ifStartsWithReturnRemainder("properties:", function);
        if (remainder != null) {
            parts = remainder.split(":", 2);
            if (parts.length > 2) {
                throw new SimpleParserException("Valid syntax: ${properties:key[:default]} was: " + function, this.token.getIndex());
            }
            String defaultValue = null;
            if (parts.length >= 2) {
                defaultValue = parts[1];
            }
            String key = parts[0];
            return ExpressionBuilder.propertiesComponentExpression((String)key, (String)defaultValue);
        }
        remainder = this.ifStartsWithReturnRemainder("ref:", function);
        if (remainder != null) {
            return ExpressionBuilder.refExpression((String)remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("type:", function);
        if (remainder != null) {
            Expression exp = SimpleExpressionBuilder.typeExpression(remainder);
            exp.init(camelContext);
            return SimpleExpressionBuilder.cacheExpression(exp);
        }
        Expression misc = this.createSimpleExpressionMisc(function);
        if (misc != null) {
            return misc;
        }
        if (strict) {
            throw new SimpleParserException("Unknown function: " + function, this.token.getIndex());
        }
        return null;
    }

    private Expression createSimpleExpressionBodyOrHeader(String function, boolean strict) {
        String remainder = this.ifStartsWithReturnRemainder("bodyAs(", function);
        if (remainder != null) {
            String type = StringHelper.before((String)remainder, (String)")");
            if (type == null) {
                throw new SimpleParserException("Valid syntax: ${bodyAs(type)} was: " + function, this.token.getIndex());
            }
            type = StringHelper.removeQuotes((String)type);
            if (ObjectHelper.isNotEmpty((Object)(remainder = StringHelper.after((String)remainder, (String)")")))) {
                boolean invalid = OgnlHelper.isInvalidValidOgnlExpression((String)remainder);
                if (invalid) {
                    throw new SimpleParserException("Valid syntax: ${bodyAs(type).OGNL} was: " + function, this.token.getIndex());
                }
                return SimpleExpressionBuilder.bodyOgnlExpression(type, remainder);
            }
            return ExpressionBuilder.bodyExpression((String)type);
        }
        remainder = this.ifStartsWithReturnRemainder("mandatoryBodyAs(", function);
        if (remainder != null) {
            String type = StringHelper.before((String)remainder, (String)")");
            if (type == null) {
                throw new SimpleParserException("Valid syntax: ${mandatoryBodyAs(type)} was: " + function, this.token.getIndex());
            }
            type = StringHelper.removeQuotes((String)type);
            if (ObjectHelper.isNotEmpty((Object)(remainder = StringHelper.after((String)remainder, (String)")")))) {
                boolean invalid = OgnlHelper.isInvalidValidOgnlExpression((String)remainder);
                if (invalid) {
                    throw new SimpleParserException("Valid syntax: ${mandatoryBodyAs(type).OGNL} was: " + function, this.token.getIndex());
                }
                return SimpleExpressionBuilder.mandatoryBodyOgnlExpression(type, remainder);
            }
            return SimpleExpressionBuilder.mandatoryBodyExpression(type);
        }
        remainder = this.ifStartsWithReturnRemainder("body", function);
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("in.body", function);
        }
        if (remainder != null) {
            boolean invalid;
            boolean ognlStart = remainder.startsWith(".") || remainder.startsWith("?") || remainder.startsWith("[");
            boolean bl = invalid = !ognlStart || OgnlHelper.isInvalidValidOgnlExpression((String)remainder);
            if (invalid) {
                throw new SimpleParserException("Valid syntax: ${body.OGNL} was: " + function, this.token.getIndex());
            }
            return SimpleExpressionBuilder.bodyOgnlExpression(remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("headerAs(", function);
        if (remainder != null) {
            String keyAndType = StringHelper.before((String)remainder, (String)")");
            if (keyAndType == null) {
                throw new SimpleParserException("Valid syntax: ${headerAs(key, type)} was: " + function, this.token.getIndex());
            }
            String key = StringHelper.before((String)keyAndType, (String)",");
            String type = StringHelper.after((String)keyAndType, (String)",");
            remainder = StringHelper.after((String)remainder, (String)")");
            if (ObjectHelper.isEmpty((Object)key) || ObjectHelper.isEmpty((Object)type) || ObjectHelper.isNotEmpty((Object)remainder)) {
                throw new SimpleParserException("Valid syntax: ${headerAs(key, type)} was: " + function, this.token.getIndex());
            }
            key = StringHelper.removeQuotes((String)key);
            type = StringHelper.removeQuotes((String)type);
            return ExpressionBuilder.headerExpression((String)key, (String)type);
        }
        if ("in.headers".equals(function) || "headers".equals(function)) {
            return ExpressionBuilder.headersExpression();
        }
        remainder = this.ifStartsWithReturnRemainder("in.headers", function);
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("in.header", function);
        }
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("headers", function);
        }
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("header", function);
        }
        if (remainder != null) {
            String key;
            boolean invalid;
            if (remainder.startsWith(".") || remainder.startsWith(":") || remainder.startsWith("?")) {
                remainder = remainder.substring(1);
            }
            if (remainder.startsWith("[") && remainder.endsWith("]")) {
                remainder = remainder.substring(1, remainder.length() - 1);
            }
            if (invalid = OgnlHelper.isInvalidValidOgnlExpression((String)(key = StringHelper.removeLeadingAndEndingQuotes((String)remainder)))) {
                throw new SimpleParserException("Valid syntax: ${header.name[key]} was: " + function, this.token.getIndex());
            }
            if (OgnlHelper.isValidOgnlExpression((String)key)) {
                return SimpleExpressionBuilder.headersOgnlExpression(key);
            }
            return ExpressionBuilder.headerExpression((String)key);
        }
        return null;
    }

    private Expression createSimpleExpressionDirectly(CamelContext camelContext, String expression) {
        if (ObjectHelper.isEqualToAny((Object)expression, (Object[])new Object[]{"body", "in.body"})) {
            return ExpressionBuilder.bodyExpression();
        }
        if (ObjectHelper.equal((Object)expression, (Object)"bodyOneLine")) {
            return ExpressionBuilder.bodyOneLine();
        }
        if (ObjectHelper.equal((Object)expression, (Object)"id")) {
            return ExpressionBuilder.messageIdExpression();
        }
        if (ObjectHelper.equal((Object)expression, (Object)"messageTimestamp")) {
            return ExpressionBuilder.messageTimestampExpression();
        }
        if (ObjectHelper.equal((Object)expression, (Object)"exchangeId")) {
            return ExpressionBuilder.exchangeIdExpression();
        }
        if (ObjectHelper.equal((Object)expression, (Object)"exchange")) {
            return ExpressionBuilder.exchangeExpression();
        }
        if (ObjectHelper.equal((Object)expression, (Object)"exception")) {
            return ExpressionBuilder.exchangeExceptionExpression();
        }
        if (ObjectHelper.equal((Object)expression, (Object)"exception.message")) {
            return ExpressionBuilder.exchangeExceptionMessageExpression();
        }
        if (ObjectHelper.equal((Object)expression, (Object)"exception.stacktrace")) {
            return ExpressionBuilder.exchangeExceptionStackTraceExpression();
        }
        if (ObjectHelper.equal((Object)expression, (Object)"threadName")) {
            return ExpressionBuilder.threadNameExpression();
        }
        if (ObjectHelper.equal((Object)expression, (Object)"hostname")) {
            return ExpressionBuilder.hostnameExpression();
        }
        if (ObjectHelper.equal((Object)expression, (Object)"camelId")) {
            return ExpressionBuilder.camelContextNameExpression();
        }
        if (ObjectHelper.equal((Object)expression, (Object)"routeId")) {
            return ExpressionBuilder.routeIdExpression();
        }
        if (ObjectHelper.equal((Object)expression, (Object)"stepId")) {
            return ExpressionBuilder.stepIdExpression();
        }
        if (ObjectHelper.equal((Object)expression, (Object)"null")) {
            return SimpleExpressionBuilder.nullExpression();
        }
        return null;
    }

    private Expression createSimpleFileExpression(String remainder, boolean strict) {
        if (ObjectHelper.equal((Object)remainder, (Object)"name")) {
            return SimpleExpressionBuilder.fileNameExpression();
        }
        if (ObjectHelper.equal((Object)remainder, (Object)"name.noext")) {
            return SimpleExpressionBuilder.fileNameNoExtensionExpression();
        }
        if (ObjectHelper.equal((Object)remainder, (Object)"name.noext.single")) {
            return SimpleExpressionBuilder.fileNameNoExtensionSingleExpression();
        }
        if (ObjectHelper.equal((Object)remainder, (Object)"name.ext") || ObjectHelper.equal((Object)remainder, (Object)"ext")) {
            return SimpleExpressionBuilder.fileExtensionExpression();
        }
        if (ObjectHelper.equal((Object)remainder, (Object)"name.ext.single")) {
            return SimpleExpressionBuilder.fileExtensionSingleExpression();
        }
        if (ObjectHelper.equal((Object)remainder, (Object)"onlyname")) {
            return SimpleExpressionBuilder.fileOnlyNameExpression();
        }
        if (ObjectHelper.equal((Object)remainder, (Object)"onlyname.noext")) {
            return SimpleExpressionBuilder.fileOnlyNameNoExtensionExpression();
        }
        if (ObjectHelper.equal((Object)remainder, (Object)"onlyname.noext.single")) {
            return SimpleExpressionBuilder.fileOnlyNameNoExtensionSingleExpression();
        }
        if (ObjectHelper.equal((Object)remainder, (Object)"parent")) {
            return SimpleExpressionBuilder.fileParentExpression();
        }
        if (ObjectHelper.equal((Object)remainder, (Object)"path")) {
            return SimpleExpressionBuilder.filePathExpression();
        }
        if (ObjectHelper.equal((Object)remainder, (Object)"absolute")) {
            return SimpleExpressionBuilder.fileAbsoluteExpression();
        }
        if (ObjectHelper.equal((Object)remainder, (Object)"absolute.path")) {
            return SimpleExpressionBuilder.fileAbsolutePathExpression();
        }
        if (ObjectHelper.equal((Object)remainder, (Object)"length") || ObjectHelper.equal((Object)remainder, (Object)"size")) {
            return SimpleExpressionBuilder.fileSizeExpression();
        }
        if (ObjectHelper.equal((Object)remainder, (Object)"modified")) {
            return SimpleExpressionBuilder.fileLastModifiedExpression();
        }
        if (strict) {
            throw new SimpleParserException("Unknown file language syntax: " + remainder, this.token.getIndex());
        }
        return null;
    }

    private Expression createSimpleExpressionMisc(String function) {
        String remainder = this.ifStartsWithReturnRemainder("random(", function);
        if (remainder != null) {
            String values = StringHelper.before((String)remainder, (String)")");
            if (values == null || ObjectHelper.isEmpty((Object)values)) {
                throw new SimpleParserException("Valid syntax: ${random(min,max)} or ${random(max)} was: " + function, this.token.getIndex());
            }
            if (values.contains(",")) {
                String[] tokens = values.split(",", 3);
                if (tokens.length > 2) {
                    throw new SimpleParserException("Valid syntax: ${random(min,max)} or ${random(max)} was: " + function, this.token.getIndex());
                }
                return SimpleExpressionBuilder.randomExpression(tokens[0].trim(), tokens[1].trim());
            }
            return SimpleExpressionBuilder.randomExpression("0", values.trim());
        }
        remainder = this.ifStartsWithReturnRemainder("skip(", function);
        if (remainder != null) {
            String values = StringHelper.before((String)remainder, (String)")");
            if (values == null || ObjectHelper.isEmpty((Object)values)) {
                throw new SimpleParserException("Valid syntax: ${skip(number)} was: " + function, this.token.getIndex());
            }
            String exp = "${body}";
            int num = Integer.parseInt(values.trim());
            return SimpleExpressionBuilder.skipExpression(exp, num);
        }
        remainder = this.ifStartsWithReturnRemainder("collate(", function);
        if (remainder != null) {
            String values = StringHelper.before((String)remainder, (String)")");
            if (values == null || ObjectHelper.isEmpty((Object)values)) {
                throw new SimpleParserException("Valid syntax: ${collate(group)} was: " + function, this.token.getIndex());
            }
            String exp = "${body}";
            int num = Integer.parseInt(values.trim());
            return SimpleExpressionBuilder.collateExpression(exp, num);
        }
        remainder = this.ifStartsWithReturnRemainder("messageHistory", function);
        if (remainder != null) {
            String values = StringHelper.between((String)remainder, (String)"(", (String)")");
            boolean detailed = values == null || ObjectHelper.isEmpty((Object)values) ? true : Boolean.parseBoolean(values);
            return SimpleExpressionBuilder.messageHistoryExpression(detailed);
        }
        if (ObjectHelper.equal((Object)function, (Object)"messageHistory")) {
            return SimpleExpressionBuilder.messageHistoryExpression(true);
        }
        return null;
    }

    private String ifStartsWithReturnRemainder(String prefix, String text) {
        String remainder;
        if (text.startsWith(prefix) && (remainder = text.substring(prefix.length())).length() > 0) {
            return remainder;
        }
        return null;
    }

    @Override
    public String createCode(String expression) throws SimpleParserException {
        String[] parts;
        String function = this.getText();
        String answer = this.createCodeDirectly(function);
        if (answer != null) {
            return answer;
        }
        answer = this.createCodeBody(function);
        if (answer != null) {
            return answer;
        }
        answer = this.createCodeHeader(function);
        if (answer != null) {
            return answer;
        }
        answer = this.createCodeExchangeProperty(function);
        if (answer != null) {
            return answer;
        }
        String remainder = this.ifStartsWithReturnRemainder("camelContext", function);
        if (remainder != null) {
            boolean invalid = OgnlHelper.isInvalidValidOgnlExpression((String)remainder);
            if (invalid) {
                throw new SimpleParserException("Valid syntax: ${camelContext.OGNL} was: " + function, this.token.getIndex());
            }
            return "context" + SimpleFunctionExpression.ognlCodeMethods(remainder, null);
        }
        remainder = this.ifStartsWithReturnRemainder("exceptionAs(", function);
        if (remainder != null) {
            String type = StringHelper.before((String)remainder, (String)")");
            remainder = StringHelper.after((String)remainder, (String)")");
            if (!(type = StringHelper.removeQuotes((String)type)).endsWith(".class")) {
                type = type + ".class";
            }
            type = type.replace('$', '.');
            type = type.trim();
            boolean invalid = OgnlHelper.isInvalidValidOgnlExpression((String)remainder);
            if (type.isEmpty() || invalid) {
                throw new SimpleParserException("Valid syntax: ${exceptionAs(type).OGNL} was: " + function, this.token.getIndex());
            }
            return "exceptionAs(exchange, " + type + ")" + SimpleFunctionExpression.ognlCodeMethods(remainder, type);
        }
        remainder = this.ifStartsWithReturnRemainder("exception", function);
        if (remainder != null) {
            boolean invalid = OgnlHelper.isInvalidValidOgnlExpression((String)remainder);
            if (invalid) {
                throw new SimpleParserException("Valid syntax: ${exceptionAs(type).OGNL} was: " + function, this.token.getIndex());
            }
            return "exception(exchange)" + SimpleFunctionExpression.ognlCodeMethods(remainder, null);
        }
        remainder = this.ifStartsWithReturnRemainder("sys.", function);
        if (remainder != null) {
            return "sys(\"" + remainder + "\")";
        }
        remainder = this.ifStartsWithReturnRemainder("sysenv.", function);
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("sysenv:", function);
        }
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("env.", function);
        }
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("env:", function);
        }
        if (remainder != null) {
            return "sysenv(\"" + remainder + "\")";
        }
        remainder = this.ifStartsWithReturnRemainder("exchange", function);
        if (remainder != null) {
            boolean invalid = OgnlHelper.isInvalidValidOgnlExpression((String)remainder);
            if (invalid) {
                throw new SimpleParserException("Valid syntax: ${exchange.OGNL} was: " + function, this.token.getIndex());
            }
            return "exchange" + SimpleFunctionExpression.ognlCodeMethods(remainder, null);
        }
        remainder = this.ifStartsWithReturnRemainder("file:", function);
        if (remainder != null) {
            return this.createCodeFileExpression(remainder);
        }
        remainder = this.ifStartsWithReturnRemainder("date:", function);
        if (remainder != null) {
            parts = remainder.split(":", 2);
            if (parts.length == 1) {
                return "date(exchange, \"" + parts[0] + "\")";
            }
            if (parts.length == 2) {
                return "date(exchange, \"" + parts[0] + "\", null, \"" + parts[1] + "\")";
            }
        }
        if ((remainder = this.ifStartsWithReturnRemainder("date-with-timezone:", function)) != null) {
            parts = remainder.split(":", 3);
            if (parts.length < 3) {
                throw new SimpleParserException("Valid syntax: ${date-with-timezone:command:timezone:pattern} was: " + function, this.token.getIndex());
            }
            return "date(exchange, \"" + parts[0] + "\", \"" + parts[1] + "\", \"" + parts[2] + "\")";
        }
        remainder = this.ifStartsWithReturnRemainder("bean:", function);
        if (remainder != null) {
            String ref = remainder;
            String method = null;
            Object scope = null;
            if (remainder.contains("?method=") || remainder.contains("?scope=")) {
                ref = StringHelper.before((String)remainder, (String)"?");
                String query = StringHelper.after((String)remainder, (String)"?");
                try {
                    Map map = URISupport.parseQuery((String)query);
                    method = (String)map.get("method");
                    scope = map.get("scope");
                }
                catch (URISyntaxException e) {
                    throw RuntimeCamelException.wrapRuntimeException((Throwable)e);
                }
            } else {
                int doubleColonIndex = remainder.indexOf("::");
                int beginOfParameterDeclaration = remainder.indexOf(40);
                if (!(doubleColonIndex <= 0 || remainder.contains("(") && doubleColonIndex >= beginOfParameterDeclaration)) {
                    ref = remainder.substring(0, doubleColonIndex);
                    method = remainder.substring(doubleColonIndex + 2);
                } else {
                    int idx = remainder.indexOf(46);
                    if (idx > 0) {
                        ref = remainder.substring(0, idx);
                        method = remainder.substring(idx + 1);
                    }
                }
            }
            ref = ref.trim();
            if (method != null && scope != null) {
                return "bean(exchange, bean, \"" + ref + "\", \"" + method.toString() + "\", \"" + scope.toString() + "\")";
            }
            if (method != null) {
                return "bean(exchange, bean, \"" + ref + "\", \"" + method.toString() + "\", null)";
            }
            return "bean(exchange, bean, \"" + ref + "\", null, null)";
        }
        remainder = this.ifStartsWithReturnRemainder("properties:", function);
        if (remainder != null) {
            parts = remainder.split(":", 2);
            if (parts.length > 2) {
                throw new SimpleParserException("Valid syntax: ${properties:key[:default]} was: " + function, this.token.getIndex());
            }
            String defaultValue = null;
            if (parts.length >= 2) {
                defaultValue = parts[1];
            }
            String key = parts[0];
            key = key.trim();
            if (defaultValue != null) {
                return "properties(exchange, \"" + key + "\", \"" + defaultValue.trim() + "\")";
            }
            return "properties(exchange, \"" + key + "\")";
        }
        remainder = this.ifStartsWithReturnRemainder("ref:", function);
        if (remainder != null) {
            return "ref(exchange, \"" + remainder + "\")";
        }
        remainder = this.ifStartsWithReturnRemainder("type:", function);
        if (remainder != null) {
            String field;
            int pos = remainder.lastIndexOf(46);
            String type = pos != -1 ? remainder.substring(0, pos) : remainder;
            String string = field = pos != -1 ? remainder.substring(pos + 1) : null;
            if (!type.endsWith(".class")) {
                type = type + ".class";
            }
            type = type.replace('$', '.');
            if (field != null) {
                return "type(exchange, " + type + ", \"" + field + "\")";
            }
            return "type(exchange, " + type + ")";
        }
        String misc = this.createCodeExpressionMisc(function);
        if (misc != null) {
            return misc;
        }
        throw new SimpleParserException("Unknown function: " + function, this.token.getIndex());
    }

    public String createCodeDirectly(String expression) throws SimpleParserException {
        if (ObjectHelper.isEqualToAny((Object)expression, (Object[])new Object[]{"body", "in.body"})) {
            return "body";
        }
        if (ObjectHelper.equal((Object)expression, (Object)"bodyOneLine")) {
            return "bodyOneLine(exchange)";
        }
        if (ObjectHelper.equal((Object)expression, (Object)"id")) {
            return "message.getMessageId()";
        }
        if (ObjectHelper.equal((Object)expression, (Object)"messageTimestamp")) {
            return "message.getMessageTimestamp()";
        }
        if (ObjectHelper.equal((Object)expression, (Object)"exchangeId")) {
            return "exchange.getExchangeId()";
        }
        if (ObjectHelper.equal((Object)expression, (Object)"exchange")) {
            return "exchange";
        }
        if (ObjectHelper.equal((Object)expression, (Object)"exception")) {
            return "exception(exchange)";
        }
        if (ObjectHelper.equal((Object)expression, (Object)"exception.message")) {
            return "exceptionMessage(exchange)";
        }
        if (ObjectHelper.equal((Object)expression, (Object)"exception.stacktrace")) {
            return "exceptionStacktrace(exchange)";
        }
        if (ObjectHelper.equal((Object)expression, (Object)"threadName")) {
            return "threadName()";
        }
        if (ObjectHelper.equal((Object)expression, (Object)"hostname")) {
            return "hostName()";
        }
        if (ObjectHelper.equal((Object)expression, (Object)"camelId")) {
            return "context.getName()";
        }
        if (ObjectHelper.equal((Object)expression, (Object)"routeId")) {
            return "routeId(exchange)";
        }
        if (ObjectHelper.equal((Object)expression, (Object)"stepId")) {
            return "stepId(exchange)";
        }
        if (ObjectHelper.equal((Object)expression, (Object)"null")) {
            return "null";
        }
        return null;
    }

    private String createCodeBody(String function) {
        String remainder = this.ifStartsWithReturnRemainder("bodyAsIndex(", function);
        if (remainder != null) {
            String typeAndIndex = StringHelper.before((String)remainder, (String)")");
            if (typeAndIndex == null) {
                throw new SimpleParserException("Valid syntax: ${bodyAsIndex(type, index).OGNL} was: " + function, this.token.getIndex());
            }
            String type = StringHelper.before((String)typeAndIndex, (String)",");
            String index = StringHelper.after((String)typeAndIndex, (String)",");
            remainder = StringHelper.after((String)remainder, (String)")");
            if (ObjectHelper.isEmpty((Object)type) || ObjectHelper.isEmpty((Object)index)) {
                throw new SimpleParserException("Valid syntax: ${bodyAsIndex(type, index).OGNL} was: " + function, this.token.getIndex());
            }
            type = StringHelper.removeQuotes((String)type);
            if (!(type = type.trim()).endsWith(".class")) {
                type = type + ".class";
            }
            type = type.replace('$', '.');
            index = StringHelper.removeQuotes((String)index);
            index = index.trim();
            if (ObjectHelper.isNotEmpty((Object)remainder)) {
                boolean invalid = OgnlHelper.isInvalidValidOgnlExpression((String)remainder);
                if (invalid) {
                    throw new SimpleParserException("Valid syntax: ${bodyAsIndex(type, index).OGNL} was: " + function, this.token.getIndex());
                }
                return "bodyAsIndex(message, " + type + ", \"" + index + "\")" + SimpleFunctionExpression.ognlCodeMethods(remainder, type);
            }
            return "bodyAsIndex(message, " + type + ", \"" + index + "\")";
        }
        remainder = this.ifStartsWithReturnRemainder("bodyAs(", function);
        if (remainder != null) {
            String type = StringHelper.before((String)remainder, (String)")");
            if (type == null) {
                throw new SimpleParserException("Valid syntax: ${bodyAs(type)} was: " + function, this.token.getIndex());
            }
            if (!(type = StringHelper.removeQuotes((String)type)).endsWith(".class")) {
                type = type + ".class";
            }
            type = type.replace('$', '.');
            type = type.trim();
            if (ObjectHelper.isNotEmpty((Object)(remainder = StringHelper.after((String)remainder, (String)")")))) {
                List<String> parts;
                boolean invalid = OgnlHelper.isInvalidValidOgnlExpression((String)remainder);
                if (invalid) {
                    throw new SimpleParserException("Valid syntax: ${bodyAs(type).OGNL} was: " + function, this.token.getIndex());
                }
                if (remainder.startsWith("[") && !(parts = SimpleFunctionExpression.splitOgnl(remainder)).isEmpty()) {
                    String func = "bodyAsIndex(" + type + ", \"" + parts.remove(0) + "\")";
                    String last = String.join((CharSequence)"", parts);
                    if (!last.isEmpty()) {
                        func = func + "." + last;
                    }
                    return this.createCodeBody(func);
                }
                return "bodyAs(message, " + type + ")" + SimpleFunctionExpression.ognlCodeMethods(remainder, type);
            }
            return "bodyAs(message, " + type + ")";
        }
        remainder = this.ifStartsWithReturnRemainder("mandatoryBodyAsIndex(", function);
        if (remainder != null) {
            String typeAndIndex = StringHelper.before((String)remainder, (String)")");
            if (typeAndIndex == null) {
                throw new SimpleParserException("Valid syntax: ${mandatoryBodyAsIndex(type, index).OGNL} was: " + function, this.token.getIndex());
            }
            String type = StringHelper.before((String)typeAndIndex, (String)",");
            String index = StringHelper.after((String)typeAndIndex, (String)",");
            remainder = StringHelper.after((String)remainder, (String)")");
            if (ObjectHelper.isEmpty((Object)type) || ObjectHelper.isEmpty((Object)index)) {
                throw new SimpleParserException("Valid syntax: ${mandatoryBodyAsIndex(type, index).OGNL} was: " + function, this.token.getIndex());
            }
            type = StringHelper.removeQuotes((String)type);
            if (!(type = type.trim()).endsWith(".class")) {
                type = type + ".class";
            }
            type = type.replace('$', '.');
            index = StringHelper.removeQuotes((String)index);
            index = index.trim();
            if (ObjectHelper.isNotEmpty((Object)remainder)) {
                boolean invalid = OgnlHelper.isInvalidValidOgnlExpression((String)remainder);
                if (invalid) {
                    throw new SimpleParserException("Valid syntax: ${mandatoryBodyAsIndex(type, index).OGNL} was: " + function, this.token.getIndex());
                }
                return "mandatoryBodyAsIndex(message, " + type + ", \"" + index + "\")" + SimpleFunctionExpression.ognlCodeMethods(remainder, type);
            }
            return "mandatoryBodyAsIndex(message, " + type + ", \"" + index + "\")";
        }
        remainder = this.ifStartsWithReturnRemainder("mandatoryBodyAs(", function);
        if (remainder != null) {
            String type = StringHelper.before((String)remainder, (String)")");
            if (type == null) {
                throw new SimpleParserException("Valid syntax: ${mandatoryBodyAs(type)} was: " + function, this.token.getIndex());
            }
            if (!(type = StringHelper.removeQuotes((String)type)).endsWith(".class")) {
                type = type + ".class";
            }
            type = type.replace('$', '.');
            type = type.trim();
            if (ObjectHelper.isNotEmpty((Object)(remainder = StringHelper.after((String)remainder, (String)")")))) {
                List<String> parts;
                boolean invalid = OgnlHelper.isInvalidValidOgnlExpression((String)remainder);
                if (invalid) {
                    throw new SimpleParserException("Valid syntax: ${mandatoryBodyAs(type).OGNL} was: " + function, this.token.getIndex());
                }
                if (remainder.startsWith("[") && !(parts = SimpleFunctionExpression.splitOgnl(remainder)).isEmpty()) {
                    String func = "mandatoryBodyAsIndex(" + type + ", \"" + parts.remove(0) + "\")";
                    String last = String.join((CharSequence)"", parts);
                    if (!last.isEmpty()) {
                        func = func + "." + last;
                    }
                    return this.createCodeBody(func);
                }
                return "mandatoryBodyAs(message, " + type + ")" + SimpleFunctionExpression.ognlCodeMethods(remainder, type);
            }
            return "mandatoryBodyAs(message, " + type + ")";
        }
        remainder = this.ifStartsWithReturnRemainder("body", function);
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("in.body", function);
        }
        if (remainder != null) {
            List<String> parts;
            boolean invalid;
            boolean ognlStart = remainder.startsWith(".") || remainder.startsWith("?") || remainder.startsWith("[");
            boolean bl = invalid = !ognlStart || OgnlHelper.isInvalidValidOgnlExpression((String)remainder);
            if (invalid) {
                throw new SimpleParserException("Valid syntax: ${body.OGNL} was: " + function, this.token.getIndex());
            }
            if (remainder.startsWith("[") && !(parts = SimpleFunctionExpression.splitOgnl(remainder)).isEmpty()) {
                String func = "bodyAsIndex(Object.class, \"" + parts.remove(0) + "\")";
                String last = String.join((CharSequence)"", parts);
                if (!last.isEmpty()) {
                    func = func + "." + last;
                }
                return this.createCodeBody(func);
            }
            return "body" + SimpleFunctionExpression.ognlCodeMethods(remainder, null);
        }
        return null;
    }

    private String createCodeHeader(String function) {
        String remainder = this.ifStartsWithReturnRemainder("headerAsIndex(", function);
        if (remainder != null) {
            String keyTypeAndIndex = StringHelper.before((String)remainder, (String)")");
            if (keyTypeAndIndex == null) {
                throw new SimpleParserException("Valid syntax: ${headerAsIndex(key, type, index)} was: " + function, this.token.getIndex());
            }
            String[] parts = keyTypeAndIndex.split(",");
            if (parts.length != 3) {
                throw new SimpleParserException("Valid syntax: ${headerAsIndex(key, type, index)} was: " + function, this.token.getIndex());
            }
            String key = parts[0];
            String type = parts[1];
            String index = parts[2];
            if (ObjectHelper.isEmpty((Object)key) || ObjectHelper.isEmpty((Object)type) || ObjectHelper.isEmpty((Object)index)) {
                throw new SimpleParserException("Valid syntax: ${headerAsIndex(key, type, index)} was: " + function, this.token.getIndex());
            }
            key = StringHelper.removeQuotes((String)key);
            key = key.trim();
            if (!(type = StringHelper.removeQuotes((String)type)).endsWith(".class")) {
                type = type + ".class";
            }
            type = type.replace('$', '.');
            type = type.trim();
            index = StringHelper.removeQuotes((String)index);
            index = index.trim();
            if (ObjectHelper.isNotEmpty((Object)(remainder = StringHelper.after((String)remainder, (String)")")))) {
                boolean invalid = OgnlHelper.isInvalidValidOgnlExpression((String)remainder);
                if (invalid) {
                    throw new SimpleParserException("Valid syntax: ${headerAsIndex(key, type, index).OGNL} was: " + function, this.token.getIndex());
                }
                return "headerAsIndex(message, " + type + ", \"" + key + "\", \"" + index + "\")" + SimpleFunctionExpression.ognlCodeMethods(remainder, type);
            }
            return "headerAsIndex(message, " + type + ", \"" + key + "\", \"" + index + "\")";
        }
        remainder = this.ifStartsWithReturnRemainder("headerAs(", function);
        if (remainder != null) {
            String keyAndType = StringHelper.before((String)remainder, (String)")");
            if (keyAndType == null) {
                throw new SimpleParserException("Valid syntax: ${headerAs(key, type)} was: " + function, this.token.getIndex());
            }
            String key = StringHelper.before((String)keyAndType, (String)",");
            String type = StringHelper.after((String)keyAndType, (String)",");
            remainder = StringHelper.after((String)remainder, (String)")");
            if (ObjectHelper.isEmpty((Object)key) || ObjectHelper.isEmpty((Object)type)) {
                throw new SimpleParserException("Valid syntax: ${headerAs(key, type)} was: " + function, this.token.getIndex());
            }
            key = StringHelper.removeQuotes((String)key);
            key = key.trim();
            if (!(type = StringHelper.removeQuotes((String)type)).endsWith(".class")) {
                type = type + ".class";
            }
            type = type.replace('$', '.');
            type = type.trim();
            return "headerAs(message, \"" + key + "\", " + type + ")" + SimpleFunctionExpression.ognlCodeMethods(remainder, type);
        }
        if ("in.headers".equals(function) || "headers".equals(function)) {
            return "message.getHeaders()";
        }
        remainder = this.ifStartsWithReturnRemainder("in.headers", function);
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("in.header", function);
        }
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("headers", function);
        }
        if (remainder == null) {
            remainder = this.ifStartsWithReturnRemainder("header", function);
        }
        if (remainder != null) {
            String s;
            int pos;
            if (remainder.startsWith(".") || remainder.startsWith(":") || remainder.startsWith("?")) {
                remainder = remainder.substring(1);
            }
            if (remainder.startsWith("[") && remainder.endsWith("]")) {
                remainder = remainder.substring(1, remainder.length() - 1);
            }
            String key = StringHelper.removeLeadingAndEndingQuotes((String)remainder);
            boolean invalid = OgnlHelper.isInvalidValidOgnlExpression((String)(key = key.trim()));
            if (invalid) {
                throw new SimpleParserException("Valid syntax: ${header.name[key]} was: " + function, this.token.getIndex());
            }
            boolean index = false;
            List<String> parts = SimpleFunctionExpression.splitOgnl(key);
            if (!parts.isEmpty() && (pos = (s = parts.get(0)).indexOf(91)) != -1) {
                index = true;
                String before = s.substring(0, pos);
                String after = s.substring(pos);
                parts.set(0, before);
                parts.add(1, after);
            }
            if (index) {
                String last;
                String func = "headerAsIndex(\"" + parts.get(0) + "\", Object.class, \"" + parts.get(1) + "\")";
                if (parts.size() > 2 && !(last = String.join((CharSequence)"", parts.subList(2, parts.size()))).isEmpty()) {
                    func = func + "." + last;
                }
                return this.createCodeHeader(func);
            }
            if (OgnlHelper.isValidOgnlExpression((String)key)) {
                throw new SimpleParserException("Valid syntax: ${headerAs(key, type).OGNL} was: " + function, this.token.getIndex());
            }
            return "header(message, \"" + key + "\")";
        }
        return null;
    }

    private String createCodeExchangeProperty(String function) {
        String remainder = this.ifStartsWithReturnRemainder("exchangePropertyAsIndex(", function);
        if (remainder != null) {
            String keyTypeAndIndex = StringHelper.before((String)remainder, (String)")");
            if (keyTypeAndIndex == null) {
                throw new SimpleParserException("Valid syntax: ${exchangePropertyAsIndex(key, type, index)} was: " + function, this.token.getIndex());
            }
            String[] parts = keyTypeAndIndex.split(",");
            if (parts.length != 3) {
                throw new SimpleParserException("Valid syntax: ${exchangePropertyAsIndex(key, type, index)} was: " + function, this.token.getIndex());
            }
            String key = parts[0];
            String type = parts[1];
            String index = parts[2];
            if (ObjectHelper.isEmpty((Object)key) || ObjectHelper.isEmpty((Object)type) || ObjectHelper.isEmpty((Object)index)) {
                throw new SimpleParserException("Valid syntax: ${exchangePropertyAsIndex(key, type, index)} was: " + function, this.token.getIndex());
            }
            key = StringHelper.removeQuotes((String)key);
            key = key.trim();
            if (!(type = StringHelper.removeQuotes((String)type)).endsWith(".class")) {
                type = type + ".class";
            }
            type = type.replace('$', '.');
            type = type.trim();
            index = StringHelper.removeQuotes((String)index);
            index = index.trim();
            if (ObjectHelper.isNotEmpty((Object)(remainder = StringHelper.after((String)remainder, (String)")")))) {
                boolean invalid = OgnlHelper.isInvalidValidOgnlExpression((String)remainder);
                if (invalid) {
                    throw new SimpleParserException("Valid syntax: ${exchangePropertyAsIndex(key, type, index).OGNL} was: " + function, this.token.getIndex());
                }
                return "exchangePropertyAsIndex(exchange, " + type + ", \"" + key + "\", \"" + index + "\")" + SimpleFunctionExpression.ognlCodeMethods(remainder, type);
            }
            return "exchangePropertyAsIndex(exchange, " + type + ", \"" + key + "\", \"" + index + "\")";
        }
        remainder = this.ifStartsWithReturnRemainder("exchangePropertyAs(", function);
        if (remainder != null) {
            String keyAndType = StringHelper.before((String)remainder, (String)")");
            if (keyAndType == null) {
                throw new SimpleParserException("Valid syntax: ${exchangePropertyAs(key, type)} was: " + function, this.token.getIndex());
            }
            String key = StringHelper.before((String)keyAndType, (String)",");
            String type = StringHelper.after((String)keyAndType, (String)",");
            remainder = StringHelper.after((String)remainder, (String)")");
            if (ObjectHelper.isEmpty((Object)key) || ObjectHelper.isEmpty((Object)type)) {
                throw new SimpleParserException("Valid syntax: ${exchangePropertyAs(key, type)} was: " + function, this.token.getIndex());
            }
            key = StringHelper.removeQuotes((String)key);
            key = key.trim();
            if (!(type = StringHelper.removeQuotes((String)type)).endsWith(".class")) {
                type = type + ".class";
            }
            type = type.replace('$', '.');
            type = type.trim();
            return "exchangePropertyAs(exchange, \"" + key + "\", " + type + ")" + SimpleFunctionExpression.ognlCodeMethods(remainder, type);
        }
        remainder = this.ifStartsWithReturnRemainder("exchangeProperty", function);
        if (remainder != null) {
            if (remainder.startsWith(".") || remainder.startsWith("?")) {
                remainder = remainder.substring(1);
            }
            if (remainder.startsWith("[") && remainder.endsWith("]")) {
                remainder = remainder.substring(1, remainder.length() - 1);
            }
            String key = StringHelper.removeLeadingAndEndingQuotes((String)remainder);
            boolean invalid = OgnlHelper.isInvalidValidOgnlExpression((String)(key = key.trim()));
            if (invalid) {
                throw new SimpleParserException("Valid syntax: ${exchangeProperty.name[key]} was: " + function, this.token.getIndex());
            }
            String index = null;
            if (key.endsWith("]") && (index = StringHelper.between((String)key, (String)"[", (String)"]")) != null) {
                key = StringHelper.before((String)key, (String)"[");
            }
            if (index != null) {
                index = StringHelper.removeLeadingAndEndingQuotes(index);
                return "exchangePropertyAsIndex(exchange, Object.class, \"" + key + "\", \"" + index + "\")";
            }
            if (OgnlHelper.isValidOgnlExpression((String)remainder)) {
                throw new SimpleParserException("Valid syntax: ${exchangePropertyAs(key, type)} was: " + function, this.token.getIndex());
            }
            return "exchangeProperty(exchange, \"" + key + "\")";
        }
        return null;
    }

    private String createCodeFileExpression(String remainder) {
        if (ObjectHelper.equal((Object)remainder, (Object)"name")) {
            return "fileName(message)";
        }
        if (ObjectHelper.equal((Object)remainder, (Object)"name.noext")) {
            return "fileNameNoExt(message)";
        }
        if (ObjectHelper.equal((Object)remainder, (Object)"name.noext.single")) {
            return "fileNameNoExtSingle(message)";
        }
        if (ObjectHelper.equal((Object)remainder, (Object)"name.ext") || ObjectHelper.equal((Object)remainder, (Object)"ext")) {
            return "fileNameExt(message)";
        }
        if (ObjectHelper.equal((Object)remainder, (Object)"name.ext.single")) {
            return "fileNameExtSingle(message)";
        }
        if (ObjectHelper.equal((Object)remainder, (Object)"onlyname")) {
            return "fileOnlyName(message)";
        }
        if (ObjectHelper.equal((Object)remainder, (Object)"onlyname.noext")) {
            return "fileOnlyNameNoExt(message)";
        }
        if (ObjectHelper.equal((Object)remainder, (Object)"onlyname.noext.single")) {
            return "fileOnlyNameNoExtSingle(message)";
        }
        if (ObjectHelper.equal((Object)remainder, (Object)"parent")) {
            return "fileParent(message)";
        }
        if (ObjectHelper.equal((Object)remainder, (Object)"path")) {
            return "filePath(message)";
        }
        if (ObjectHelper.equal((Object)remainder, (Object)"absolute")) {
            return "fileAbsolute(message)";
        }
        if (ObjectHelper.equal((Object)remainder, (Object)"absolute.path")) {
            return "fileAbsolutePath(message)";
        }
        if (ObjectHelper.equal((Object)remainder, (Object)"length") || ObjectHelper.equal((Object)remainder, (Object)"size")) {
            return "fileSize(message)";
        }
        if (ObjectHelper.equal((Object)remainder, (Object)"modified")) {
            return "fileModified(message)";
        }
        throw new SimpleParserException("Unknown file language syntax: " + remainder, this.token.getIndex());
    }

    private String createCodeExpressionMisc(String function) {
        String remainder = this.ifStartsWithReturnRemainder("random(", function);
        if (remainder != null) {
            String values = StringHelper.beforeLast((String)remainder, (String)")");
            if (values == null || ObjectHelper.isEmpty((Object)values)) {
                throw new SimpleParserException("Valid syntax: ${random(min,max)} or ${random(max)} was: " + function, this.token.getIndex());
            }
            if (values.contains(",")) {
                String before = StringHelper.before((String)remainder, (String)",");
                before = before.trim();
                String after = StringHelper.after((String)remainder, (String)",");
                if ((after = after.trim()).endsWith(")")) {
                    after = after.substring(0, after.length() - 1);
                }
                return "random(exchange, " + before + ", " + after + ")";
            }
            return "random(exchange, 0, " + values.trim() + ")";
        }
        remainder = this.ifStartsWithReturnRemainder("skip(", function);
        if (remainder != null) {
            String values = StringHelper.beforeLast((String)remainder, (String)")");
            if (values == null || ObjectHelper.isEmpty((Object)values)) {
                throw new SimpleParserException("Valid syntax: ${skip(number)} was: " + function, this.token.getIndex());
            }
            return "skip(exchange, " + values.trim() + ")";
        }
        remainder = this.ifStartsWithReturnRemainder("collate(", function);
        if (remainder != null) {
            String values = StringHelper.beforeLast((String)remainder, (String)")");
            if (values == null || ObjectHelper.isEmpty((Object)values)) {
                throw new SimpleParserException("Valid syntax: ${collate(group)} was: " + function, this.token.getIndex());
            }
            return "collate(exchange, " + values.trim() + ")";
        }
        remainder = this.ifStartsWithReturnRemainder("messageHistory", function);
        if (remainder != null) {
            String values = StringHelper.between((String)remainder, (String)"(", (String)")");
            boolean detailed = values == null || ObjectHelper.isEmpty((Object)values) ? true : Boolean.parseBoolean(values);
            return "messageHistory(exchange, " + (detailed ? "true" : "false") + ")";
        }
        if (ObjectHelper.equal((Object)function, (Object)"messageHistory")) {
            return "messageHistory(exchange, true)";
        }
        return null;
    }

    private static List<String> splitOgnl(String remainder) {
        List methods = OgnlHelper.splitOgnl((String)remainder);
        ArrayList<String> answer = new ArrayList<String>();
        for (String m : methods) {
            boolean index;
            if (m.startsWith(".")) {
                m = m.substring(1);
            }
            boolean bl = index = m.startsWith("[") && m.endsWith("]");
            if (index) {
                boolean lastIndex;
                String last = answer.isEmpty() ? null : (String)answer.get(answer.size() - 1);
                boolean bl2 = lastIndex = last != null && last.startsWith("[") && last.endsWith("]");
                if (lastIndex) {
                    String line = last + m;
                    answer.set(answer.size() - 1, line);
                    continue;
                }
                answer.add(m);
                continue;
            }
            answer.add(m);
        }
        return answer;
    }

    private static String ognlCodeMethods(String remainder, String type) {
        StringBuilder sb = new StringBuilder();
        if (remainder != null) {
            List<String> methods = SimpleFunctionExpression.splitOgnl(remainder);
            for (int i = 0; i < methods.size(); ++i) {
                String m = methods.get(i);
                if (m.startsWith("(")) {
                    sb.append(m);
                    continue;
                }
                String index = StringHelper.betweenOuterPair((String)m, (char)'[', (char)']');
                if (index != null) {
                    m = StringHelper.before((String)m, (String)"[");
                }
                if (m != null && m.equals("length") && type != null && type.contains("[]")) {
                    sb.append(".length");
                    continue;
                }
                if (m != null) {
                    m = OgnlHelper.methodAsDoubleQuotes((String)m);
                }
                if (m != null && !m.isEmpty()) {
                    sb.append(".");
                    char ch = m.charAt(m.length() - 1);
                    if (Character.isAlphabetic(ch)) {
                        if (!m.startsWith("get")) {
                            sb.append("get");
                            sb.append(Character.toUpperCase(m.charAt(0)));
                            sb.append(m.substring(1));
                        } else {
                            sb.append(m);
                        }
                        sb.append("()");
                    } else {
                        sb.append(m);
                    }
                }
                if (index == null) continue;
                sb.append(".get(");
                try {
                    long lon = Long.parseLong(index);
                    sb.append(lon);
                    if (lon > Integer.MAX_VALUE) {
                        sb.append("l");
                    }
                }
                catch (Exception e) {
                    index = StringHelper.removeLeadingAndEndingQuotes((String)index);
                    sb.append("\"");
                    sb.append(index);
                    sb.append("\"");
                }
                sb.append(")");
            }
        }
        if (sb.length() > 0) {
            return sb.toString();
        }
        return remainder;
    }
}

