/*
 * Decompiled with CFR 0.152.
 */
package com.worldturner.medeia.api;

import com.worldturner.medeia.api.InputPreference;
import com.worldturner.medeia.api.InputSource;
import com.worldturner.medeia.api.JsonSchemaVersion;
import com.worldturner.medeia.api.MetaSchemaInputSource$Companion$WhenMappings;
import java.io.InputStream;
import java.io.Reader;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0013\u001a\u00020\u0006H\u0016R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0015"}, d2={"Lcom/worldturner/medeia/api/MetaSchemaInputSource;", "Lcom/worldturner/medeia/api/InputSource;", "version", "Lcom/worldturner/medeia/api/JsonSchemaVersion;", "(Lcom/worldturner/medeia/api/JsonSchemaVersion;)V", "name", "", "getName", "()Ljava/lang/String;", "preference", "Lcom/worldturner/medeia/api/InputPreference;", "getPreference", "()Lcom/worldturner/medeia/api/InputPreference;", "stream", "Ljava/io/InputStream;", "getStream", "()Ljava/io/InputStream;", "getVersion", "()Lcom/worldturner/medeia/api/JsonSchemaVersion;", "toString", "Companion", "medeia-validator-core"})
public final class MetaSchemaInputSource
implements InputSource {
    @NotNull
    private final JsonSchemaVersion version;
    private static final String RESOURCE_SCHEMA_DRAFT04 = "/meta-schemas/schema-draft04.json";
    private static final String RESOURCE_SCHEMA_DRAFT06 = "/meta-schemas/schema-draft06.json";
    private static final String RESOURCE_SCHEMA_DRAFT07 = "/meta-schemas/schema-draft07.json";
    @NotNull
    private static final MetaSchemaInputSource DRAFT04;
    @NotNull
    private static final MetaSchemaInputSource DRAFT06;
    @NotNull
    private static final MetaSchemaInputSource DRAFT07;
    public static final Companion Companion;

    @Override
    @NotNull
    public InputPreference getPreference() {
        return InputPreference.STREAM;
    }

    @Override
    @NotNull
    public InputStream getStream() {
        InputStream inputStream = this.getClass().getResourceAsStream(MetaSchemaInputSource.Companion.toMetaSchemaResource(this.version));
        Intrinsics.checkExpressionValueIsNotNull((Object)inputStream, (String)"this::class.java.getReso\u2026n.toMetaSchemaResource())");
        return inputStream;
    }

    @Override
    @Nullable
    public String getName() {
        return StringsKt.substringAfterLast$default((String)MetaSchemaInputSource.Companion.toMetaSchemaResource(this.version), (char)'/', null, (int)2, null);
    }

    @NotNull
    public String toString() {
        return "MetaSchemaInputSource(version=" + (Object)((Object)this.version) + ')';
    }

    @NotNull
    public final JsonSchemaVersion getVersion() {
        return this.version;
    }

    private MetaSchemaInputSource(JsonSchemaVersion version) {
        this.version = version;
    }

    static {
        Companion = new Companion(null);
        DRAFT04 = new MetaSchemaInputSource(JsonSchemaVersion.DRAFT04);
        DRAFT06 = new MetaSchemaInputSource(JsonSchemaVersion.DRAFT06);
        DRAFT07 = new MetaSchemaInputSource(JsonSchemaVersion.DRAFT07);
    }

    @Override
    @NotNull
    public Reader getReader() {
        return InputSource.DefaultImpls.getReader(this);
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011J\f\u0010\u0012\u001a\u00020\f*\u00020\u0011H\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u0006R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/worldturner/medeia/api/MetaSchemaInputSource$Companion;", "", "()V", "DRAFT04", "Lcom/worldturner/medeia/api/MetaSchemaInputSource;", "getDRAFT04", "()Lcom/worldturner/medeia/api/MetaSchemaInputSource;", "DRAFT06", "getDRAFT06", "DRAFT07", "getDRAFT07", "RESOURCE_SCHEMA_DRAFT04", "", "RESOURCE_SCHEMA_DRAFT06", "RESOURCE_SCHEMA_DRAFT07", "forVersion", "version", "Lcom/worldturner/medeia/api/JsonSchemaVersion;", "toMetaSchemaResource", "medeia-validator-core"})
    public static final class Companion {
        private final String toMetaSchemaResource(@NotNull JsonSchemaVersion $receiver) {
            String string;
            switch (MetaSchemaInputSource$Companion$WhenMappings.$EnumSwitchMapping$0[$receiver.ordinal()]) {
                case 1: {
                    string = MetaSchemaInputSource.RESOURCE_SCHEMA_DRAFT04;
                    break;
                }
                case 2: {
                    string = MetaSchemaInputSource.RESOURCE_SCHEMA_DRAFT06;
                    break;
                }
                case 3: {
                    string = MetaSchemaInputSource.RESOURCE_SCHEMA_DRAFT07;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return string;
        }

        @NotNull
        public final MetaSchemaInputSource getDRAFT04() {
            return DRAFT04;
        }

        @NotNull
        public final MetaSchemaInputSource getDRAFT06() {
            return DRAFT06;
        }

        @NotNull
        public final MetaSchemaInputSource getDRAFT07() {
            return DRAFT07;
        }

        @NotNull
        public final MetaSchemaInputSource forVersion(@NotNull JsonSchemaVersion version) {
            MetaSchemaInputSource metaSchemaInputSource;
            Intrinsics.checkParameterIsNotNull((Object)((Object)version), (String)"version");
            switch (MetaSchemaInputSource$Companion$WhenMappings.$EnumSwitchMapping$1[version.ordinal()]) {
                case 1: {
                    metaSchemaInputSource = this.getDRAFT04();
                    break;
                }
                case 2: {
                    metaSchemaInputSource = this.getDRAFT06();
                    break;
                }
                case 3: {
                    metaSchemaInputSource = this.getDRAFT07();
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            return metaSchemaInputSource;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

