/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor.aggregate;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.CamelContext;
import org.apache.camel.CamelContextAware;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePropertyKey;
import org.apache.camel.ExtendedExchange;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.support.service.ServiceSupport;

public final class ShareUnitOfWorkAggregationStrategy
extends ServiceSupport
implements AggregationStrategy,
CamelContextAware {
    private final AggregationStrategy strategy;
    private CamelContext camelContext;

    public ShareUnitOfWorkAggregationStrategy(AggregationStrategy strategy) {
        this.strategy = strategy;
    }

    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
        CamelContextAware.trySetCamelContext((Object)this.strategy, (CamelContext)camelContext);
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    public AggregationStrategy getDelegate() {
        return this.strategy;
    }

    public boolean canPreComplete() {
        return this.strategy.canPreComplete();
    }

    public boolean preComplete(Exchange oldExchange, Exchange newExchange) {
        return this.strategy.preComplete(oldExchange, newExchange);
    }

    public void onCompletion(Exchange exchange) {
        this.strategy.onCompletion(exchange);
    }

    public void timeout(Exchange exchange, int index, int total, long timeout) {
        this.strategy.timeout(exchange, index, total, timeout);
    }

    public void onOptimisticLockFailure(Exchange oldExchange, Exchange newExchange) {
        this.strategy.onOptimisticLockFailure(oldExchange, newExchange);
    }

    public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
        Exchange answer = this.strategy.aggregate(oldExchange, newExchange);
        this.propagateFailure(answer, newExchange);
        return answer;
    }

    public Exchange aggregate(Exchange oldExchange, Exchange newExchange, Exchange inputExchange) {
        Exchange answer = this.strategy.aggregate(oldExchange, newExchange, inputExchange);
        this.propagateFailure(answer, newExchange);
        return answer;
    }

    protected void propagateFailure(Exchange answer, Exchange newExchange) {
        ExtendedExchange nee = (ExtendedExchange)newExchange;
        if (nee.isFailed() || nee.isRollbackOnly() || nee.isRollbackOnlyLast() || nee.isErrorHandlerHandledSet() && nee.isErrorHandlerHandled()) {
            if (newExchange.getException() != null) {
                answer.setException((Throwable)newExchange.getException());
            }
            if (newExchange.getProperty(ExchangePropertyKey.EXCEPTION_CAUGHT) != null) {
                answer.setProperty(ExchangePropertyKey.EXCEPTION_CAUGHT, newExchange.getProperty(ExchangePropertyKey.EXCEPTION_CAUGHT));
            }
            if (newExchange.getProperty(ExchangePropertyKey.FAILURE_ENDPOINT) != null) {
                answer.setProperty(ExchangePropertyKey.FAILURE_ENDPOINT, newExchange.getProperty(ExchangePropertyKey.FAILURE_ENDPOINT));
            }
            if (newExchange.getProperty(ExchangePropertyKey.FAILURE_ROUTE_ID) != null) {
                answer.setProperty(ExchangePropertyKey.FAILURE_ROUTE_ID, newExchange.getProperty(ExchangePropertyKey.FAILURE_ROUTE_ID));
            }
            if (((ExtendedExchange)newExchange.adapt(ExtendedExchange.class)).getErrorHandlerHandled() != null) {
                ((ExtendedExchange)answer.adapt(ExtendedExchange.class)).setErrorHandlerHandled(((ExtendedExchange)newExchange.adapt(ExtendedExchange.class)).getErrorHandlerHandled());
            }
            if (newExchange.getProperty(ExchangePropertyKey.FAILURE_HANDLED) != null) {
                answer.setProperty(ExchangePropertyKey.FAILURE_HANDLED, newExchange.getProperty(ExchangePropertyKey.FAILURE_HANDLED));
            }
        }
    }

    public String toString() {
        return "ShareUnitOfWorkAggregationStrategy";
    }

    protected void doBuild() throws Exception {
        ServiceHelper.buildService((Object)this.strategy);
    }

    protected void doInit() throws Exception {
        ServiceHelper.initService((Object)this.strategy);
    }

    protected void doStart() throws Exception {
        ServiceHelper.startService((Object)this.strategy);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopAndShutdownServices((Object[])new Object[]{this.strategy});
    }
}

