/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.MetadataRequestData;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.ByteBufferAccessor;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AbstractResponse;
import org.apache.kafka.common.requests.MetadataResponse;

public class MetadataRequest
extends AbstractRequest {
    private final MetadataRequestData data;

    public MetadataRequest(MetadataRequestData data, short version) {
        super(ApiKeys.METADATA, version);
        this.data = data;
    }

    @Override
    public MetadataRequestData data() {
        return this.data;
    }

    @Override
    public AbstractResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        Errors error = Errors.forException(e);
        MetadataResponseData responseData = new MetadataResponseData();
        if (this.topics() != null) {
            for (String topic : this.topics()) {
                responseData.topics().add(new MetadataResponseData.MetadataResponseTopic().setName(topic).setErrorCode(error.code()).setIsInternal(false).setPartitions(Collections.emptyList()));
            }
        }
        responseData.setThrottleTimeMs(throttleTimeMs);
        return new MetadataResponse(responseData, true);
    }

    public boolean isAllTopics() {
        return this.data.topics() == null || this.data.topics().isEmpty() && this.version() == 0;
    }

    public List<String> topics() {
        if (this.isAllTopics()) {
            return null;
        }
        return this.data.topics().stream().map(MetadataRequestData.MetadataRequestTopic::name).collect(Collectors.toList());
    }

    public boolean allowAutoTopicCreation() {
        return this.data.allowAutoTopicCreation();
    }

    public static MetadataRequest parse(ByteBuffer buffer, short version) {
        return new MetadataRequest(new MetadataRequestData(new ByteBufferAccessor(buffer), version), version);
    }

    public static List<MetadataRequestData.MetadataRequestTopic> convertToMetadataRequestTopic(Collection<String> topics) {
        return topics.stream().map(topic -> new MetadataRequestData.MetadataRequestTopic().setName((String)topic)).collect(Collectors.toList());
    }

    public static class Builder
    extends AbstractRequest.Builder<MetadataRequest> {
        private static final MetadataRequestData ALL_TOPICS_REQUEST_DATA = new MetadataRequestData().setTopics(null).setAllowAutoTopicCreation(true);
        private final MetadataRequestData data;

        public Builder(MetadataRequestData data) {
            super(ApiKeys.METADATA);
            this.data = data;
        }

        public Builder(List<String> topics, boolean allowAutoTopicCreation, short allowedVersion) {
            this(topics, allowAutoTopicCreation, allowedVersion, allowedVersion);
        }

        public Builder(List<String> topics, boolean allowAutoTopicCreation, short minVersion, short maxVersion) {
            super(ApiKeys.METADATA, minVersion, maxVersion);
            MetadataRequestData data = new MetadataRequestData();
            if (topics == null) {
                data.setTopics(null);
            } else {
                topics.forEach(topic -> data.topics().add(new MetadataRequestData.MetadataRequestTopic().setName((String)topic)));
            }
            data.setAllowAutoTopicCreation(allowAutoTopicCreation);
            this.data = data;
        }

        public Builder(List<String> topics, boolean allowAutoTopicCreation) {
            this(topics, allowAutoTopicCreation, ApiKeys.METADATA.oldestVersion(), ApiKeys.METADATA.latestVersion());
        }

        public static Builder allTopics() {
            return new Builder(ALL_TOPICS_REQUEST_DATA);
        }

        public boolean emptyTopicList() {
            return this.data.topics().isEmpty();
        }

        public boolean isAllTopics() {
            return this.data.topics() == null;
        }

        public List<String> topics() {
            return this.data.topics().stream().map(MetadataRequestData.MetadataRequestTopic::name).collect(Collectors.toList());
        }

        @Override
        public MetadataRequest build(short version) {
            if (version < 1) {
                throw new UnsupportedVersionException("MetadataRequest versions older than 1 are not supported.");
            }
            if (!this.data.allowAutoTopicCreation() && version < 4) {
                throw new UnsupportedVersionException("MetadataRequest versions older than 4 don't support the allowAutoTopicCreation field");
            }
            return new MetadataRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

