/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.weather;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Scanner;
import org.apache.camel.component.weather.WeatherApi;
import org.apache.camel.component.weather.WeatherComponent;
import org.apache.camel.component.weather.WeatherLanguage;
import org.apache.camel.component.weather.WeatherMode;
import org.apache.camel.component.weather.WeatherQuery;
import org.apache.camel.component.weather.WeatherUnits;
import org.apache.camel.component.weather.geolocation.FreeGeoIpGeoLocationProvider;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriParam;
import org.apache.camel.spi.UriParams;
import org.apache.camel.spi.UriPath;
import org.apache.camel.util.ObjectHelper;

@UriParams
public class WeatherConfiguration {
    private final WeatherComponent component;
    private final WeatherQuery weatherQuery;
    @UriPath(description="The name value is not used.")
    @Metadata(required=true)
    private String name;
    @UriParam
    @Metadata(required=true)
    private String appid;
    @UriParam
    private WeatherApi weatherApi;
    @UriParam(label="filter")
    private String location = "";
    @UriParam(label="filter")
    private String lat;
    @UriParam(label="filter")
    private String lon;
    @UriParam(label="filter")
    private String rightLon;
    @UriParam(label="filter")
    private String topLat;
    @UriParam(label="filter")
    private Integer zoom;
    @UriParam
    private String period = "";
    @UriParam(defaultValue="JSON")
    private WeatherMode mode = WeatherMode.JSON;
    @UriParam
    private WeatherUnits units;
    @UriParam(defaultValue="en")
    private WeatherLanguage language = WeatherLanguage.en;
    @UriParam
    private String headerName;
    @UriParam(label="filter")
    private String zip;
    @UriParam(label="filter", javaType="java.lang.String")
    private List<String> ids;
    @UriParam(label="filter")
    private Integer cnt;
    @UriParam(label="security")
    @Metadata(required=true)
    private String geolocationAccessKey;
    @UriParam(label="security")
    @Metadata(required=true)
    private String geolocationRequestHostIP;

    public WeatherConfiguration(WeatherComponent component) {
        this.component = (WeatherComponent)((Object)ObjectHelper.notNull((Object)((Object)component), (String)"component"));
        this.weatherQuery = new WeatherQuery(this);
        FreeGeoIpGeoLocationProvider geoLocationProvider = new FreeGeoIpGeoLocationProvider(component, this.geolocationAccessKey);
        this.weatherQuery.setGeoLocationProvider(geoLocationProvider);
    }

    public String getPeriod() {
        return this.period;
    }

    public void setPeriod(String period) {
        ObjectHelper.notNull((Object)period, (String)"period");
        int result = 0;
        try {
            result = new Scanner(period).useDelimiter("\\D+").nextInt();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (result != 0) {
            this.period = "" + result;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public WeatherMode getMode() {
        return this.mode;
    }

    public void setMode(WeatherMode mode) {
        this.mode = (WeatherMode)((Object)ObjectHelper.notNull((Object)((Object)mode), (String)"mode"));
    }

    public WeatherUnits getUnits() {
        return this.units;
    }

    public void setUnits(WeatherUnits units) {
        this.units = (WeatherUnits)((Object)ObjectHelper.notNull((Object)((Object)units), (String)"units"));
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public String getHeaderName() {
        return this.headerName;
    }

    public void setHeaderName(String headerName) {
        this.headerName = headerName;
    }

    public String getLat() {
        return this.lat;
    }

    public void setLat(String lat) {
        this.lat = lat;
    }

    public String getLon() {
        return this.lon;
    }

    public void setLon(String lon) {
        this.lon = lon;
    }

    public void setAppid(String appid) {
        this.appid = appid;
    }

    public String getAppid() {
        return this.appid;
    }

    String getQuery() throws Exception {
        return this.weatherQuery.getQuery();
    }

    String getQuery(String location) throws Exception {
        return this.weatherQuery.getQuery(location);
    }

    public WeatherLanguage getLanguage() {
        return this.language;
    }

    public void setLanguage(WeatherLanguage language) {
        this.language = language;
    }

    public String getRightLon() {
        return this.rightLon;
    }

    public void setRightLon(String rightLon) {
        this.rightLon = rightLon;
    }

    public String getTopLat() {
        return this.topLat;
    }

    public void setTopLat(String topLat) {
        this.topLat = topLat;
    }

    public Integer getZoom() {
        return this.zoom;
    }

    public void setZoom(Integer zoom) {
        this.zoom = zoom;
    }

    public String getZip() {
        return this.zip;
    }

    public void setZip(String zip) {
        this.zip = zip;
    }

    public List<String> getIds() {
        return this.ids;
    }

    public void setIds(String id) {
        if (this.ids == null) {
            this.ids = new ArrayList<String>();
        }
        Iterator it = org.apache.camel.support.ObjectHelper.createIterator((Object)id);
        while (it.hasNext()) {
            String myId = (String)it.next();
            this.ids.add(myId);
        }
    }

    public void setIds(List<String> ids) {
        this.ids = ids;
    }

    public Integer getCnt() {
        return this.cnt;
    }

    public void setCnt(Integer cnt) {
        this.cnt = cnt;
    }

    public WeatherApi getWeatherApi() {
        return this.weatherApi;
    }

    public void setWeatherApi(WeatherApi weatherApi) {
        this.weatherApi = weatherApi;
    }

    public String getGeolocationAccessKey() {
        return this.geolocationAccessKey;
    }

    public void setGeolocationAccessKey(String geolocationAccessKey) {
        this.geolocationAccessKey = geolocationAccessKey;
    }

    public String getGeolocationRequestHostIP() {
        return this.geolocationRequestHostIP;
    }

    public void setGeolocationRequestHostIP(String geolocationRequestHostIP) {
        this.geolocationRequestHostIP = geolocationRequestHostIP;
    }
}

