/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.weather;

import java.io.Closeable;
import java.util.Map;
import org.apache.camel.Endpoint;
import org.apache.camel.component.weather.WeatherConfiguration;
import org.apache.camel.component.weather.WeatherEndpoint;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.annotations.Component;
import org.apache.camel.support.DefaultComponent;
import org.apache.camel.util.IOHelper;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

@Component(value="weather")
public class WeatherComponent
extends DefaultComponent {
    @Metadata(label="advanced")
    private CloseableHttpClient httpClient;
    private String geolocationAccessKey;
    private String geolocationRequestHostIP;

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        WeatherConfiguration configuration = new WeatherConfiguration(this);
        configuration.setGeolocationAccessKey(this.geolocationAccessKey);
        configuration.setGeolocationRequestHostIP(this.geolocationRequestHostIP);
        WeatherEndpoint endpoint = new WeatherEndpoint(uri, this, configuration);
        this.setProperties((Endpoint)endpoint, parameters);
        if (this.httpClient == null) {
            this.httpClient = HttpClients.createDefault();
        }
        return endpoint;
    }

    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public String getGeolocationAccessKey() {
        return this.geolocationAccessKey;
    }

    public void setGeolocationAccessKey(String geolocationAccessKey) {
        this.geolocationAccessKey = geolocationAccessKey;
    }

    public String getGeolocationRequestHostIP() {
        return this.geolocationRequestHostIP;
    }

    public void setGeolocationRequestHostIP(String geolocationRequestHostIP) {
        this.geolocationRequestHostIP = geolocationRequestHostIP;
    }

    protected void doShutdown() throws Exception {
        super.doShutdown();
        if (this.httpClient != null) {
            IOHelper.close((Closeable)this.httpClient);
            this.httpClient = null;
        }
    }
}

