/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx.websocket;

import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.http.WebSocket;
import io.vertx.core.http.WebSocketConnectOptions;
import io.vertx.core.net.TCPSSLOptions;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.camel.Category;
import org.apache.camel.Component;
import org.apache.camel.Consumer;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.vertx.websocket.VertxWebsocketComponent;
import org.apache.camel.component.vertx.websocket.VertxWebsocketConfiguration;
import org.apache.camel.component.vertx.websocket.VertxWebsocketConsumer;
import org.apache.camel.component.vertx.websocket.VertxWebsocketHelper;
import org.apache.camel.component.vertx.websocket.VertxWebsocketHost;
import org.apache.camel.component.vertx.websocket.VertxWebsocketHostKey;
import org.apache.camel.component.vertx.websocket.VertxWebsocketProducer;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriParam;
import org.apache.camel.support.DefaultEndpoint;
import org.apache.camel.support.jsse.SSLContextParameters;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UriEndpoint(firstVersion="3.5.0", scheme="vertx-websocket", title="Vert.x WebSocket", syntax="vertx-websocket:host:port/path", category={Category.WEBSOCKET})
public class VertxWebsocketEndpoint
extends DefaultEndpoint {
    private static final Logger LOG = LoggerFactory.getLogger(VertxWebsocketEndpoint.class);
    @UriParam
    private VertxWebsocketConfiguration configuration;
    private WebSocket webSocket;

    public VertxWebsocketEndpoint(String uri, VertxWebsocketComponent component, VertxWebsocketConfiguration configuration) {
        super(uri, (Component)component);
        this.configuration = configuration;
    }

    public VertxWebsocketComponent getComponent() {
        return (VertxWebsocketComponent)super.getComponent();
    }

    public Producer createProducer() throws Exception {
        return new VertxWebsocketProducer(this);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        VertxWebsocketConsumer consumer = new VertxWebsocketConsumer(this, processor);
        this.configureConsumer((Consumer)consumer);
        return consumer;
    }

    protected void doStop() throws Exception {
        if (this.webSocket != null && !this.webSocket.isClosed()) {
            this.webSocket.close();
            this.webSocket = null;
        }
        super.doStop();
    }

    public VertxWebsocketConfiguration getConfiguration() {
        return this.configuration;
    }

    protected Vertx getVertx() {
        return this.getComponent().getVertx();
    }

    protected WebSocket getWebSocket(Exchange exchange) throws InterruptedException, ExecutionException, TimeoutException {
        if (this.webSocket == null || this.webSocket.isClosed()) {
            SSLContextParameters sslContextParameters;
            HttpClientOptions options = this.configuration.getClientOptions();
            if (options == null) {
                options = new HttpClientOptions();
            }
            if ((sslContextParameters = this.configuration.getSslContextParameters()) != null) {
                VertxWebsocketHelper.setupSSLOptions(sslContextParameters, (TCPSSLOptions)options);
            }
            HttpClient client = this.getVertx().createHttpClient(options);
            WebSocketConnectOptions connectOptions = new WebSocketConnectOptions();
            connectOptions.setHost(this.configuration.getHost());
            connectOptions.setPort(this.configuration.getPort());
            connectOptions.setURI(this.configuration.getPath());
            connectOptions.setSsl(Boolean.valueOf(options.isSsl()));
            String subProtocols = this.configuration.getClientSubProtocols();
            if (ObjectHelper.isNotEmpty((Object)subProtocols)) {
                connectOptions.setSubProtocols(Arrays.asList(subProtocols.split(",")));
            }
            CompletableFuture future = new CompletableFuture();
            client.webSocket(connectOptions, result -> {
                if (!result.failed()) {
                    LOG.info("Connected to WebSocket on {}:{}", (Object)this.configuration.getHost(), (Object)this.configuration.getPort());
                    future.complete(result.result());
                } else {
                    this.webSocket = null;
                    future.completeExceptionally(result.cause());
                }
            });
            this.webSocket = (WebSocket)future.get(options.getConnectTimeout(), TimeUnit.MILLISECONDS);
            this.webSocket.exceptionHandler(event -> exchange.setException(event.getCause()));
        }
        return this.webSocket;
    }

    protected Map<VertxWebsocketHostKey, VertxWebsocketHost> getVertxHostRegistry() {
        return this.getComponent().getVerxHostRegistry();
    }

    protected ServerWebSocket findPeerForConnectionKey(String connectionKey) {
        Map<VertxWebsocketHostKey, VertxWebsocketHost> registry = this.getVertxHostRegistry();
        for (VertxWebsocketHost host : registry.values()) {
            Map<String, ServerWebSocket> hostPeers = host.getConnectedPeers();
            if (!hostPeers.containsKey(connectionKey) || host.getPort() != this.getConfiguration().getPort()) continue;
            return hostPeers.get(connectionKey);
        }
        return null;
    }

    protected Map<String, ServerWebSocket> findPeersForHostPort() {
        Map<VertxWebsocketHostKey, VertxWebsocketHost> registry = this.getVertxHostRegistry();
        for (VertxWebsocketHost host : registry.values()) {
            if (host.getPort() != this.getConfiguration().getPort()) continue;
            return host.getConnectedPeers();
        }
        return null;
    }

    protected boolean isManagedPort() {
        return this.getVertxHostRegistry().values().stream().filter(host -> host.getPort() == this.getConfiguration().getPort()).findFirst().isPresent();
    }
}

