/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.vertx.http;

import io.netty.buffer.ByteBuf;
import io.vertx.core.buffer.Buffer;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.camel.Converter;
import org.apache.camel.Exchange;
import org.apache.camel.component.vertx.http.VertxHttpHelper;
import org.apache.camel.util.IOHelper;
import org.apache.camel.util.ObjectHelper;

@Converter(generateLoader=true)
public final class VertxBufferConverter {
    private VertxBufferConverter() {
    }

    @Converter
    public static Buffer toBuffer(String string, Exchange exchange) {
        String charset = VertxHttpHelper.getCharsetFromExchange(exchange);
        if (ObjectHelper.isNotEmpty((Object)charset)) {
            Buffer.buffer((String)string, (String)charset);
        }
        return Buffer.buffer((String)string);
    }

    @Converter
    public static Buffer toBuffer(byte[] bytes) {
        return Buffer.buffer((byte[])bytes);
    }

    @Converter
    public static Buffer toBuffer(ByteBuf byteBuf) {
        return Buffer.buffer((ByteBuf)byteBuf);
    }

    @Converter
    public static Buffer toBuffer(InputStream inputStream) throws IOException {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            IOHelper.copy((InputStream)IOHelper.buffered((InputStream)inputStream), (OutputStream)bos);
            Buffer buffer = Buffer.buffer((byte[])bos.toByteArray());
            return buffer;
        }
        finally {
            IOHelper.close((Closeable)inputStream);
        }
    }

    @Converter
    public static String toString(Buffer buffer, Exchange exchange) {
        String charset = VertxHttpHelper.getCharsetFromExchange(exchange);
        if (ObjectHelper.isNotEmpty((Object)charset)) {
            buffer.toString(charset);
        }
        return buffer.toString();
    }

    @Converter
    public static byte[] toBytes(Buffer buffer) {
        return buffer.getBytes();
    }
}

