/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.spi;

import io.vertx.core.VertxOptions;
import io.vertx.core.impl.VertxBuilder;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.VertxServiceProvider;
import io.vertx.core.spi.tracing.VertxTracer;
import io.vertx.core.tracing.TracingOptions;

public interface VertxTracerFactory
extends VertxServiceProvider {
    public static final VertxTracerFactory NOOP = options -> VertxTracer.NOOP;

    @Override
    default public void init(VertxBuilder builder) {
        if (builder.tracer() == null) {
            VertxOptions options = builder.options();
            TracingOptions tracingOptions = options.getTracingOptions();
            if (tracingOptions == null) {
                tracingOptions = this.newOptions();
                builder.options().setTracingOptions(tracingOptions);
            }
            builder.tracer(this.tracer(tracingOptions));
        }
    }

    public VertxTracer tracer(TracingOptions var1);

    default public TracingOptions newOptions() {
        return new TracingOptions();
    }

    default public TracingOptions newOptions(JsonObject jsonObject) {
        return new TracingOptions(jsonObject);
    }
}

