/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.http.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.http.impl.ClientHttpEndpointBase;
import io.vertx.core.http.impl.HttpClientConnection;
import io.vertx.core.http.impl.HttpConnectionProvider;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.net.impl.clientconnection.Lease;
import io.vertx.core.net.impl.clientconnection.Pool;
import io.vertx.core.spi.metrics.ClientMetrics;

class ClientHttpStreamEndpoint
extends ClientHttpEndpointBase<Lease<HttpClientConnection>> {
    private final Pool<HttpClientConnection> pool;

    public ClientHttpStreamEndpoint(ClientMetrics metrics, Object metric, int queueMaxSize, long maxSize, String host, int port, ContextInternal ctx, HttpConnectionProvider connector, Runnable dispose) {
        super(metrics, port, host, metric, dispose);
        this.pool = new Pool<HttpClientConnection>(ctx, connector, queueMaxSize, connector.weight(), maxSize, conn -> {
            if (!this.incRefCount()) {
                conn.close();
            }
        }, v -> this.decRefCount(), false);
    }

    void checkExpired() {
        this.pool.closeIdle();
    }

    @Override
    public void requestConnection2(ContextInternal ctx, Handler<AsyncResult<Lease<HttpClientConnection>>> handler) {
        this.pool.getConnection(handler);
    }
}

