/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.undertow;

public final class UndertowConstants {
    public static final String CONNECTION_KEY = "websocket.connectionKey";
    public static final String CONNECTION_KEY_LIST = "websocket.connectionKey.list";
    public static final String SEND_TO_ALL = "websocket.sendToAll";
    public static final String EVENT_TYPE = "websocket.eventType";
    public static final String EVENT_TYPE_ENUM = "websocket.eventTypeEnum";
    public static final String CHANNEL = "websocket.channel";
    public static final String EXCHANGE = "websocket.exchange";
    public static final String WS_PROTOCOL = "ws";
    public static final String WSS_PROTOCOL = "wss";

    private UndertowConstants() {
    }

    public static enum EventType {
        ONOPEN(1),
        ONCLOSE(0),
        ONERROR(-1);

        private final int code;

        private EventType(int code) {
            this.code = code;
        }

        public int getCode() {
            return this.code;
        }

        public static EventType ofCode(int code) {
            switch (code) {
                case 1: {
                    return ONOPEN;
                }
                case 0: {
                    return ONCLOSE;
                }
                case -1: {
                    return ONERROR;
                }
            }
            throw new IllegalArgumentException("Cannot find an " + EventType.class.getName() + " for code " + code);
        }
    }
}

