/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.support.builder;

import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

class RecordableInputStream
extends FilterInputStream {
    private TrimmableByteArrayOutputStream buf = new TrimmableByteArrayOutputStream();
    private String charset;
    private boolean recording;

    RecordableInputStream(InputStream in, String charset) {
        super(in);
        this.charset = charset;
        this.recording = true;
    }

    @Override
    public int read() throws IOException {
        int c = super.read();
        if (c > 0 && this.recording) {
            this.buf.write(c);
        }
        return c;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int n = super.read(b, off, len);
        if (n > 0 && this.recording) {
            this.buf.write(b, off, n);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getText(int pos) {
        String t = null;
        this.recording = false;
        try {
            t = this.charset == null ? new String(this.buf.getByteArray(), 0, pos) : new String(this.buf.getByteArray(), 0, pos, this.charset);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        finally {
            this.buf.trim(pos, 0);
        }
        return t;
    }

    public byte[] getBytes(int pos) {
        this.recording = false;
        byte[] b = this.buf.toByteArray(pos);
        this.buf.trim(pos, 0);
        return b;
    }

    public void record() {
        this.recording = true;
    }

    int size() {
        return this.buf.size();
    }

    private static class TrimmableByteArrayOutputStream
    extends ByteArrayOutputStream {
        private TrimmableByteArrayOutputStream() {
        }

        public void trim(int head, int tail) {
            System.arraycopy(this.buf, head, this.buf, 0, this.count - head - tail);
            this.count -= head + tail;
        }

        public byte[] toByteArray(int len) {
            byte[] b = new byte[len];
            System.arraycopy(this.buf, 0, b, 0, len);
            return b;
        }

        byte[] getByteArray() {
            return this.buf;
        }
    }
}

