/*
 * Decompiled with CFR 0.152.
 */
package twitter4j;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import twitter4j.AccountSettings;
import twitter4j.Category;
import twitter4j.DirectMessage;
import twitter4j.DirectMessageList;
import twitter4j.Friendship;
import twitter4j.GeoLocation;
import twitter4j.GeoQuery;
import twitter4j.HashtagEntity;
import twitter4j.HttpParameter;
import twitter4j.HttpResponse;
import twitter4j.IDs;
import twitter4j.JSONException;
import twitter4j.JSONObject;
import twitter4j.Location;
import twitter4j.Logger;
import twitter4j.MediaEntity;
import twitter4j.OEmbed;
import twitter4j.OEmbedRequest;
import twitter4j.PagableResponseList;
import twitter4j.Paging;
import twitter4j.Place;
import twitter4j.Query;
import twitter4j.QueryResult;
import twitter4j.RateLimitStatus;
import twitter4j.Relationship;
import twitter4j.ResponseList;
import twitter4j.SavedSearch;
import twitter4j.Status;
import twitter4j.StatusUpdate;
import twitter4j.StringUtil;
import twitter4j.SymbolEntity;
import twitter4j.Trends;
import twitter4j.Twitter;
import twitter4j.TwitterAPIConfiguration;
import twitter4j.TwitterAPIMonitor;
import twitter4j.TwitterBaseImpl;
import twitter4j.TwitterException;
import twitter4j.URLEntity;
import twitter4j.UploadedMedia;
import twitter4j.User;
import twitter4j.UserList;
import twitter4j.UserMentionEntity;
import twitter4j.api.DirectMessagesResources;
import twitter4j.api.FavoritesResources;
import twitter4j.api.FriendsFollowersResources;
import twitter4j.api.HelpResources;
import twitter4j.api.ListsResources;
import twitter4j.api.PlacesGeoResources;
import twitter4j.api.SavedSearchesResources;
import twitter4j.api.SearchResource;
import twitter4j.api.SpamReportingResource;
import twitter4j.api.SuggestedUsersResources;
import twitter4j.api.TimelinesResources;
import twitter4j.api.TrendsResources;
import twitter4j.api.TweetsResources;
import twitter4j.api.UsersResources;
import twitter4j.auth.Authorization;
import twitter4j.conf.Configuration;

class TwitterImpl
extends TwitterBaseImpl
implements Twitter {
    private static final long serialVersionUID = 9170943084096085770L;
    private static final Logger logger = Logger.getLogger(TwitterBaseImpl.class);
    private final String IMPLICIT_PARAMS_STR;
    private final HttpParameter[] IMPLICIT_PARAMS;
    private final HttpParameter INCLUDE_MY_RETWEET;
    private final String CHUNKED_INIT = "INIT";
    private final String CHUNKED_APPEND = "APPEND";
    private final String CHUNKED_FINALIZE = "FINALIZE";
    private final String CHUNKED_STATUS = "STATUS";
    private final int MB = 0x100000;
    private final int MAX_VIDEO_SIZE = 0x20000000;
    private final int CHUNK_SIZE = 0x200000;
    private static final ConcurrentHashMap<Configuration, HttpParameter[]> implicitParamsMap = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Configuration, String> implicitParamsStrMap = new ConcurrentHashMap();
    private long myId = -1L;

    TwitterImpl(Configuration conf, Authorization auth) {
        super(conf, auth);
        this.INCLUDE_MY_RETWEET = new HttpParameter("include_my_retweet", conf.isIncludeMyRetweetEnabled());
        if (implicitParamsMap.containsKey(conf)) {
            this.IMPLICIT_PARAMS = implicitParamsMap.get(conf);
            this.IMPLICIT_PARAMS_STR = implicitParamsStrMap.get(conf);
        } else {
            boolean contributorsEnabled;
            String implicitParamsStr = conf.isIncludeEntitiesEnabled() ? "include_entities=true" : "";
            boolean bl = contributorsEnabled = conf.getContributingTo() != -1L;
            if (contributorsEnabled) {
                if (!"".equals(implicitParamsStr)) {
                    implicitParamsStr = implicitParamsStr + "&";
                }
                implicitParamsStr = implicitParamsStr + "contributingto=" + conf.getContributingTo();
            }
            if (conf.isTweetModeExtended()) {
                if (!"".equals(implicitParamsStr)) {
                    implicitParamsStr = implicitParamsStr + "&";
                }
                implicitParamsStr = implicitParamsStr + "tweet_mode=extended";
            }
            ArrayList<HttpParameter> params = new ArrayList<HttpParameter>(3);
            if (conf.isIncludeEntitiesEnabled()) {
                params.add(new HttpParameter("include_entities", "true"));
            }
            if (contributorsEnabled) {
                params.add(new HttpParameter("contributingto", conf.getContributingTo()));
            }
            if (conf.isTrimUserEnabled()) {
                params.add(new HttpParameter("trim_user", "1"));
            }
            if (conf.isIncludeExtAltTextEnabled()) {
                params.add(new HttpParameter("include_ext_alt_text", "true"));
            }
            if (conf.isTweetModeExtended()) {
                params.add(new HttpParameter("tweet_mode", "extended"));
            }
            HttpParameter[] implicitParams = params.toArray(new HttpParameter[params.size()]);
            implicitParamsStrMap.putIfAbsent(conf, implicitParamsStr);
            implicitParamsMap.putIfAbsent(conf, implicitParams);
            this.IMPLICIT_PARAMS = implicitParams;
            this.IMPLICIT_PARAMS_STR = implicitParamsStr;
        }
    }

    @Override
    public ResponseList<Status> getMentionsTimeline() throws TwitterException {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "statuses/mentions_timeline.json"));
    }

    @Override
    public ResponseList<Status> getMentionsTimeline(Paging paging) throws TwitterException {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "statuses/mentions_timeline.json", paging.asPostParameterArray()));
    }

    @Override
    public ResponseList<Status> getHomeTimeline() throws TwitterException {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "statuses/home_timeline.json", this.INCLUDE_MY_RETWEET));
    }

    @Override
    public ResponseList<Status> getHomeTimeline(Paging paging) throws TwitterException {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "statuses/home_timeline.json", this.mergeParameters(paging.asPostParameterArray(), new HttpParameter[]{this.INCLUDE_MY_RETWEET})));
    }

    @Override
    public ResponseList<Status> getRetweetsOfMe() throws TwitterException {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "statuses/retweets_of_me.json"));
    }

    @Override
    public ResponseList<Status> getRetweetsOfMe(Paging paging) throws TwitterException {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "statuses/retweets_of_me.json", paging.asPostParameterArray()));
    }

    @Override
    public ResponseList<Status> getUserTimeline(String screenName, Paging paging) throws TwitterException {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "statuses/user_timeline.json", this.mergeParameters(new HttpParameter[]{new HttpParameter("screen_name", screenName), this.INCLUDE_MY_RETWEET}, paging.asPostParameterArray())));
    }

    @Override
    public ResponseList<Status> getUserTimeline(long userId, Paging paging) throws TwitterException {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "statuses/user_timeline.json", this.mergeParameters(new HttpParameter[]{new HttpParameter("user_id", userId), this.INCLUDE_MY_RETWEET}, paging.asPostParameterArray())));
    }

    @Override
    public ResponseList<Status> getUserTimeline(String screenName) throws TwitterException {
        return this.getUserTimeline(screenName, new Paging());
    }

    @Override
    public ResponseList<Status> getUserTimeline(long userId) throws TwitterException {
        return this.getUserTimeline(userId, new Paging());
    }

    @Override
    public ResponseList<Status> getUserTimeline() throws TwitterException {
        return this.getUserTimeline(new Paging());
    }

    @Override
    public ResponseList<Status> getUserTimeline(Paging paging) throws TwitterException {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "statuses/user_timeline.json", this.mergeParameters(new HttpParameter[]{this.INCLUDE_MY_RETWEET}, paging.asPostParameterArray())));
    }

    @Override
    public ResponseList<Status> getRetweets(long statusId) throws TwitterException {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "statuses/retweets/" + statusId + ".json?count=100"));
    }

    @Override
    public IDs getRetweeterIds(long statusId, long cursor) throws TwitterException {
        return this.getRetweeterIds(statusId, 100, cursor);
    }

    @Override
    public IDs getRetweeterIds(long statusId, int count, long cursor) throws TwitterException {
        return this.factory.createIDs(this.get(this.conf.getRestBaseURL() + "statuses/retweeters/ids.json?id=" + statusId + "&cursor=" + cursor + "&count=" + count));
    }

    @Override
    public Status showStatus(long id) throws TwitterException {
        return this.factory.createStatus(this.get(this.conf.getRestBaseURL() + "statuses/show/" + id + ".json", this.INCLUDE_MY_RETWEET));
    }

    @Override
    public Status destroyStatus(long statusId) throws TwitterException {
        return this.factory.createStatus(this.post(this.conf.getRestBaseURL() + "statuses/destroy/" + statusId + ".json"));
    }

    @Override
    public Status updateStatus(String status) throws TwitterException {
        return this.factory.createStatus(this.post(this.conf.getRestBaseURL() + "statuses/update.json", new HttpParameter("status", status)));
    }

    @Override
    public Status updateStatus(StatusUpdate status) throws TwitterException {
        String url = this.conf.getRestBaseURL() + (status.isForUpdateWithMedia() ? "statuses/update_with_media.json" : "statuses/update.json");
        return this.factory.createStatus(this.post(url, status.asHttpParameterArray()));
    }

    @Override
    public Status retweetStatus(long statusId) throws TwitterException {
        return this.factory.createStatus(this.post(this.conf.getRestBaseURL() + "statuses/retweet/" + statusId + ".json"));
    }

    @Override
    public Status unRetweetStatus(long statusId) throws TwitterException {
        return this.factory.createStatus(this.post(this.conf.getRestBaseURL() + "statuses/unretweet/" + statusId + ".json"));
    }

    @Override
    public OEmbed getOEmbed(OEmbedRequest req) throws TwitterException {
        return this.factory.createOEmbed(this.get(this.conf.getRestBaseURL() + "statuses/oembed.json", req.asHttpParameterArray()));
    }

    @Override
    public ResponseList<Status> lookup(long ... ids) throws TwitterException {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "statuses/lookup.json?id=" + StringUtil.join(ids)));
    }

    @Override
    public UploadedMedia uploadMedia(File image) throws TwitterException {
        this.checkFileValidity(image);
        return new UploadedMedia(this.post(this.conf.getUploadBaseURL() + "media/upload.json", new HttpParameter("media", image)).asJSONObject());
    }

    @Override
    public UploadedMedia uploadMedia(String fileName, InputStream image) throws TwitterException {
        return new UploadedMedia(this.post(this.conf.getUploadBaseURL() + "media/upload.json", new HttpParameter("media", fileName, image)).asJSONObject());
    }

    @Override
    public UploadedMedia uploadMediaChunked(String fileName, InputStream media) throws TwitterException {
        byte[] dataBytes = null;
        try {
            int n;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(262144);
            byte[] buffer = new byte[32768];
            while ((n = media.read(buffer)) != -1) {
                baos.write(buffer, 0, n);
            }
            dataBytes = baos.toByteArray();
            if (dataBytes.length > 0x20000000) {
                throw new TwitterException(String.format(Locale.US, "video file can't be longer than: %d MBytes", 512));
            }
        }
        catch (IOException ioe) {
            throw new TwitterException("Failed to download the file.", ioe);
        }
        try {
            UploadedMedia uploadedMedia = this.uploadMediaChunkedInit(dataBytes.length);
            ByteArrayInputStream dataInputStream = new ByteArrayInputStream(dataBytes);
            byte[] segmentData = new byte[0x200000];
            int segmentIndex = 0;
            int totalRead = 0;
            int bytesRead = 0;
            while ((bytesRead = dataInputStream.read(segmentData)) > 0) {
                logger.debug("Chunked appened, segment index:" + segmentIndex + " bytes:" + (totalRead += bytesRead) + "/" + dataBytes.length);
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(segmentData, 0, bytesRead);
                this.uploadMediaChunkedAppend(fileName, byteArrayInputStream, segmentIndex, uploadedMedia.getMediaId());
                segmentData = new byte[0x200000];
                ++segmentIndex;
            }
            return this.uploadMediaChunkedFinalize(uploadedMedia.getMediaId());
        }
        catch (Exception e) {
            throw new TwitterException(e);
        }
    }

    private UploadedMedia uploadMediaChunkedInit(long size) throws TwitterException {
        return new UploadedMedia(this.post(this.conf.getUploadBaseURL() + "media/upload.json", new HttpParameter("command", "INIT"), new HttpParameter("media_type", "video/mp4"), new HttpParameter("media_category", "tweet_video"), new HttpParameter("total_bytes", size)).asJSONObject());
    }

    private void uploadMediaChunkedAppend(String fileName, InputStream media, int segmentIndex, long mediaId) throws TwitterException {
        this.post(this.conf.getUploadBaseURL() + "media/upload.json", new HttpParameter("command", "APPEND"), new HttpParameter("media_id", mediaId), new HttpParameter("segment_index", segmentIndex), new HttpParameter("media", fileName, media));
    }

    private UploadedMedia uploadMediaChunkedFinalize(long mediaId) throws TwitterException {
        int tries = 0;
        int maxTries = 20;
        int lastProgressPercent = 0;
        int currentProgressPercent = 0;
        UploadedMedia uploadedMedia = this.uploadMediaChunkedFinalize0(mediaId);
        while (tries < maxTries) {
            if (lastProgressPercent == currentProgressPercent) {
                ++tries;
            }
            lastProgressPercent = currentProgressPercent;
            String state = uploadedMedia.getProcessingState();
            if (state.equals("failed")) {
                throw new TwitterException("Failed to finalize the chuncked upload.");
            }
            if (state.equals("pending") || state.equals("in_progress")) {
                currentProgressPercent = uploadedMedia.getProgressPercent();
                int waitSec = Math.max(uploadedMedia.getProcessingCheckAfterSecs(), 1);
                logger.debug("Chunked finalize, wait for:" + waitSec + " sec");
                try {
                    Thread.sleep(waitSec * 1000);
                }
                catch (InterruptedException e) {
                    throw new TwitterException("Failed to finalize the chuncked upload.", e);
                }
            }
            if (state.equals("succeeded")) {
                return uploadedMedia;
            }
            uploadedMedia = this.uploadMediaChunkedStatus(mediaId);
        }
        throw new TwitterException("Failed to finalize the chuncked upload, progress has stopped, tried " + tries + 1 + " times.");
    }

    private UploadedMedia uploadMediaChunkedFinalize0(long mediaId) throws TwitterException {
        JSONObject json = this.post(this.conf.getUploadBaseURL() + "media/upload.json", new HttpParameter("command", "FINALIZE"), new HttpParameter("media_id", mediaId)).asJSONObject();
        logger.debug("Finalize response:" + json);
        return new UploadedMedia(json);
    }

    private UploadedMedia uploadMediaChunkedStatus(long mediaId) throws TwitterException {
        JSONObject json = this.get(this.conf.getUploadBaseURL() + "media/upload.json", new HttpParameter("command", "STATUS"), new HttpParameter("media_id", mediaId)).asJSONObject();
        logger.debug("Status response:" + json);
        return new UploadedMedia(json);
    }

    @Override
    public QueryResult search(Query query) throws TwitterException {
        if (query.nextPage() != null) {
            return this.factory.createQueryResult(this.get(this.conf.getRestBaseURL() + "search/tweets.json" + query.nextPage()), query);
        }
        return this.factory.createQueryResult(this.get(this.conf.getRestBaseURL() + "search/tweets.json", query.asHttpParameterArray()), query);
    }

    @Override
    public ResponseList<DirectMessage> getDirectMessages() throws TwitterException {
        return this.removeDMsNotSentToMe(this.getDirectMessages(100));
    }

    @Override
    public ResponseList<DirectMessage> getDirectMessages(Paging paging) throws TwitterException {
        return this.removeDMsNotSentToMe(this.getDirectMessages(paging.getCount()));
    }

    @Override
    public DirectMessageList getDirectMessages(int count) throws TwitterException {
        return this.factory.createDirectMessageList(this.get(this.conf.getRestBaseURL() + "direct_messages/events/list.json", new HttpParameter("count", count)));
    }

    @Override
    public DirectMessageList getDirectMessages(int count, String cursor) throws TwitterException {
        return this.factory.createDirectMessageList(this.get(this.conf.getRestBaseURL() + "direct_messages/events/list.json", new HttpParameter("count", count), new HttpParameter("cursor", cursor)));
    }

    @Override
    public ResponseList<DirectMessage> getSentDirectMessages() throws TwitterException {
        return this.removeDMsNotSentByMe(this.getDirectMessages(100));
    }

    @Override
    public ResponseList<DirectMessage> getSentDirectMessages(Paging paging) throws TwitterException {
        return this.removeDMsNotSentByMe(this.getDirectMessages(paging.getCount()));
    }

    private DirectMessageList removeDMsNotSentToMe(DirectMessageList list) throws TwitterException {
        if (this.myId == -1L) {
            this.myId = this.verifyCredentials().getId();
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            if (((DirectMessage)list.get(i)).getRecipientId() == this.myId) continue;
            list.remove(i);
        }
        return list;
    }

    private DirectMessageList removeDMsNotSentByMe(DirectMessageList list) throws TwitterException {
        if (this.myId == -1L) {
            this.myId = this.verifyCredentials().getId();
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            if (((DirectMessage)list.get(i)).getSenderId() == this.myId) continue;
            list.remove(i);
        }
        return list;
    }

    @Override
    public DirectMessage showDirectMessage(long id) throws TwitterException {
        return this.factory.createDirectMessage(this.get(this.conf.getRestBaseURL() + "direct_messages/events/show.json?id=" + id));
    }

    @Override
    public DirectMessage destroyDirectMessage(long id) throws TwitterException {
        this.ensureAuthorizationEnabled();
        this.http.delete(this.conf.getRestBaseURL() + "direct_messages/events/destroy.json?id=" + id, null, this.auth, null);
        return new DirectMessage(){

            @Override
            public long getId() {
                throw new UnsupportedOperationException("Since Twitter4J 4.0.7, you are no longer able to access the return value from destroyDirectMessage(id) due to the API changes.");
            }

            @Override
            public String getText() {
                throw new UnsupportedOperationException("Since Twitter4J 4.0.7, you are no longer able to access the return value from destroyDirectMessage(id) due to the API changes.");
            }

            @Override
            public long getSenderId() {
                throw new UnsupportedOperationException("Since Twitter4J 4.0.7, you are no longer able to access the return value from destroyDirectMessage(id) due to the API changes.");
            }

            @Override
            public long getRecipientId() {
                throw new UnsupportedOperationException("Since Twitter4J 4.0.7, you are no longer able to access the return value from destroyDirectMessage(id) due to the API changes.");
            }

            @Override
            public Date getCreatedAt() {
                throw new UnsupportedOperationException("Since Twitter4J 4.0.7, you are no longer able to access the return value from destroyDirectMessage(id) due to the API changes.");
            }

            @Override
            public String getSenderScreenName() {
                throw new UnsupportedOperationException("Since Twitter4J 4.0.7, you are no longer able to access the return value from destroyDirectMessage(id) due to the API changes.");
            }

            @Override
            public String getRecipientScreenName() {
                throw new UnsupportedOperationException("Since Twitter4J 4.0.7, you are no longer able to access the return value from destroyDirectMessage(id) due to the API changes.");
            }

            @Override
            public User getSender() {
                throw new UnsupportedOperationException("Since Twitter4J 4.0.7, you are no longer able to access the return value from destroyDirectMessage(id) due to the API changes.");
            }

            @Override
            public User getRecipient() {
                throw new UnsupportedOperationException("Since Twitter4J 4.0.7, you are no longer able to access the return value from destroyDirectMessage(id) due to the API changes.");
            }

            @Override
            public UserMentionEntity[] getUserMentionEntities() {
                throw new UnsupportedOperationException("Since Twitter4J 4.0.7, you are no longer able to access the return value from destroyDirectMessage(id) due to the API changes.");
            }

            @Override
            public URLEntity[] getURLEntities() {
                throw new UnsupportedOperationException("Since Twitter4J 4.0.7, you are no longer able to access the return value from destroyDirectMessage(id) due to the API changes.");
            }

            @Override
            public HashtagEntity[] getHashtagEntities() {
                throw new UnsupportedOperationException("Since Twitter4J 4.0.7, you are no longer able to access the return value from destroyDirectMessage(id) due to the API changes.");
            }

            @Override
            public MediaEntity[] getMediaEntities() {
                throw new UnsupportedOperationException("Since Twitter4J 4.0.7, you are no longer able to access the return value from destroyDirectMessage(id) due to the API changes.");
            }

            @Override
            public SymbolEntity[] getSymbolEntities() {
                throw new UnsupportedOperationException("Since Twitter4J 4.0.7, you are no longer able to access the return value from destroyDirectMessage(id) due to the API changes.");
            }

            @Override
            public RateLimitStatus getRateLimitStatus() {
                throw new UnsupportedOperationException("Since Twitter4J 4.0.7, you are no longer able to access the return value from destroyDirectMessage(id) due to the API changes.");
            }

            @Override
            public int getAccessLevel() {
                throw new UnsupportedOperationException("Since Twitter4J 4.0.7, you are no longer able to access the return value from destroyDirectMessage(id) due to the API changes.");
            }
        };
    }

    @Override
    public DirectMessage sendDirectMessage(long recipientId, String text, long messageId) throws TwitterException {
        try {
            JSONObject json = new JSONObject();
            JSONObject event = new JSONObject();
            event.put("type", "message_create");
            event.put("message_create", TwitterImpl.createMessageCreateJsonObject(recipientId, text, messageId));
            json.put("event", event);
            return this.factory.createDirectMessage(this.post(this.conf.getRestBaseURL() + "direct_messages/events/new.json", json));
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    private static JSONObject createMessageCreateJsonObject(long recipientId, String text, long mediaId) throws JSONException {
        String type = mediaId == -1L ? null : "media";
        JSONObject json = new JSONObject();
        JSONObject target = new JSONObject();
        target.put("recipient_id", recipientId);
        json.put("target", target);
        JSONObject messageData = new JSONObject();
        messageData.put("text", text);
        if (type != null && mediaId != -1L) {
            JSONObject attachment = new JSONObject();
            attachment.put("type", type);
            if (type.equals("media")) {
                JSONObject media = new JSONObject();
                media.put("id", mediaId);
                attachment.put("media", media);
            }
            messageData.put("attachment", attachment);
        }
        json.put("message_data", messageData);
        return json;
    }

    @Override
    public DirectMessage sendDirectMessage(long recipientId, String text) throws TwitterException {
        return this.sendDirectMessage(recipientId, text, -1L);
    }

    @Override
    public DirectMessage sendDirectMessage(String screenName, String text) throws TwitterException {
        return this.sendDirectMessage(this.showUser(screenName).getId(), text);
    }

    @Override
    public InputStream getDMImageAsStream(String url) throws TwitterException {
        return this.get(url).asStream();
    }

    @Override
    public IDs getNoRetweetsFriendships() throws TwitterException {
        return this.factory.createIDs(this.get(this.conf.getRestBaseURL() + "friendships/no_retweets/ids.json"));
    }

    @Override
    public IDs getFriendsIDs(long cursor) throws TwitterException {
        return this.factory.createIDs(this.get(this.conf.getRestBaseURL() + "friends/ids.json?cursor=" + cursor));
    }

    @Override
    public IDs getFriendsIDs(long userId, long cursor) throws TwitterException {
        return this.factory.createIDs(this.get(this.conf.getRestBaseURL() + "friends/ids.json?user_id=" + userId + "&cursor=" + cursor));
    }

    @Override
    public IDs getFriendsIDs(long userId, long cursor, int count) throws TwitterException {
        return this.factory.createIDs(this.get(this.conf.getRestBaseURL() + "friends/ids.json?user_id=" + userId + "&cursor=" + cursor + "&count=" + count));
    }

    @Override
    public IDs getFriendsIDs(String screenName, long cursor) throws TwitterException {
        return this.factory.createIDs(this.get(this.conf.getRestBaseURL() + "friends/ids.json", new HttpParameter("screen_name", screenName), new HttpParameter("cursor", cursor)));
    }

    @Override
    public IDs getFriendsIDs(String screenName, long cursor, int count) throws TwitterException {
        return this.factory.createIDs(this.get(this.conf.getRestBaseURL() + "friends/ids.json", new HttpParameter("screen_name", screenName), new HttpParameter("cursor", cursor), new HttpParameter("count", count)));
    }

    @Override
    public IDs getFollowersIDs(long cursor) throws TwitterException {
        return this.factory.createIDs(this.get(this.conf.getRestBaseURL() + "followers/ids.json?cursor=" + cursor));
    }

    @Override
    public IDs getFollowersIDs(long userId, long cursor) throws TwitterException {
        return this.factory.createIDs(this.get(this.conf.getRestBaseURL() + "followers/ids.json?user_id=" + userId + "&cursor=" + cursor));
    }

    @Override
    public IDs getFollowersIDs(long userId, long cursor, int count) throws TwitterException {
        return this.factory.createIDs(this.get(this.conf.getRestBaseURL() + "followers/ids.json?user_id=" + userId + "&cursor=" + cursor + "&count=" + count));
    }

    @Override
    public IDs getFollowersIDs(String screenName, long cursor) throws TwitterException {
        return this.factory.createIDs(this.get(this.conf.getRestBaseURL() + "followers/ids.json", new HttpParameter("screen_name", screenName), new HttpParameter("cursor", cursor)));
    }

    @Override
    public IDs getFollowersIDs(String screenName, long cursor, int count) throws TwitterException {
        return this.factory.createIDs(this.get(this.conf.getRestBaseURL() + "followers/ids.json", new HttpParameter("screen_name", screenName), new HttpParameter("cursor", cursor), new HttpParameter("count", count)));
    }

    @Override
    public ResponseList<Friendship> lookupFriendships(long ... ids) throws TwitterException {
        return this.factory.createFriendshipList(this.get(this.conf.getRestBaseURL() + "friendships/lookup.json?user_id=" + StringUtil.join(ids)));
    }

    @Override
    public ResponseList<Friendship> lookupFriendships(String ... screenNames) throws TwitterException {
        return this.factory.createFriendshipList(this.get(this.conf.getRestBaseURL() + "friendships/lookup.json?screen_name=" + StringUtil.join(screenNames)));
    }

    @Override
    public IDs getIncomingFriendships(long cursor) throws TwitterException {
        return this.factory.createIDs(this.get(this.conf.getRestBaseURL() + "friendships/incoming.json?cursor=" + cursor));
    }

    @Override
    public IDs getOutgoingFriendships(long cursor) throws TwitterException {
        return this.factory.createIDs(this.get(this.conf.getRestBaseURL() + "friendships/outgoing.json?cursor=" + cursor));
    }

    @Override
    public User createFriendship(long userId) throws TwitterException {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "friendships/create.json?user_id=" + userId));
    }

    @Override
    public User createFriendship(String screenName) throws TwitterException {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "friendships/create.json", new HttpParameter("screen_name", screenName)));
    }

    @Override
    public User createFriendship(long userId, boolean follow) throws TwitterException {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "friendships/create.json?user_id=" + userId + "&follow=" + follow));
    }

    @Override
    public User createFriendship(String screenName, boolean follow) throws TwitterException {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "friendships/create.json", new HttpParameter("screen_name", screenName), new HttpParameter("follow", follow)));
    }

    @Override
    public User destroyFriendship(long userId) throws TwitterException {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "friendships/destroy.json?user_id=" + userId));
    }

    @Override
    public User destroyFriendship(String screenName) throws TwitterException {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "friendships/destroy.json", new HttpParameter("screen_name", screenName)));
    }

    @Override
    public Relationship updateFriendship(long userId, boolean enableDeviceNotification, boolean retweets) throws TwitterException {
        return this.factory.createRelationship(this.post(this.conf.getRestBaseURL() + "friendships/update.json", new HttpParameter("user_id", userId), new HttpParameter("device", enableDeviceNotification), new HttpParameter("retweets", retweets)));
    }

    @Override
    public Relationship updateFriendship(String screenName, boolean enableDeviceNotification, boolean retweets) throws TwitterException {
        return this.factory.createRelationship(this.post(this.conf.getRestBaseURL() + "friendships/update.json", new HttpParameter("screen_name", screenName), new HttpParameter("device", enableDeviceNotification), new HttpParameter("retweets", retweets)));
    }

    @Override
    public Relationship showFriendship(long sourceId, long targetId) throws TwitterException {
        return this.factory.createRelationship(this.get(this.conf.getRestBaseURL() + "friendships/show.json", new HttpParameter("source_id", sourceId), new HttpParameter("target_id", targetId)));
    }

    @Override
    public Relationship showFriendship(String sourceScreenName, String targetScreenName) throws TwitterException {
        return this.factory.createRelationship(this.get(this.conf.getRestBaseURL() + "friendships/show.json", HttpParameter.getParameterArray("source_screen_name", sourceScreenName, "target_screen_name", targetScreenName)));
    }

    @Override
    public PagableResponseList<User> getFriendsList(long userId, long cursor) throws TwitterException {
        return this.getFriendsList(userId, cursor, 20);
    }

    @Override
    public PagableResponseList<User> getFriendsList(long userId, long cursor, int count) throws TwitterException {
        return this.factory.createPagableUserList(this.get(this.conf.getRestBaseURL() + "friends/list.json?user_id=" + userId + "&cursor=" + cursor + "&count=" + count));
    }

    @Override
    public PagableResponseList<User> getFriendsList(String screenName, long cursor) throws TwitterException {
        return this.getFriendsList(screenName, cursor, 20);
    }

    @Override
    public PagableResponseList<User> getFriendsList(String screenName, long cursor, int count) throws TwitterException {
        return this.factory.createPagableUserList(this.get(this.conf.getRestBaseURL() + "friends/list.json", new HttpParameter("screen_name", screenName), new HttpParameter("cursor", cursor), new HttpParameter("count", count)));
    }

    @Override
    public PagableResponseList<User> getFriendsList(long userId, long cursor, int count, boolean skipStatus, boolean includeUserEntities) throws TwitterException {
        return this.factory.createPagableUserList(this.get(this.conf.getRestBaseURL() + "friends/list.json?user_id=" + userId + "&cursor=" + cursor + "&count=" + count + "&skip_status=" + skipStatus + "&include_user_entities=" + includeUserEntities));
    }

    @Override
    public PagableResponseList<User> getFriendsList(String screenName, long cursor, int count, boolean skipStatus, boolean includeUserEntities) throws TwitterException {
        return this.factory.createPagableUserList(this.get(this.conf.getRestBaseURL() + "friends/list.json", new HttpParameter("screen_name", screenName), new HttpParameter("cursor", cursor), new HttpParameter("count", count), new HttpParameter("skip_status", skipStatus), new HttpParameter("include_user_entities", includeUserEntities)));
    }

    @Override
    public PagableResponseList<User> getFollowersList(long userId, long cursor) throws TwitterException {
        return this.getFollowersList(userId, cursor, 20);
    }

    @Override
    public PagableResponseList<User> getFollowersList(String screenName, long cursor) throws TwitterException {
        return this.getFollowersList(screenName, cursor, 20);
    }

    @Override
    public PagableResponseList<User> getFollowersList(long userId, long cursor, int count) throws TwitterException {
        return this.factory.createPagableUserList(this.get(this.conf.getRestBaseURL() + "followers/list.json?user_id=" + userId + "&cursor=" + cursor + "&count=" + count));
    }

    @Override
    public PagableResponseList<User> getFollowersList(String screenName, long cursor, int count) throws TwitterException {
        return this.factory.createPagableUserList(this.get(this.conf.getRestBaseURL() + "followers/list.json", new HttpParameter("screen_name", screenName), new HttpParameter("cursor", cursor), new HttpParameter("count", count)));
    }

    @Override
    public PagableResponseList<User> getFollowersList(long userId, long cursor, int count, boolean skipStatus, boolean includeUserEntities) throws TwitterException {
        return this.factory.createPagableUserList(this.get(this.conf.getRestBaseURL() + "followers/list.json?user_id=" + userId + "&cursor=" + cursor + "&count=" + count + "&skip_status=" + skipStatus + "&include_user_entities=" + includeUserEntities));
    }

    @Override
    public PagableResponseList<User> getFollowersList(String screenName, long cursor, int count, boolean skipStatus, boolean includeUserEntities) throws TwitterException {
        return this.factory.createPagableUserList(this.get(this.conf.getRestBaseURL() + "followers/list.json", new HttpParameter("screen_name", screenName), new HttpParameter("cursor", cursor), new HttpParameter("count", count), new HttpParameter("skip_status", skipStatus), new HttpParameter("include_user_entities", includeUserEntities)));
    }

    @Override
    public AccountSettings getAccountSettings() throws TwitterException {
        return this.factory.createAccountSettings(this.get(this.conf.getRestBaseURL() + "account/settings.json"));
    }

    @Override
    public User verifyCredentials() throws TwitterException {
        return super.fillInIDAndScreenName(new HttpParameter[]{new HttpParameter("include_email", this.conf.isIncludeEmailEnabled())});
    }

    @Override
    public AccountSettings updateAccountSettings(Integer trend_locationWoeid, Boolean sleep_timeEnabled, String start_sleepTime, String end_sleepTime, String time_zone, String lang) throws TwitterException {
        ArrayList<HttpParameter> profile = new ArrayList<HttpParameter>(6);
        if (trend_locationWoeid != null) {
            profile.add(new HttpParameter("trend_location_woeid", trend_locationWoeid));
        }
        if (sleep_timeEnabled != null) {
            profile.add(new HttpParameter("sleep_time_enabled", sleep_timeEnabled.toString()));
        }
        if (start_sleepTime != null) {
            profile.add(new HttpParameter("start_sleep_time", start_sleepTime));
        }
        if (end_sleepTime != null) {
            profile.add(new HttpParameter("end_sleep_time", end_sleepTime));
        }
        if (time_zone != null) {
            profile.add(new HttpParameter("time_zone", time_zone));
        }
        if (lang != null) {
            profile.add(new HttpParameter("lang", lang));
        }
        return this.factory.createAccountSettings(this.post(this.conf.getRestBaseURL() + "account/settings.json", profile.toArray(new HttpParameter[profile.size()])));
    }

    @Override
    public AccountSettings updateAllowDmsFrom(String allowDmsFrom) throws TwitterException {
        return this.factory.createAccountSettings(this.post(this.conf.getRestBaseURL() + "account/settings.json?allow_dms_from=" + allowDmsFrom));
    }

    @Override
    public User updateProfile(String name, String url, String location, String description) throws TwitterException {
        ArrayList<HttpParameter> profile = new ArrayList<HttpParameter>(4);
        this.addParameterToList(profile, "name", name);
        this.addParameterToList(profile, "url", url);
        this.addParameterToList(profile, "location", location);
        this.addParameterToList(profile, "description", description);
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "account/update_profile.json", profile.toArray(new HttpParameter[profile.size()])));
    }

    @Override
    public User updateProfileBackgroundImage(File image, boolean tile) throws TwitterException {
        this.checkFileValidity(image);
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "account/update_profile_background_image.json", new HttpParameter("image", image), new HttpParameter("tile", tile)));
    }

    @Override
    public User updateProfileBackgroundImage(InputStream image, boolean tile) throws TwitterException {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "account/update_profile_background_image.json", new HttpParameter("image", "image", image), new HttpParameter("tile", tile)));
    }

    @Override
    public User updateProfileColors(String profileBackgroundColor, String profileTextColor, String profileLinkColor, String profileSidebarFillColor, String profileSidebarBorderColor) throws TwitterException {
        throw new UnsupportedOperationException("this API is no longer supported. https://twittercommunity.com/t/deprecation-of-account-update-profile-colors/28692");
    }

    private void addParameterToList(List<HttpParameter> colors, String paramName, String color) {
        if (color != null) {
            colors.add(new HttpParameter(paramName, color));
        }
    }

    @Override
    public User updateProfileImage(File image) throws TwitterException {
        this.checkFileValidity(image);
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "account/update_profile_image.json", new HttpParameter("image", image)));
    }

    @Override
    public User updateProfileImage(InputStream image) throws TwitterException {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "account/update_profile_image.json", new HttpParameter("image", "image", image)));
    }

    private void checkFileValidity(File image) throws TwitterException {
        if (!image.exists()) {
            throw new TwitterException(new FileNotFoundException(image + " is not found."));
        }
        if (!image.isFile()) {
            throw new TwitterException(new IOException(image + " is not a file."));
        }
    }

    @Override
    public PagableResponseList<User> getBlocksList() throws TwitterException {
        return this.getBlocksList(-1L);
    }

    @Override
    public PagableResponseList<User> getBlocksList(long cursor) throws TwitterException {
        return this.factory.createPagableUserList(this.get(this.conf.getRestBaseURL() + "blocks/list.json?cursor=" + cursor));
    }

    @Override
    public IDs getBlocksIDs() throws TwitterException {
        return this.factory.createIDs(this.get(this.conf.getRestBaseURL() + "blocks/ids.json"));
    }

    @Override
    public IDs getBlocksIDs(long cursor) throws TwitterException {
        return this.factory.createIDs(this.get(this.conf.getRestBaseURL() + "blocks/ids.json?cursor=" + cursor));
    }

    @Override
    public User createBlock(long userId) throws TwitterException {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "blocks/create.json?user_id=" + userId));
    }

    @Override
    public User createBlock(String screenName) throws TwitterException {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "blocks/create.json", new HttpParameter("screen_name", screenName)));
    }

    @Override
    public User destroyBlock(long userId) throws TwitterException {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "blocks/destroy.json?user_id=" + userId));
    }

    @Override
    public User destroyBlock(String screenName) throws TwitterException {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "blocks/destroy.json", new HttpParameter("screen_name", screenName)));
    }

    @Override
    public PagableResponseList<User> getMutesList(long cursor) throws TwitterException {
        return this.factory.createPagableUserList(this.get(this.conf.getRestBaseURL() + "mutes/users/list.json?cursor=" + cursor));
    }

    @Override
    public IDs getMutesIDs(long cursor) throws TwitterException {
        return this.factory.createIDs(this.get(this.conf.getRestBaseURL() + "mutes/users/ids.json?cursor=" + cursor));
    }

    @Override
    public User createMute(long userId) throws TwitterException {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "mutes/users/create.json?user_id=" + userId));
    }

    @Override
    public User createMute(String screenName) throws TwitterException {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "mutes/users/create.json", new HttpParameter("screen_name", screenName)));
    }

    @Override
    public User destroyMute(long userId) throws TwitterException {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "mutes/users/destroy.json?user_id=" + userId));
    }

    @Override
    public User destroyMute(String screenName) throws TwitterException {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "mutes/users/destroy.json", new HttpParameter("screen_name", screenName)));
    }

    @Override
    public ResponseList<User> lookupUsers(long ... ids) throws TwitterException {
        return this.factory.createUserList(this.get(this.conf.getRestBaseURL() + "users/lookup.json", new HttpParameter("user_id", StringUtil.join(ids))));
    }

    @Override
    public ResponseList<User> lookupUsers(String ... screenNames) throws TwitterException {
        return this.factory.createUserList(this.get(this.conf.getRestBaseURL() + "users/lookup.json", new HttpParameter("screen_name", StringUtil.join(screenNames))));
    }

    @Override
    public User showUser(long userId) throws TwitterException {
        return this.factory.createUser(this.get(this.conf.getRestBaseURL() + "users/show.json?user_id=" + userId));
    }

    @Override
    public User showUser(String screenName) throws TwitterException {
        return this.factory.createUser(this.get(this.conf.getRestBaseURL() + "users/show.json", new HttpParameter("screen_name", screenName)));
    }

    @Override
    public ResponseList<User> searchUsers(String query, int page) throws TwitterException {
        return this.factory.createUserList(this.get(this.conf.getRestBaseURL() + "users/search.json", new HttpParameter("q", query), new HttpParameter("per_page", 20), new HttpParameter("page", page)));
    }

    @Override
    public ResponseList<User> getContributees(long userId) throws TwitterException {
        return this.factory.createUserList(this.get(this.conf.getRestBaseURL() + "users/contributees.json?user_id=" + userId));
    }

    @Override
    public ResponseList<User> getContributees(String screenName) throws TwitterException {
        return this.factory.createUserList(this.get(this.conf.getRestBaseURL() + "users/contributees.json", new HttpParameter("screen_name", screenName)));
    }

    @Override
    public ResponseList<User> getContributors(long userId) throws TwitterException {
        return this.factory.createUserList(this.get(this.conf.getRestBaseURL() + "users/contributors.json?user_id=" + userId));
    }

    @Override
    public ResponseList<User> getContributors(String screenName) throws TwitterException {
        return this.factory.createUserList(this.get(this.conf.getRestBaseURL() + "users/contributors.json", new HttpParameter("screen_name", screenName)));
    }

    @Override
    public void removeProfileBanner() throws TwitterException {
        this.post(this.conf.getRestBaseURL() + "account/remove_profile_banner.json");
    }

    @Override
    public void updateProfileBanner(File image) throws TwitterException {
        this.checkFileValidity(image);
        this.post(this.conf.getRestBaseURL() + "account/update_profile_banner.json", new HttpParameter("banner", image));
    }

    @Override
    public void updateProfileBanner(InputStream image) throws TwitterException {
        this.post(this.conf.getRestBaseURL() + "account/update_profile_banner.json", new HttpParameter("banner", "banner", image));
    }

    @Override
    public ResponseList<User> getUserSuggestions(String categorySlug) throws TwitterException {
        HttpResponse res;
        try {
            res = this.get(this.conf.getRestBaseURL() + "users/suggestions/" + URLEncoder.encode(categorySlug, "UTF-8") + ".json");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return this.factory.createUserListFromJSONArray_Users(res);
    }

    @Override
    public ResponseList<Category> getSuggestedUserCategories() throws TwitterException {
        return this.factory.createCategoryList(this.get(this.conf.getRestBaseURL() + "users/suggestions.json"));
    }

    @Override
    public ResponseList<User> getMemberSuggestions(String categorySlug) throws TwitterException {
        HttpResponse res;
        try {
            res = this.get(this.conf.getRestBaseURL() + "users/suggestions/" + URLEncoder.encode(categorySlug, "UTF-8") + "/members.json");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return this.factory.createUserListFromJSONArray(res);
    }

    @Override
    public ResponseList<Status> getFavorites() throws TwitterException {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "favorites/list.json"));
    }

    @Override
    public ResponseList<Status> getFavorites(long userId) throws TwitterException {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "favorites/list.json?user_id=" + userId));
    }

    @Override
    public ResponseList<Status> getFavorites(String screenName) throws TwitterException {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "favorites/list.json", new HttpParameter("screen_name", screenName)));
    }

    @Override
    public ResponseList<Status> getFavorites(Paging paging) throws TwitterException {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "favorites/list.json", paging.asPostParameterArray()));
    }

    @Override
    public ResponseList<Status> getFavorites(long userId, Paging paging) throws TwitterException {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "favorites/list.json", this.mergeParameters(new HttpParameter[]{new HttpParameter("user_id", userId)}, paging.asPostParameterArray())));
    }

    @Override
    public ResponseList<Status> getFavorites(String screenName, Paging paging) throws TwitterException {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "favorites/list.json", this.mergeParameters(new HttpParameter[]{new HttpParameter("screen_name", screenName)}, paging.asPostParameterArray())));
    }

    @Override
    public Status destroyFavorite(long id) throws TwitterException {
        return this.factory.createStatus(this.post(this.conf.getRestBaseURL() + "favorites/destroy.json?id=" + id));
    }

    @Override
    public Status createFavorite(long id) throws TwitterException {
        return this.factory.createStatus(this.post(this.conf.getRestBaseURL() + "favorites/create.json?id=" + id));
    }

    @Override
    public ResponseList<UserList> getUserLists(String listOwnerScreenName) throws TwitterException {
        return this.getUserLists(listOwnerScreenName, false);
    }

    @Override
    public ResponseList<UserList> getUserLists(String listOwnerScreenName, boolean reverse) throws TwitterException {
        return this.factory.createUserListList(this.get(this.conf.getRestBaseURL() + "lists/list.json", new HttpParameter("screen_name", listOwnerScreenName), new HttpParameter("reverse", reverse)));
    }

    @Override
    public ResponseList<UserList> getUserLists(long listOwnerUserId) throws TwitterException {
        return this.getUserLists(listOwnerUserId, false);
    }

    @Override
    public ResponseList<UserList> getUserLists(long listOwnerUserId, boolean reverse) throws TwitterException {
        return this.factory.createUserListList(this.get(this.conf.getRestBaseURL() + "lists/list.json", new HttpParameter("user_id", listOwnerUserId), new HttpParameter("reverse", reverse)));
    }

    @Override
    public ResponseList<Status> getUserListStatuses(long listId, Paging paging) throws TwitterException {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "lists/statuses.json", this.mergeParameters(paging.asPostParameterArray(Paging.SMCP, "count"), new HttpParameter("list_id", listId))));
    }

    @Override
    public ResponseList<Status> getUserListStatuses(long ownerId, String slug, Paging paging) throws TwitterException {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "lists/statuses.json", this.mergeParameters(paging.asPostParameterArray(Paging.SMCP, "count"), new HttpParameter[]{new HttpParameter("owner_id", ownerId), new HttpParameter("slug", slug)})));
    }

    @Override
    public ResponseList<Status> getUserListStatuses(String ownerScreenName, String slug, Paging paging) throws TwitterException {
        return this.factory.createStatusList(this.get(this.conf.getRestBaseURL() + "lists/statuses.json", this.mergeParameters(paging.asPostParameterArray(Paging.SMCP, "count"), new HttpParameter[]{new HttpParameter("owner_screen_name", ownerScreenName), new HttpParameter("slug", slug)})));
    }

    @Override
    public UserList destroyUserListMember(long listId, long userId) throws TwitterException {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/members/destroy.json", new HttpParameter("list_id", listId), new HttpParameter("user_id", userId)));
    }

    @Override
    public UserList destroyUserListMember(long ownerId, String slug, long userId) throws TwitterException {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/members/destroy.json", new HttpParameter("owner_id", ownerId), new HttpParameter("slug", slug), new HttpParameter("user_id", userId)));
    }

    @Override
    public UserList destroyUserListMember(long listId, String screenName) throws TwitterException {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/members/destroy.json", new HttpParameter("list_id", listId), new HttpParameter("screen_name", screenName)));
    }

    @Override
    public UserList destroyUserListMember(String ownerScreenName, String slug, long userId) throws TwitterException {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/members/destroy.json", new HttpParameter("owner_screen_name", ownerScreenName), new HttpParameter("slug", slug), new HttpParameter("user_id", userId)));
    }

    @Override
    public UserList destroyUserListMembers(long listId, String[] screenNames) throws TwitterException {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/members/destroy_all.json", new HttpParameter("list_id", listId), new HttpParameter("screen_name", StringUtil.join(screenNames))));
    }

    @Override
    public UserList destroyUserListMembers(long listId, long[] userIds) throws TwitterException {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/members/destroy_all.json", new HttpParameter("list_id", listId), new HttpParameter("user_id", StringUtil.join(userIds))));
    }

    @Override
    public UserList destroyUserListMembers(String ownerScreenName, String slug, String[] screenNames) throws TwitterException {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/members/destroy_all.json", new HttpParameter("owner_screen_name", ownerScreenName), new HttpParameter("slug", slug), new HttpParameter("screen_name", StringUtil.join(screenNames))));
    }

    @Override
    public PagableResponseList<UserList> getUserListMemberships(long cursor) throws TwitterException {
        return this.getUserListMemberships(20, cursor);
    }

    @Override
    public PagableResponseList<UserList> getUserListMemberships(int count, long cursor) throws TwitterException {
        return this.factory.createPagableUserListList(this.get(this.conf.getRestBaseURL() + "lists/memberships.json", new HttpParameter("cursor", cursor), new HttpParameter("count", count)));
    }

    @Override
    public PagableResponseList<UserList> getUserListMemberships(String listMemberScreenName, long cursor) throws TwitterException {
        return this.getUserListMemberships(listMemberScreenName, cursor, false);
    }

    @Override
    public PagableResponseList<UserList> getUserListMemberships(String listMemberScreenName, int count, long cursor) throws TwitterException {
        return this.getUserListMemberships(listMemberScreenName, count, cursor, false);
    }

    @Override
    public PagableResponseList<UserList> getUserListMemberships(String listMemberScreenName, long cursor, boolean filterToOwnedLists) throws TwitterException {
        return this.getUserListMemberships(listMemberScreenName, 20, cursor, filterToOwnedLists);
    }

    @Override
    public PagableResponseList<UserList> getUserListMemberships(String listMemberScreenName, int count, long cursor, boolean filterToOwnedLists) throws TwitterException {
        return this.factory.createPagableUserListList(this.get(this.conf.getRestBaseURL() + "lists/memberships.json", new HttpParameter("screen_name", listMemberScreenName), new HttpParameter("count", count), new HttpParameter("cursor", cursor), new HttpParameter("filter_to_owned_lists", filterToOwnedLists)));
    }

    @Override
    public PagableResponseList<UserList> getUserListMemberships(long listMemberId, long cursor) throws TwitterException {
        return this.getUserListMemberships(listMemberId, cursor, false);
    }

    @Override
    public PagableResponseList<UserList> getUserListMemberships(long listMemberId, int count, long cursor) throws TwitterException {
        return this.getUserListMemberships(listMemberId, count, cursor, false);
    }

    @Override
    public PagableResponseList<UserList> getUserListMemberships(long listMemberId, long cursor, boolean filterToOwnedLists) throws TwitterException {
        return this.getUserListMemberships(listMemberId, 20, cursor, filterToOwnedLists);
    }

    @Override
    public PagableResponseList<UserList> getUserListMemberships(long listMemberId, int count, long cursor, boolean filterToOwnedLists) throws TwitterException {
        return this.factory.createPagableUserListList(this.get(this.conf.getRestBaseURL() + "lists/memberships.json", new HttpParameter("user_id", listMemberId), new HttpParameter("count", count), new HttpParameter("cursor", cursor), new HttpParameter("filter_to_owned_lists", filterToOwnedLists)));
    }

    @Override
    public PagableResponseList<User> getUserListSubscribers(long listId, long cursor) throws TwitterException {
        return this.getUserListSubscribers(listId, 20, cursor, false);
    }

    @Override
    public PagableResponseList<User> getUserListSubscribers(long listId, int count, long cursor) throws TwitterException {
        return this.getUserListSubscribers(listId, count, cursor, false);
    }

    @Override
    public PagableResponseList<User> getUserListSubscribers(long listId, int count, long cursor, boolean skipStatus) throws TwitterException {
        return this.factory.createPagableUserList(this.get(this.conf.getRestBaseURL() + "lists/subscribers.json", new HttpParameter("list_id", listId), new HttpParameter("count", count), new HttpParameter("cursor", cursor), new HttpParameter("skip_status", skipStatus)));
    }

    @Override
    public PagableResponseList<User> getUserListSubscribers(long ownerId, String slug, long cursor) throws TwitterException {
        return this.getUserListSubscribers(ownerId, slug, 20, cursor, false);
    }

    @Override
    public PagableResponseList<User> getUserListSubscribers(long ownerId, String slug, int count, long cursor) throws TwitterException {
        return this.getUserListSubscribers(ownerId, slug, count, cursor, false);
    }

    @Override
    public PagableResponseList<User> getUserListSubscribers(long ownerId, String slug, int count, long cursor, boolean skipStatus) throws TwitterException {
        return this.factory.createPagableUserList(this.get(this.conf.getRestBaseURL() + "lists/subscribers.json", new HttpParameter("owner_id", ownerId), new HttpParameter("slug", slug), new HttpParameter("count", count), new HttpParameter("cursor", cursor), new HttpParameter("skip_status", skipStatus)));
    }

    @Override
    public PagableResponseList<User> getUserListSubscribers(String ownerScreenName, String slug, long cursor) throws TwitterException {
        return this.getUserListSubscribers(ownerScreenName, slug, 20, cursor, false);
    }

    @Override
    public PagableResponseList<User> getUserListSubscribers(String ownerScreenName, String slug, int count, long cursor) throws TwitterException {
        return this.getUserListSubscribers(ownerScreenName, slug, count, cursor, false);
    }

    @Override
    public PagableResponseList<User> getUserListSubscribers(String ownerScreenName, String slug, int count, long cursor, boolean skipStatus) throws TwitterException {
        return this.factory.createPagableUserList(this.get(this.conf.getRestBaseURL() + "lists/subscribers.json", new HttpParameter("owner_screen_name", ownerScreenName), new HttpParameter("slug", slug), new HttpParameter("count", count), new HttpParameter("cursor", cursor), new HttpParameter("skip_status", skipStatus)));
    }

    @Override
    public UserList createUserListSubscription(long listId) throws TwitterException {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/subscribers/create.json", new HttpParameter("list_id", listId)));
    }

    @Override
    public UserList createUserListSubscription(long ownerId, String slug) throws TwitterException {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/subscribers/create.json", new HttpParameter("owner_id", ownerId), new HttpParameter("slug", slug)));
    }

    @Override
    public UserList createUserListSubscription(String ownerScreenName, String slug) throws TwitterException {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/subscribers/create.json", new HttpParameter("owner_screen_name", ownerScreenName), new HttpParameter("slug", slug)));
    }

    @Override
    public User showUserListSubscription(long listId, long userId) throws TwitterException {
        return this.factory.createUser(this.get(this.conf.getRestBaseURL() + "lists/subscribers/show.json?list_id=" + listId + "&user_id=" + userId));
    }

    @Override
    public User showUserListSubscription(long ownerId, String slug, long userId) throws TwitterException {
        return this.factory.createUser(this.get(this.conf.getRestBaseURL() + "lists/subscribers/show.json?owner_id=" + ownerId + "&slug=" + slug + "&user_id=" + userId));
    }

    @Override
    public User showUserListSubscription(String ownerScreenName, String slug, long userId) throws TwitterException {
        return this.factory.createUser(this.get(this.conf.getRestBaseURL() + "lists/subscribers/show.json", new HttpParameter("owner_screen_name", ownerScreenName), new HttpParameter("slug", slug), new HttpParameter("user_id", userId)));
    }

    @Override
    public UserList destroyUserListSubscription(long listId) throws TwitterException {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/subscribers/destroy.json", new HttpParameter("list_id", listId)));
    }

    @Override
    public UserList destroyUserListSubscription(long ownerId, String slug) throws TwitterException {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/subscribers/destroy.json", new HttpParameter("owner_id", ownerId), new HttpParameter("slug", slug)));
    }

    @Override
    public UserList destroyUserListSubscription(String ownerScreenName, String slug) throws TwitterException {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/subscribers/destroy.json", new HttpParameter("owner_screen_name", ownerScreenName), new HttpParameter("slug", slug)));
    }

    @Override
    public UserList createUserListMembers(long listId, long ... userIds) throws TwitterException {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/members/create_all.json", new HttpParameter("list_id", listId), new HttpParameter("user_id", StringUtil.join(userIds))));
    }

    @Override
    public UserList createUserListMembers(long ownerId, String slug, long ... userIds) throws TwitterException {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/members/create_all.json", new HttpParameter("owner_id", ownerId), new HttpParameter("slug", slug), new HttpParameter("user_id", StringUtil.join(userIds))));
    }

    @Override
    public UserList createUserListMembers(String ownerScreenName, String slug, long ... userIds) throws TwitterException {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/members/create_all.json", new HttpParameter("owner_screen_name", ownerScreenName), new HttpParameter("slug", slug), new HttpParameter("user_id", StringUtil.join(userIds))));
    }

    @Override
    public UserList createUserListMembers(long listId, String ... screenNames) throws TwitterException {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/members/create_all.json", new HttpParameter("list_id", listId), new HttpParameter("screen_name", StringUtil.join(screenNames))));
    }

    @Override
    public UserList createUserListMembers(long ownerId, String slug, String ... screenNames) throws TwitterException {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/members/create_all.json", new HttpParameter("owner_id", ownerId), new HttpParameter("slug", slug), new HttpParameter("screen_name", StringUtil.join(screenNames))));
    }

    @Override
    public UserList createUserListMembers(String ownerScreenName, String slug, String ... screenNames) throws TwitterException {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/members/create_all.json", new HttpParameter("owner_screen_name", ownerScreenName), new HttpParameter("slug", slug), new HttpParameter("screen_name", StringUtil.join(screenNames))));
    }

    @Override
    public User showUserListMembership(long listId, long userId) throws TwitterException {
        return this.factory.createUser(this.get(this.conf.getRestBaseURL() + "lists/members/show.json?list_id=" + listId + "&user_id=" + userId));
    }

    @Override
    public User showUserListMembership(long ownerId, String slug, long userId) throws TwitterException {
        return this.factory.createUser(this.get(this.conf.getRestBaseURL() + "lists/members/show.json?owner_id=" + ownerId + "&slug=" + slug + "&user_id=" + userId));
    }

    @Override
    public User showUserListMembership(String ownerScreenName, String slug, long userId) throws TwitterException {
        return this.factory.createUser(this.get(this.conf.getRestBaseURL() + "lists/members/show.json", new HttpParameter("owner_screen_name", ownerScreenName), new HttpParameter("slug", slug), new HttpParameter("user_id", userId)));
    }

    @Override
    public PagableResponseList<User> getUserListMembers(long listId, long cursor) throws TwitterException {
        return this.getUserListMembers(listId, 20, cursor, false);
    }

    @Override
    public PagableResponseList<User> getUserListMembers(long listId, int count, long cursor) throws TwitterException {
        return this.getUserListMembers(listId, count, cursor, false);
    }

    @Override
    public PagableResponseList<User> getUserListMembers(long listId, int count, long cursor, boolean skipStatus) throws TwitterException {
        return this.factory.createPagableUserList(this.get(this.conf.getRestBaseURL() + "lists/members.json", new HttpParameter("list_id", listId), new HttpParameter("count", count), new HttpParameter("cursor", cursor), new HttpParameter("skip_status", skipStatus)));
    }

    @Override
    public PagableResponseList<User> getUserListMembers(long ownerId, String slug, long cursor) throws TwitterException {
        return this.getUserListMembers(ownerId, slug, 20, cursor, false);
    }

    @Override
    public PagableResponseList<User> getUserListMembers(long ownerId, String slug, int count, long cursor) throws TwitterException {
        return this.getUserListMembers(ownerId, slug, count, cursor, false);
    }

    @Override
    public PagableResponseList<User> getUserListMembers(long ownerId, String slug, int count, long cursor, boolean skipStatus) throws TwitterException {
        return this.factory.createPagableUserList(this.get(this.conf.getRestBaseURL() + "lists/members.json", new HttpParameter("owner_id", ownerId), new HttpParameter("slug", slug), new HttpParameter("count", count), new HttpParameter("cursor", cursor), new HttpParameter("skip_status", skipStatus)));
    }

    @Override
    public PagableResponseList<User> getUserListMembers(String ownerScreenName, String slug, long cursor) throws TwitterException {
        return this.getUserListMembers(ownerScreenName, slug, 20, cursor, false);
    }

    @Override
    public PagableResponseList<User> getUserListMembers(String ownerScreenName, String slug, int count, long cursor) throws TwitterException {
        return this.getUserListMembers(ownerScreenName, slug, count, cursor, false);
    }

    @Override
    public PagableResponseList<User> getUserListMembers(String ownerScreenName, String slug, int count, long cursor, boolean skipStatus) throws TwitterException {
        return this.factory.createPagableUserList(this.get(this.conf.getRestBaseURL() + "lists/members.json", new HttpParameter("owner_screen_name", ownerScreenName), new HttpParameter("slug", slug), new HttpParameter("count", count), new HttpParameter("cursor", cursor), new HttpParameter("skip_status", skipStatus)));
    }

    @Override
    public UserList createUserListMember(long listId, long userId) throws TwitterException {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/members/create.json", new HttpParameter("user_id", userId), new HttpParameter("list_id", listId)));
    }

    @Override
    public UserList createUserListMember(long ownerId, String slug, long userId) throws TwitterException {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/members/create.json", new HttpParameter("user_id", userId), new HttpParameter("owner_id", ownerId), new HttpParameter("slug", slug)));
    }

    @Override
    public UserList createUserListMember(String ownerScreenName, String slug, long userId) throws TwitterException {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/members/create.json", new HttpParameter("user_id", userId), new HttpParameter("owner_screen_name", ownerScreenName), new HttpParameter("slug", slug)));
    }

    @Override
    public UserList destroyUserList(long listId) throws TwitterException {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/destroy.json", new HttpParameter("list_id", listId)));
    }

    @Override
    public UserList destroyUserList(long ownerId, String slug) throws TwitterException {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/destroy.json", new HttpParameter("owner_id", ownerId), new HttpParameter("slug", slug)));
    }

    @Override
    public UserList destroyUserList(String ownerScreenName, String slug) throws TwitterException {
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/destroy.json", new HttpParameter("owner_screen_name", ownerScreenName), new HttpParameter("slug", slug)));
    }

    @Override
    public UserList updateUserList(long listId, String newListName, boolean isPublicList, String newDescription) throws TwitterException {
        return this.updateUserList(newListName, isPublicList, newDescription, new HttpParameter("list_id", listId));
    }

    @Override
    public UserList updateUserList(long ownerId, String slug, String newListName, boolean isPublicList, String newDescription) throws TwitterException {
        return this.updateUserList(newListName, isPublicList, newDescription, new HttpParameter("owner_id", ownerId), new HttpParameter("slug", slug));
    }

    @Override
    public UserList updateUserList(String ownerScreenName, String slug, String newListName, boolean isPublicList, String newDescription) throws TwitterException {
        return this.updateUserList(newListName, isPublicList, newDescription, new HttpParameter("owner_screen_name", ownerScreenName), new HttpParameter("slug", slug));
    }

    private UserList updateUserList(String newListName, boolean isPublicList, String newDescription, HttpParameter ... params) throws TwitterException {
        ArrayList<HttpParameter> httpParams = new ArrayList<HttpParameter>();
        Collections.addAll(httpParams, params);
        if (newListName != null) {
            httpParams.add(new HttpParameter("name", newListName));
        }
        httpParams.add(new HttpParameter("mode", isPublicList ? "public" : "private"));
        if (newDescription != null) {
            httpParams.add(new HttpParameter("description", newDescription));
        }
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/update.json", httpParams.toArray(new HttpParameter[httpParams.size()])));
    }

    @Override
    public UserList createUserList(String listName, boolean isPublicList, String description) throws TwitterException {
        ArrayList<HttpParameter> httpParams = new ArrayList<HttpParameter>();
        httpParams.add(new HttpParameter("name", listName));
        httpParams.add(new HttpParameter("mode", isPublicList ? "public" : "private"));
        if (description != null) {
            httpParams.add(new HttpParameter("description", description));
        }
        return this.factory.createAUserList(this.post(this.conf.getRestBaseURL() + "lists/create.json", httpParams.toArray(new HttpParameter[httpParams.size()])));
    }

    @Override
    public UserList showUserList(long listId) throws TwitterException {
        return this.factory.createAUserList(this.get(this.conf.getRestBaseURL() + "lists/show.json?list_id=" + listId));
    }

    @Override
    public UserList showUserList(long ownerId, String slug) throws TwitterException {
        return this.factory.createAUserList(this.get(this.conf.getRestBaseURL() + "lists/show.json?owner_id=" + ownerId + "&slug=" + slug));
    }

    @Override
    public UserList showUserList(String ownerScreenName, String slug) throws TwitterException {
        return this.factory.createAUserList(this.get(this.conf.getRestBaseURL() + "lists/show.json", new HttpParameter("owner_screen_name", ownerScreenName), new HttpParameter("slug", slug)));
    }

    @Override
    public PagableResponseList<UserList> getUserListSubscriptions(String listSubscriberScreenName, long cursor) throws TwitterException {
        return this.getUserListSubscriptions(listSubscriberScreenName, 20, cursor);
    }

    @Override
    public PagableResponseList<UserList> getUserListSubscriptions(String listSubscriberScreenName, int count, long cursor) throws TwitterException {
        return this.factory.createPagableUserListList(this.get(this.conf.getRestBaseURL() + "lists/subscriptions.json", new HttpParameter("screen_name", listSubscriberScreenName), new HttpParameter("count", count), new HttpParameter("cursor", cursor)));
    }

    @Override
    public PagableResponseList<UserList> getUserListSubscriptions(long listSubscriberId, long cursor) throws TwitterException {
        return this.getUserListSubscriptions(listSubscriberId, 20, cursor);
    }

    @Override
    public PagableResponseList<UserList> getUserListSubscriptions(long listSubscriberId, int count, long cursor) throws TwitterException {
        return this.factory.createPagableUserListList(this.get(this.conf.getRestBaseURL() + "lists/subscriptions.json", new HttpParameter("user_id", listSubscriberId), new HttpParameter("count", count), new HttpParameter("cursor", cursor)));
    }

    @Override
    public PagableResponseList<UserList> getUserListsOwnerships(String listOwnerScreenName, long cursor) throws TwitterException {
        return this.getUserListsOwnerships(listOwnerScreenName, 20, cursor);
    }

    @Override
    public PagableResponseList<UserList> getUserListsOwnerships(String listOwnerScreenName, int count, long cursor) throws TwitterException {
        return this.factory.createPagableUserListList(this.get(this.conf.getRestBaseURL() + "lists/ownerships.json", new HttpParameter("screen_name", listOwnerScreenName), new HttpParameter("count", count), new HttpParameter("cursor", cursor)));
    }

    @Override
    public PagableResponseList<UserList> getUserListsOwnerships(long listOwnerId, long cursor) throws TwitterException {
        return this.getUserListsOwnerships(listOwnerId, 20, cursor);
    }

    @Override
    public PagableResponseList<UserList> getUserListsOwnerships(long listOwnerId, int count, long cursor) throws TwitterException {
        return this.factory.createPagableUserListList(this.get(this.conf.getRestBaseURL() + "lists/ownerships.json", new HttpParameter("user_id", listOwnerId), new HttpParameter("count", count), new HttpParameter("cursor", cursor)));
    }

    @Override
    public ResponseList<SavedSearch> getSavedSearches() throws TwitterException {
        return this.factory.createSavedSearchList(this.get(this.conf.getRestBaseURL() + "saved_searches/list.json"));
    }

    @Override
    public SavedSearch showSavedSearch(long id) throws TwitterException {
        return this.factory.createSavedSearch(this.get(this.conf.getRestBaseURL() + "saved_searches/show/" + id + ".json"));
    }

    @Override
    public SavedSearch createSavedSearch(String query) throws TwitterException {
        return this.factory.createSavedSearch(this.post(this.conf.getRestBaseURL() + "saved_searches/create.json", new HttpParameter("query", query)));
    }

    @Override
    public SavedSearch destroySavedSearch(long id) throws TwitterException {
        return this.factory.createSavedSearch(this.post(this.conf.getRestBaseURL() + "saved_searches/destroy/" + id + ".json"));
    }

    @Override
    public Place getGeoDetails(String placeId) throws TwitterException {
        return this.factory.createPlace(this.get(this.conf.getRestBaseURL() + "geo/id/" + placeId + ".json"));
    }

    @Override
    public ResponseList<Place> reverseGeoCode(GeoQuery query) throws TwitterException {
        try {
            return this.factory.createPlaceList(this.get(this.conf.getRestBaseURL() + "geo/reverse_geocode.json", query.asHttpParameterArray()));
        }
        catch (TwitterException te) {
            if (te.getStatusCode() == 404) {
                return this.factory.createEmptyResponseList();
            }
            throw te;
        }
    }

    @Override
    public ResponseList<Place> searchPlaces(GeoQuery query) throws TwitterException {
        return this.factory.createPlaceList(this.get(this.conf.getRestBaseURL() + "geo/search.json", query.asHttpParameterArray()));
    }

    @Override
    public ResponseList<Place> getSimilarPlaces(GeoLocation location, String name, String containedWithin, String streetAddress) throws TwitterException {
        ArrayList<HttpParameter> params = new ArrayList<HttpParameter>(3);
        params.add(new HttpParameter("lat", location.getLatitude()));
        params.add(new HttpParameter("long", location.getLongitude()));
        params.add(new HttpParameter("name", name));
        if (containedWithin != null) {
            params.add(new HttpParameter("contained_within", containedWithin));
        }
        if (streetAddress != null) {
            params.add(new HttpParameter("attribute:street_address", streetAddress));
        }
        return this.factory.createPlaceList(this.get(this.conf.getRestBaseURL() + "geo/similar_places.json", params.toArray(new HttpParameter[params.size()])));
    }

    @Override
    public Trends getPlaceTrends(int woeid) throws TwitterException {
        return this.factory.createTrends(this.get(this.conf.getRestBaseURL() + "trends/place.json?id=" + woeid));
    }

    @Override
    public ResponseList<Location> getAvailableTrends() throws TwitterException {
        return this.factory.createLocationList(this.get(this.conf.getRestBaseURL() + "trends/available.json"));
    }

    @Override
    public ResponseList<Location> getClosestTrends(GeoLocation location) throws TwitterException {
        return this.factory.createLocationList(this.get(this.conf.getRestBaseURL() + "trends/closest.json", new HttpParameter("lat", location.getLatitude()), new HttpParameter("long", location.getLongitude())));
    }

    @Override
    public User reportSpam(long userId) throws TwitterException {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "users/report_spam.json?user_id=" + userId));
    }

    @Override
    public User reportSpam(String screenName) throws TwitterException {
        return this.factory.createUser(this.post(this.conf.getRestBaseURL() + "users/report_spam.json", new HttpParameter("screen_name", screenName)));
    }

    @Override
    public TwitterAPIConfiguration getAPIConfiguration() throws TwitterException {
        return this.factory.createTwitterAPIConfiguration(this.get(this.conf.getRestBaseURL() + "help/configuration.json"));
    }

    @Override
    public ResponseList<HelpResources.Language> getLanguages() throws TwitterException {
        return this.factory.createLanguageList(this.get(this.conf.getRestBaseURL() + "help/languages.json"));
    }

    @Override
    public String getPrivacyPolicy() throws TwitterException {
        try {
            return this.get(this.conf.getRestBaseURL() + "help/privacy.json").asJSONObject().getString("privacy");
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    @Override
    public String getTermsOfService() throws TwitterException {
        try {
            return this.get(this.conf.getRestBaseURL() + "help/tos.json").asJSONObject().getString("tos");
        }
        catch (JSONException e) {
            throw new TwitterException(e);
        }
    }

    @Override
    public Map<String, RateLimitStatus> getRateLimitStatus() throws TwitterException {
        return this.factory.createRateLimitStatuses(this.get(this.conf.getRestBaseURL() + "application/rate_limit_status.json"));
    }

    @Override
    public Map<String, RateLimitStatus> getRateLimitStatus(String ... resources) throws TwitterException {
        return this.factory.createRateLimitStatuses(this.get(this.conf.getRestBaseURL() + "application/rate_limit_status.json?resources=" + StringUtil.join(resources)));
    }

    @Override
    public TimelinesResources timelines() {
        return this;
    }

    @Override
    public TweetsResources tweets() {
        return this;
    }

    @Override
    public SearchResource search() {
        return this;
    }

    @Override
    public DirectMessagesResources directMessages() {
        return this;
    }

    @Override
    public FriendsFollowersResources friendsFollowers() {
        return this;
    }

    @Override
    public UsersResources users() {
        return this;
    }

    @Override
    public SuggestedUsersResources suggestedUsers() {
        return this;
    }

    @Override
    public FavoritesResources favorites() {
        return this;
    }

    @Override
    public ListsResources list() {
        return this;
    }

    @Override
    public SavedSearchesResources savedSearches() {
        return this;
    }

    @Override
    public PlacesGeoResources placesGeo() {
        return this;
    }

    @Override
    public TrendsResources trends() {
        return this;
    }

    @Override
    public SpamReportingResource spamReporting() {
        return this;
    }

    @Override
    public HelpResources help() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse get(String url) throws TwitterException {
        this.ensureAuthorizationEnabled();
        if (this.IMPLICIT_PARAMS_STR.length() > 0) {
            url = url.contains("?") ? url + "&" + this.IMPLICIT_PARAMS_STR : url + "?" + this.IMPLICIT_PARAMS_STR;
        }
        if (!this.conf.isMBeanEnabled()) {
            return this.http.get(url, null, this.auth, this);
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            response = this.http.get(url, null, this.auth, this);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - start;
            TwitterAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse get(String url, HttpParameter ... params) throws TwitterException {
        this.ensureAuthorizationEnabled();
        if (!this.conf.isMBeanEnabled()) {
            return this.http.get(url, this.mergeImplicitParams(params), this.auth, this);
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            response = this.http.get(url, this.mergeImplicitParams(params), this.auth, this);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - start;
            TwitterAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse post(String url) throws TwitterException {
        this.ensureAuthorizationEnabled();
        if (!this.conf.isMBeanEnabled()) {
            return this.http.post(url, this.IMPLICIT_PARAMS, this.auth, this);
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            response = this.http.post(url, this.IMPLICIT_PARAMS, this.auth, this);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - start;
            TwitterAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse post(String url, HttpParameter ... params) throws TwitterException {
        this.ensureAuthorizationEnabled();
        if (!this.conf.isMBeanEnabled()) {
            return this.http.post(url, this.mergeImplicitParams(params), this.auth, this);
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            response = this.http.post(url, this.mergeImplicitParams(params), this.auth, this);
        }
        finally {
            long elapsedTime = System.currentTimeMillis() - start;
            TwitterAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpResponse post(String url, JSONObject json) throws TwitterException {
        this.ensureAuthorizationEnabled();
        if (!this.conf.isMBeanEnabled()) {
            return this.http.post(url, new HttpParameter[]{new HttpParameter(json)}, this.auth, this);
        }
        HttpResponse response = null;
        long start = System.currentTimeMillis();
        try {
            response = this.http.post(url, new HttpParameter[]{new HttpParameter(json)}, this.auth, this);
        }
        catch (Throwable throwable) {
            long elapsedTime = System.currentTimeMillis() - start;
            TwitterAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
            throw throwable;
        }
        long elapsedTime = System.currentTimeMillis() - start;
        TwitterAPIMonitor.getInstance().methodCalled(url, elapsedTime, this.isOk(response));
        return response;
    }

    private HttpParameter[] mergeParameters(HttpParameter[] params1, HttpParameter[] params2) {
        if (params1 != null && params2 != null) {
            HttpParameter[] params = new HttpParameter[params1.length + params2.length];
            System.arraycopy(params1, 0, params, 0, params1.length);
            System.arraycopy(params2, 0, params, params1.length, params2.length);
            return params;
        }
        if (null == params1 && null == params2) {
            return new HttpParameter[0];
        }
        if (params1 != null) {
            return params1;
        }
        return params2;
    }

    private HttpParameter[] mergeParameters(HttpParameter[] params1, HttpParameter params2) {
        if (params1 != null && params2 != null) {
            HttpParameter[] params = new HttpParameter[params1.length + 1];
            System.arraycopy(params1, 0, params, 0, params1.length);
            params[params.length - 1] = params2;
            return params;
        }
        if (null == params1 && null == params2) {
            return new HttpParameter[0];
        }
        if (params1 != null) {
            return params1;
        }
        return new HttpParameter[]{params2};
    }

    private HttpParameter[] mergeImplicitParams(HttpParameter ... params) {
        return this.mergeParameters(params, this.IMPLICIT_PARAMS);
    }

    private boolean isOk(HttpResponse response) {
        return response != null && response.getStatusCode() < 300;
    }

    @Override
    public String toString() {
        return "TwitterImpl{INCLUDE_MY_RETWEET=" + this.INCLUDE_MY_RETWEET + '}';
    }
}

