/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter.directmessage;

import org.apache.camel.Category;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.twitter.AbstractTwitterEndpoint;
import org.apache.camel.component.twitter.TwitterConfiguration;
import org.apache.camel.component.twitter.TwitterHelper;
import org.apache.camel.component.twitter.directmessage.DirectMessageConsumerHandler;
import org.apache.camel.component.twitter.directmessage.DirectMessageProducer;
import org.apache.camel.component.twitter.directmessage.TwitterDirectMessageComponent;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriPath;

@UriEndpoint(firstVersion="2.10.0", scheme="twitter-directmessage", title="Twitter Direct Message", syntax="twitter-directmessage:user", category={Category.CLOUD, Category.API, Category.SOCIAL, Category.CHAT})
public class TwitterDirectMessageEndpoint
extends AbstractTwitterEndpoint {
    @UriPath(description="The user name to send a direct message. This will be ignored for consumer.")
    @Metadata(required=true)
    private String user;

    public TwitterDirectMessageEndpoint(String uri, String remaining, TwitterDirectMessageComponent component, TwitterConfiguration properties) {
        super(uri, component, properties);
        this.user = remaining;
    }

    public Producer createProducer() throws Exception {
        return new DirectMessageProducer(this, this.user);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return TwitterHelper.createConsumer(processor, this, new DirectMessageConsumerHandler(this));
    }
}

