/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter.search;

import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.camel.spi.EndpointUriFactory;
import org.apache.camel.support.component.EndpointUriFactorySupport;

public class TwitterSearchEndpointUriFactory
extends EndpointUriFactorySupport
implements EndpointUriFactory {
    private static final String BASE = ":keywords";
    private static final Set<String> PROPERTY_NAMES;
    private static final Set<String> SECRET_PROPERTY_NAMES;

    public boolean isEnabled(String scheme) {
        return "twitter-search".equals(scheme);
    }

    public String buildUri(String scheme, Map<String, Object> properties) throws URISyntaxException {
        String syntax;
        String uri = syntax = scheme + BASE;
        HashMap<String, Object> copy = new HashMap<String, Object>(properties);
        uri = this.buildPathParameter(syntax, uri, "keywords", null, true, copy);
        uri = this.buildQueryParameters(uri, copy);
        return uri;
    }

    public Set<String> propertyNames() {
        return PROPERTY_NAMES;
    }

    public Set<String> secretPropertyNames() {
        return SECRET_PROPERTY_NAMES;
    }

    public boolean isLenientProperties() {
        return false;
    }

    static {
        HashSet<String> props = new HashSet<String>(45);
        props.add("basicPropertyBinding");
        props.add("backoffMultiplier");
        props.add("keywords");
        props.add("synchronous");
        props.add("latitude");
        props.add("httpProxyHost");
        props.add("initialDelay");
        props.add("type");
        props.add("scheduler");
        props.add("consumerSecret");
        props.add("bridgeErrorHandler");
        props.add("useFixedDelay");
        props.add("numberOfPages");
        props.add("runLoggingLevel");
        props.add("sortById");
        props.add("backoffErrorThreshold");
        props.add("userIds");
        props.add("greedy");
        props.add("distanceMetric");
        props.add("radius");
        props.add("lang");
        props.add("scheduledExecutorService");
        props.add("consumerKey");
        props.add("longitude");
        props.add("repeatCount");
        props.add("timeUnit");
        props.add("sinceId");
        props.add("sendEmptyMessageWhenIdle");
        props.add("schedulerProperties");
        props.add("exchangePattern");
        props.add("count");
        props.add("httpProxyPort");
        props.add("accessToken");
        props.add("httpProxyPassword");
        props.add("backoffIdleThreshold");
        props.add("accessTokenSecret");
        props.add("lazyStartProducer");
        props.add("delay");
        props.add("pollStrategy");
        props.add("startScheduler");
        props.add("filterOld");
        props.add("locations");
        props.add("extendedMode");
        props.add("exceptionHandler");
        props.add("httpProxyUser");
        PROPERTY_NAMES = Collections.unmodifiableSet(props);
        HashSet<String> secretProps = new HashSet<String>(4);
        secretProps.add("consumerSecret");
        secretProps.add("accessToken");
        secretProps.add("consumerKey");
        secretProps.add("accessTokenSecret");
        SECRET_PROPERTY_NAMES = Collections.unmodifiableSet(secretProps);
    }
}

