/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter.timeline;

import java.util.List;
import org.apache.camel.component.twitter.TwitterEndpoint;
import org.apache.camel.component.twitter.timeline.AbstractStatusConsumerHandler;
import twitter4j.Paging;
import twitter4j.Status;
import twitter4j.TwitterException;

public class UserListConsumerHandler
extends AbstractStatusConsumerHandler {
    private final String user;
    private final String list;

    public UserListConsumerHandler(TwitterEndpoint endpoint, String user, String list) {
        super(endpoint);
        this.user = user;
        this.list = list;
    }

    @Override
    protected List<Status> doPoll() throws TwitterException {
        Paging paging = this.getLastIdPaging();
        this.log.trace("doPoll.getUserListStatuses(user={}, list={}, sinceId={})", new Object[]{this.user, this.list, paging.getSinceId()});
        return this.getTwitter().getUserListStatuses(this.user, this.list, paging);
    }

    @Override
    protected List<Status> doDirect() throws TwitterException {
        Paging paging = new Paging(this.getLastId());
        return this.getTwitter().getUserListStatuses(this.user, this.list, paging);
    }
}

