/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.twitter.search;

import org.apache.camel.Category;
import org.apache.camel.Consumer;
import org.apache.camel.Processor;
import org.apache.camel.Producer;
import org.apache.camel.component.twitter.AbstractTwitterEndpoint;
import org.apache.camel.component.twitter.TwitterConfiguration;
import org.apache.camel.component.twitter.TwitterHelper;
import org.apache.camel.component.twitter.search.SearchConsumerHandler;
import org.apache.camel.component.twitter.search.SearchProducer;
import org.apache.camel.component.twitter.search.TwitterSearchComponent;
import org.apache.camel.spi.Metadata;
import org.apache.camel.spi.UriEndpoint;
import org.apache.camel.spi.UriPath;

@UriEndpoint(firstVersion="2.10.0", scheme="twitter-search", title="Twitter Search", syntax="twitter-search:keywords", category={Category.CLOUD, Category.API, Category.SEARCH, Category.SOCIAL})
public class TwitterSearchEndpoint
extends AbstractTwitterEndpoint {
    @UriPath(description="The search query, use the keywords AND, OR, - and () to narrow the search results.")
    @Metadata(required=true)
    private String keywords;

    public TwitterSearchEndpoint(String uri, String remaining, TwitterSearchComponent component, TwitterConfiguration properties) {
        super(uri, component, properties);
        this.keywords = remaining;
    }

    public Producer createProducer() throws Exception {
        return new SearchProducer(this, this.keywords);
    }

    public Consumer createConsumer(Processor processor) throws Exception {
        return TwitterHelper.createConsumer(processor, this, new SearchConsumerHandler(this, this.keywords));
    }

    public String getKeywords() {
        return this.keywords;
    }
}

