/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.twiml.voice;

import com.twilio.converter.Promoter;
import com.twilio.http.HttpMethod;
import com.twilio.twiml.TwiML;
import com.twilio.twiml.voice.ReferSip;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class Refer
extends TwiML {
    private final URI action;
    private final HttpMethod method;

    private Refer() {
        this(new Builder());
    }

    private Refer(Builder b) {
        super("Refer", b);
        this.action = b.action;
        this.method = b.method;
    }

    @Override
    protected Map<String, String> getElementAttributes() {
        HashMap<String, String> attrs = new HashMap<String, String>();
        if (this.getAction() != null) {
            attrs.put("action", this.getAction().toString());
        }
        if (this.getMethod() != null) {
            attrs.put("method", this.getMethod().toString());
        }
        return attrs;
    }

    public URI getAction() {
        return this.action;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public static class Builder
    extends TwiML.Builder<Builder> {
        private URI action;
        private HttpMethod method;

        public Builder action(URI action) {
            this.action = action;
            return this;
        }

        public Builder action(String action) {
            this.action = Promoter.uriFromString(action);
            return this;
        }

        public Builder method(HttpMethod method) {
            this.method = method;
            return this;
        }

        public Builder sip(ReferSip referSip) {
            this.children.add(referSip);
            return this;
        }

        @Deprecated
        public Builder referSip(ReferSip referSip) {
            return this.sip(referSip);
        }

        public Refer build() {
            return new Refer(this);
        }
    }
}

