/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.sync.v1.service;

import com.twilio.base.Creator;
import com.twilio.converter.Converter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.sync.v1.service.Document;
import java.util.Map;

public class DocumentCreator
extends Creator<Document> {
    private final String pathServiceSid;
    private String uniqueName;
    private Map<String, Object> data;
    private Integer ttl;

    public DocumentCreator(String pathServiceSid) {
        this.pathServiceSid = pathServiceSid;
    }

    public DocumentCreator setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
        return this;
    }

    public DocumentCreator setData(Map<String, Object> data) {
        this.data = data;
        return this;
    }

    public DocumentCreator setTtl(Integer ttl) {
        this.ttl = ttl;
        return this;
    }

    @Override
    public Document create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.SYNC.toString(), "/v1/Services/" + this.pathServiceSid + "/Documents");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Document creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Document.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.uniqueName != null) {
            request.addPostParam("UniqueName", this.uniqueName);
        }
        if (this.data != null) {
            request.addPostParam("Data", Converter.mapToJson(this.data));
        }
        if (this.ttl != null) {
            request.addPostParam("Ttl", this.ttl.toString());
        }
    }
}

