/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.supersim.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.supersim.v1.UsageRecordReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class UsageRecord
extends Resource {
    private static final long serialVersionUID = 259624164977521L;
    private final String accountSid;
    private final String simSid;
    private final String networkSid;
    private final String fleetSid;
    private final String isoCountry;
    private final Map<String, Object> period;
    private final Long dataUpload;
    private final Long dataDownload;
    private final Long dataTotal;

    public static UsageRecordReader reader() {
        return new UsageRecordReader();
    }

    public static UsageRecord fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (UsageRecord)objectMapper.readValue(json, UsageRecord.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static UsageRecord fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (UsageRecord)objectMapper.readValue(json, UsageRecord.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private UsageRecord(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="sim_sid") String simSid, @JsonProperty(value="network_sid") String networkSid, @JsonProperty(value="fleet_sid") String fleetSid, @JsonProperty(value="iso_country") String isoCountry, @JsonProperty(value="period") Map<String, Object> period, @JsonProperty(value="data_upload") Long dataUpload, @JsonProperty(value="data_download") Long dataDownload, @JsonProperty(value="data_total") Long dataTotal) {
        this.accountSid = accountSid;
        this.simSid = simSid;
        this.networkSid = networkSid;
        this.fleetSid = fleetSid;
        this.isoCountry = isoCountry;
        this.period = period;
        this.dataUpload = dataUpload;
        this.dataDownload = dataDownload;
        this.dataTotal = dataTotal;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getSimSid() {
        return this.simSid;
    }

    public final String getNetworkSid() {
        return this.networkSid;
    }

    public final String getFleetSid() {
        return this.fleetSid;
    }

    public final String getIsoCountry() {
        return this.isoCountry;
    }

    public final Map<String, Object> getPeriod() {
        return this.period;
    }

    public final Long getDataUpload() {
        return this.dataUpload;
    }

    public final Long getDataDownload() {
        return this.dataDownload;
    }

    public final Long getDataTotal() {
        return this.dataTotal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsageRecord other = (UsageRecord)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.simSid, other.simSid) && Objects.equals(this.networkSid, other.networkSid) && Objects.equals(this.fleetSid, other.fleetSid) && Objects.equals(this.isoCountry, other.isoCountry) && Objects.equals(this.period, other.period) && Objects.equals(this.dataUpload, other.dataUpload) && Objects.equals(this.dataDownload, other.dataDownload) && Objects.equals(this.dataTotal, other.dataTotal);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.simSid, this.networkSid, this.fleetSid, this.isoCountry, this.period, this.dataUpload, this.dataDownload, this.dataTotal);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("simSid", (Object)this.simSid).add("networkSid", (Object)this.networkSid).add("fleetSid", (Object)this.fleetSid).add("isoCountry", (Object)this.isoCountry).add("period", this.period).add("dataUpload", (Object)this.dataUpload).add("dataDownload", (Object)this.dataDownload).add("dataTotal", (Object)this.dataTotal).toString();
    }

    public static enum SortBy {
        TIME("time");

        private final String value;

        private SortBy(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static SortBy forValue(String value) {
            return (SortBy)Promoter.enumFromString((String)value, (Enum[])SortBy.values());
        }
    }

    public static enum Group {
        SIM("sim"),
        FLEET("fleet"),
        NETWORK("network"),
        ISOCOUNTRY("isoCountry");

        private final String value;

        private Group(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Group forValue(String value) {
            return (Group)Promoter.enumFromString((String)value, (Enum[])Group.values());
        }
    }

    public static enum Granularity {
        HOUR("hour"),
        DAY("day"),
        ALL("all");

        private final String value;

        private Granularity(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonCreator
        public static Granularity forValue(String value) {
            return (Granularity)Promoter.enumFromString((String)value, (Enum[])Granularity.values());
        }
    }
}

