/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.supersim.v1;

import com.twilio.base.Updater;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.supersim.v1.NetworkAccessProfile;

public class NetworkAccessProfileUpdater
extends Updater<NetworkAccessProfile> {
    private final String pathSid;
    private String uniqueName;

    public NetworkAccessProfileUpdater(String pathSid) {
        this.pathSid = pathSid;
    }

    public NetworkAccessProfileUpdater setUniqueName(String uniqueName) {
        this.uniqueName = uniqueName;
        return this;
    }

    @Override
    public NetworkAccessProfile update(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.SUPERSIM.toString(), "/v1/NetworkAccessProfiles/" + this.pathSid + "");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("NetworkAccessProfile update failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return NetworkAccessProfile.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.uniqueName != null) {
            request.addPostParam("UniqueName", this.uniqueName);
        }
    }
}

