/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.supersim.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.supersim.v1.NetworkAccessProfileCreator;
import com.twilio.rest.supersim.v1.NetworkAccessProfileFetcher;
import com.twilio.rest.supersim.v1.NetworkAccessProfileReader;
import com.twilio.rest.supersim.v1.NetworkAccessProfileUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class NetworkAccessProfile
extends Resource {
    private static final long serialVersionUID = 248233981028647L;
    private final String sid;
    private final String uniqueName;
    private final String accountSid;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final URI url;
    private final Map<String, String> links;

    public static NetworkAccessProfileCreator creator() {
        return new NetworkAccessProfileCreator();
    }

    public static NetworkAccessProfileFetcher fetcher(String pathSid) {
        return new NetworkAccessProfileFetcher(pathSid);
    }

    public static NetworkAccessProfileUpdater updater(String pathSid) {
        return new NetworkAccessProfileUpdater(pathSid);
    }

    public static NetworkAccessProfileReader reader() {
        return new NetworkAccessProfileReader();
    }

    public static NetworkAccessProfile fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (NetworkAccessProfile)objectMapper.readValue(json, NetworkAccessProfile.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static NetworkAccessProfile fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (NetworkAccessProfile)objectMapper.readValue(json, NetworkAccessProfile.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private NetworkAccessProfile(@JsonProperty(value="sid") String sid, @JsonProperty(value="unique_name") String uniqueName, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links) {
        this.sid = sid;
        this.uniqueName = uniqueName;
        this.accountSid = accountSid;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
        this.links = links;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getUniqueName() {
        return this.uniqueName;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkAccessProfile other = (NetworkAccessProfile)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.uniqueName, other.uniqueName) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.uniqueName, this.accountSid, this.dateCreated, this.dateUpdated, this.url, this.links);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sid", (Object)this.sid).add("uniqueName", (Object)this.uniqueName).add("accountSid", (Object)this.accountSid).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("url", (Object)this.url).add("links", this.links).toString();
    }
}

