/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.supersim.v1;

import com.twilio.base.Creator;
import com.twilio.converter.Promoter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.supersim.v1.Command;
import java.net.URI;

public class CommandCreator
extends Creator<Command> {
    private final String sim;
    private final String command;
    private HttpMethod callbackMethod;
    private URI callbackUrl;

    public CommandCreator(String sim, String command) {
        this.sim = sim;
        this.command = command;
    }

    public CommandCreator setCallbackMethod(HttpMethod callbackMethod) {
        this.callbackMethod = callbackMethod;
        return this;
    }

    public CommandCreator setCallbackUrl(URI callbackUrl) {
        this.callbackUrl = callbackUrl;
        return this;
    }

    public CommandCreator setCallbackUrl(String callbackUrl) {
        return this.setCallbackUrl(Promoter.uriFromString(callbackUrl));
    }

    @Override
    public Command create(TwilioRestClient client) {
        Request request = new Request(HttpMethod.POST, Domains.SUPERSIM.toString(), "/v1/Commands");
        this.addPostParams(request);
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Command creation failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Command.fromJson(response.getStream(), client.getObjectMapper());
    }

    private void addPostParams(Request request) {
        if (this.sim != null) {
            request.addPostParam("Sim", this.sim);
        }
        if (this.command != null) {
            request.addPostParam("Command", this.command);
        }
        if (this.callbackMethod != null) {
            request.addPostParam("CallbackMethod", this.callbackMethod.toString());
        }
        if (this.callbackUrl != null) {
            request.addPostParam("CallbackUrl", this.callbackUrl.toString());
        }
    }
}

