/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.trustedComms.business;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.preview.trustedComms.business.BrandFetcher;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Brand
extends Resource {
    private static final long serialVersionUID = 256617740893131L;
    private final String accountSid;
    private final String businessSid;
    private final String sid;
    private final Map<String, String> links;
    private final URI url;

    public static BrandFetcher fetcher(String pathBusinessSid, String pathSid) {
        return new BrandFetcher(pathBusinessSid, pathSid);
    }

    public static Brand fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (Brand)objectMapper.readValue(json, Brand.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static Brand fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (Brand)objectMapper.readValue(json, Brand.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private Brand(@JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="business_sid") String businessSid, @JsonProperty(value="sid") String sid, @JsonProperty(value="links") Map<String, String> links, @JsonProperty(value="url") URI url) {
        this.accountSid = accountSid;
        this.businessSid = businessSid;
        this.sid = sid;
        this.links = links;
        this.url = url;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getBusinessSid() {
        return this.businessSid;
    }

    public final String getSid() {
        return this.sid;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public final URI getUrl() {
        return this.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Brand other = (Brand)o;
        return Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.businessSid, other.businessSid) && Objects.equals(this.sid, other.sid) && Objects.equals(this.links, other.links) && Objects.equals(this.url, other.url);
    }

    public int hashCode() {
        return Objects.hash(this.accountSid, this.businessSid, this.sid, this.links, this.url);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("accountSid", (Object)this.accountSid).add("businessSid", (Object)this.businessSid).add("sid", (Object)this.sid).add("links", this.links).add("url", (Object)this.url).toString();
    }
}

