/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.marketplace;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.MoreObjects;
import com.twilio.base.Resource;
import com.twilio.converter.DateConverter;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.rest.preview.marketplace.InstalledAddOnCreator;
import com.twilio.rest.preview.marketplace.InstalledAddOnDeleter;
import com.twilio.rest.preview.marketplace.InstalledAddOnFetcher;
import com.twilio.rest.preview.marketplace.InstalledAddOnReader;
import com.twilio.rest.preview.marketplace.InstalledAddOnUpdater;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.joda.time.DateTime;

@JsonIgnoreProperties(ignoreUnknown=true)
public class InstalledAddOn
extends Resource {
    private static final long serialVersionUID = 59619174394820L;
    private final String sid;
    private final String accountSid;
    private final String friendlyName;
    private final String description;
    private final Map<String, Object> configuration;
    private final String uniqueName;
    private final DateTime dateCreated;
    private final DateTime dateUpdated;
    private final URI url;
    private final Map<String, String> links;

    public static InstalledAddOnCreator creator(String availableAddOnSid, Boolean acceptTermsOfService) {
        return new InstalledAddOnCreator(availableAddOnSid, acceptTermsOfService);
    }

    public static InstalledAddOnDeleter deleter(String pathSid) {
        return new InstalledAddOnDeleter(pathSid);
    }

    public static InstalledAddOnFetcher fetcher(String pathSid) {
        return new InstalledAddOnFetcher(pathSid);
    }

    public static InstalledAddOnUpdater updater(String pathSid) {
        return new InstalledAddOnUpdater(pathSid);
    }

    public static InstalledAddOnReader reader() {
        return new InstalledAddOnReader();
    }

    public static InstalledAddOn fromJson(String json, ObjectMapper objectMapper) {
        try {
            return (InstalledAddOn)objectMapper.readValue(json, InstalledAddOn.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    public static InstalledAddOn fromJson(InputStream json, ObjectMapper objectMapper) {
        try {
            return (InstalledAddOn)objectMapper.readValue(json, InstalledAddOn.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            throw new ApiException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new ApiConnectionException(e.getMessage(), e);
        }
    }

    @JsonCreator
    private InstalledAddOn(@JsonProperty(value="sid") String sid, @JsonProperty(value="account_sid") String accountSid, @JsonProperty(value="friendly_name") String friendlyName, @JsonProperty(value="description") String description, @JsonProperty(value="configuration") Map<String, Object> configuration, @JsonProperty(value="unique_name") String uniqueName, @JsonProperty(value="date_created") String dateCreated, @JsonProperty(value="date_updated") String dateUpdated, @JsonProperty(value="url") URI url, @JsonProperty(value="links") Map<String, String> links) {
        this.sid = sid;
        this.accountSid = accountSid;
        this.friendlyName = friendlyName;
        this.description = description;
        this.configuration = configuration;
        this.uniqueName = uniqueName;
        this.dateCreated = DateConverter.iso8601DateTimeFromString(dateCreated);
        this.dateUpdated = DateConverter.iso8601DateTimeFromString(dateUpdated);
        this.url = url;
        this.links = links;
    }

    public final String getSid() {
        return this.sid;
    }

    public final String getAccountSid() {
        return this.accountSid;
    }

    public final String getFriendlyName() {
        return this.friendlyName;
    }

    public final String getDescription() {
        return this.description;
    }

    public final Map<String, Object> getConfiguration() {
        return this.configuration;
    }

    public final String getUniqueName() {
        return this.uniqueName;
    }

    public final DateTime getDateCreated() {
        return this.dateCreated;
    }

    public final DateTime getDateUpdated() {
        return this.dateUpdated;
    }

    public final URI getUrl() {
        return this.url;
    }

    public final Map<String, String> getLinks() {
        return this.links;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstalledAddOn other = (InstalledAddOn)o;
        return Objects.equals(this.sid, other.sid) && Objects.equals(this.accountSid, other.accountSid) && Objects.equals(this.friendlyName, other.friendlyName) && Objects.equals(this.description, other.description) && Objects.equals(this.configuration, other.configuration) && Objects.equals(this.uniqueName, other.uniqueName) && Objects.equals(this.dateCreated, other.dateCreated) && Objects.equals(this.dateUpdated, other.dateUpdated) && Objects.equals(this.url, other.url) && Objects.equals(this.links, other.links);
    }

    public int hashCode() {
        return Objects.hash(this.sid, this.accountSid, this.friendlyName, this.description, this.configuration, this.uniqueName, this.dateCreated, this.dateUpdated, this.url, this.links);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("sid", (Object)this.sid).add("accountSid", (Object)this.accountSid).add("friendlyName", (Object)this.friendlyName).add("description", (Object)this.description).add("configuration", this.configuration).add("uniqueName", (Object)this.uniqueName).add("dateCreated", (Object)this.dateCreated).add("dateUpdated", (Object)this.dateUpdated).add("url", (Object)this.url).add("links", this.links).toString();
    }
}

