/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.rest.preview.bulkExports;

import com.twilio.base.Fetcher;
import com.twilio.exception.ApiConnectionException;
import com.twilio.exception.ApiException;
import com.twilio.exception.RestException;
import com.twilio.http.HttpMethod;
import com.twilio.http.Request;
import com.twilio.http.Response;
import com.twilio.http.TwilioRestClient;
import com.twilio.rest.Domains;
import com.twilio.rest.preview.bulkExports.Export;

public class ExportFetcher
extends Fetcher<Export> {
    private final String pathResourceType;

    public ExportFetcher(String pathResourceType) {
        this.pathResourceType = pathResourceType;
    }

    @Override
    public Export fetch(TwilioRestClient client) {
        Request request = new Request(HttpMethod.GET, Domains.PREVIEW.toString(), "/BulkExports/Exports/" + this.pathResourceType + "");
        Response response = client.request(request);
        if (response == null) {
            throw new ApiConnectionException("Export fetch failed: Unable to connect to server");
        }
        if (!TwilioRestClient.SUCCESS.apply((Object)response.getStatusCode())) {
            RestException restException = RestException.fromJson(response.getStream(), client.getObjectMapper());
            if (restException == null) {
                throw new ApiException("Server Error, no content");
            }
            throw new ApiException(restException);
        }
        return Export.fromJson(response.getStream(), client.getObjectMapper());
    }
}

